/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.api.Document;

public class ClaimStatistic {
    private final ConcurrentHashMap<String, IntCounter> licenseNameMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IntCounter> licenseFamilyCategoryMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Document.Type, IntCounter> documentTypeMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Counter, IntCounter> counterMap = new ConcurrentHashMap();

    private int getValue(IntCounter counter) {
        return counter == null ? 0 : counter.value();
    }

    public int getCounter(Counter counter) {
        return this.getValue(this.counterMap.get((Object)counter));
    }

    public void incCounter(Counter counter, int value) {
        this.counterMap.compute(counter, (k, v) -> v == null ? new IntCounter().increment(value) : v.increment(value));
    }

    public int getCounter(Document.Type documentType) {
        return this.getValue(this.documentTypeMap.get((Object)documentType));
    }

    public List<Document.Type> getDocumentTypes() {
        ArrayList<Document.Type> result = new ArrayList<Document.Type>(this.documentTypeMap.keySet());
        result.sort(Comparator.comparing(Enum::name));
        return result;
    }

    public void incCounter(Document.Type documentType, int value) {
        this.documentTypeMap.compute(documentType, (k, v) -> this.updateCounter(Counter.DOCUMENT_TYPES, (IntCounter)v, value));
        switch (documentType) {
            case STANDARD: {
                this.incCounter(Counter.STANDARDS, value);
                break;
            }
            case ARCHIVE: {
                this.incCounter(Counter.ARCHIVES, value);
                break;
            }
            case BINARY: {
                this.incCounter(Counter.BINARIES, value);
                break;
            }
            case NOTICE: {
                this.incCounter(Counter.NOTICES, value);
                break;
            }
            case UNKNOWN: {
                this.incCounter(Counter.UNKNOWN, value);
                break;
            }
            case IGNORED: {
                this.incCounter(Counter.IGNORED, value);
            }
        }
    }

    public int getLicenseCategoryCount(String licenseFamilyCategory) {
        return this.getValue(this.licenseFamilyCategoryMap.get(licenseFamilyCategory));
    }

    public int getLicenseNameCount(String licenseName) {
        return this.getValue(this.licenseNameMap.get(licenseName));
    }

    private IntCounter updateCounter(Counter counter, IntCounter intCounter, int value) {
        if (intCounter == null) {
            this.incCounter(counter, 1);
            return new IntCounter().increment(value);
        }
        return intCounter.increment(value);
    }

    public void incLicenseCategoryCount(String licenseFamilyCategory, int value) {
        this.licenseFamilyCategoryMap.compute(licenseFamilyCategory, (k, v) -> this.updateCounter(Counter.LICENSE_CATEGORIES, (IntCounter)v, value));
    }

    public List<String> getLicenseFamilyCategories() {
        ArrayList<String> result = new ArrayList<String>(this.licenseFamilyCategoryMap.keySet());
        result.sort(String::compareTo);
        return result;
    }

    public List<String> getLicenseNames() {
        ArrayList<String> result = new ArrayList<String>(this.licenseNameMap.keySet());
        result.sort(String::compareTo);
        return result;
    }

    public void incLicenseNameCount(String licenseName, int value) {
        this.licenseNameMap.compute(licenseName, (k, v) -> this.updateCounter(Counter.LICENSE_NAMES, (IntCounter)v, value));
    }

    static class IntCounter {
        private int value;

        IntCounter() {
        }

        public IntCounter increment(int count) {
            this.value += count;
            return this;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Counter {
        APPROVED("A count of approved licenses.", -1, 0),
        ARCHIVES("A count of archive files.", -1, 0),
        BINARIES("A count of binary files.", -1, 0),
        DOCUMENT_TYPES("A count of distinct document types.", -1, 1),
        IGNORED("A count of ignored files.", -1, 0),
        LICENSE_CATEGORIES("A count of distinct license categories.", -1, 1),
        LICENSE_NAMES("A count of distinct license names.", -1, 1),
        NOTICES("A count of notice files.", -1, 0),
        STANDARDS("A count of standard files.", -1, 1),
        UNAPPROVED("A count of unapproved licenses.", 0, 0),
        UNKNOWN("A count of unknown file types.", -1, 0);

        private final String description;
        private final int defaultMaxValue;
        private final int defaultMinValue;

        private Counter(String description, int defaultMaxValue, int defaultMinValue) {
            this.description = description;
            this.defaultMaxValue = defaultMaxValue;
            this.defaultMinValue = defaultMinValue;
        }

        public String getDescription() {
            return this.description;
        }

        public int getDefaultMaxValue() {
            return this.defaultMaxValue;
        }

        public int getDefaultMinValue() {
            return this.defaultMinValue;
        }

        public String displayName() {
            return StringUtils.capitalize(this.name().replaceAll("_", " ").toLowerCase(Locale.ROOT));
        }
    }
}

