/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.core.config.provider;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.core.config.ConfigurationProperties;
import org.opensaml.core.config.ConfigurationPropertiesSource;
import org.opensaml.core.config.provider.PropertiesAdapter;
import org.slf4j.Logger;

public class ClasspathConfigurationPropertiesSource
implements ConfigurationPropertiesSource {
    @Nonnull
    @NotEmpty
    private static final String RESOURCE_NAME = "opensaml-config.properties";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ClasspathConfigurationPropertiesSource.class);
    @Nullable
    private Properties cachedProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ConfigurationProperties getProperties() {
        ClasspathConfigurationPropertiesSource classpathConfigurationPropertiesSource = this;
        synchronized (classpathConfigurationPropertiesSource) {
            if (this.cachedProperties == null) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(RESOURCE_NAME);){
                    if (is != null) {
                        Properties props = new Properties();
                        props.load(is);
                        this.cachedProperties = props;
                    }
                }
                catch (IOException e) {
                    this.log.warn("Problem attempting to load configuration properties 'opensaml-config.properties' from classpath", (Throwable)e);
                }
            }
            return this.cachedProperties != null ? new PropertiesAdapter(this.cachedProperties) : null;
        }
    }
}

