/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Comparator;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.ArrayOfStringsSerDe;
import org.apache.datasketches.common.TestUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.CompactDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesDoublesSketchIterator;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QuantilesSketchCrossLanguageTest {
    private static final String LS = System.getProperty("line.separator");

    @Test(groups={"generate_java_files"})
    public void generateDoublesSketch() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            UpdateDoublesSketch sk = DoublesSketch.builder().build();
            for (int i = 1; i <= n; ++i) {
                sk.update((double)i);
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("quantiles_double_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray());
        }
    }

    @Test(groups={"generate_java_files"})
    public void generateItemsSketchWithStrings() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            ItemsSketch sk = ItemsSketch.getInstance(String.class, (Comparator)new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    try {
                        int i1 = Integer.parseInt(s1);
                        int i2 = Integer.parseInt(s2);
                        return Integer.compare(i1, i2);
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            for (int i = 1; i <= n; ++i) {
                sk.update((Object)Integer.toString(i));
            }
            if (n > 0) {
                Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
                Assert.assertEquals((String)((String)sk.getMaxItem()), (String)Integer.toString(n));
            }
            Files.newOutputStream(TestUtil.javaPath.resolve("quantiles_string_n" + n + "_java.sk"), new OpenOption[0]).write(sk.toByteArray((ArrayOfItemsSerDe)new ArrayOfStringsSerDe()));
        }
    }

    @Test(groups={"check_cpp_files"})
    public void checkDoublesSketch() throws IOException {
        int[] nArr;
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] byteArr = Files.readAllBytes(TestUtil.cppPath.resolve("quantiles_double_n" + n + "_cpp.sk"));
            DoublesSketch sk = DoublesSketch.wrap((Memory)Memory.wrap((byte[])byteArr));
            Assert.assertTrue((boolean)(n == 0 ? sk.isEmpty() : !sk.isEmpty()));
            Assert.assertTrue((boolean)(n > 128 ? sk.isEstimationMode() : !sk.isEstimationMode()));
            Assert.assertEquals((long)sk.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((double)sk.getMinItem(), (double)1.0);
            Assert.assertEquals((double)sk.getMaxItem(), (double)n);
            QuantilesDoublesSketchIterator it = sk.iterator();
            long weight = 0L;
            while (it.next()) {
                Assert.assertTrue((it.getQuantile() >= sk.getMinItem() ? 1 : 0) != 0);
                Assert.assertTrue((it.getQuantile() <= sk.getMaxItem() ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }

    @Test(groups={"check_cpp_files"})
    public void checkItemsSketchWithStrings() throws IOException {
        int[] nArr;
        Comparator<String> numericOrder = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                try {
                    int i1 = Integer.parseInt(s1);
                    int i2 = Integer.parseInt(s2);
                    return Integer.compare(i1, i2);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int n : nArr = new int[]{0, 1, 10, 100, 1000, 10000, 100000, 1000000}) {
            byte[] byteArr = Files.readAllBytes(TestUtil.cppPath.resolve("quantiles_string_n" + n + "_cpp.sk"));
            ItemsSketch sk = ItemsSketch.getInstance(String.class, (Memory)Memory.wrap((byte[])byteArr), (Comparator)numericOrder, (ArrayOfItemsSerDe)new ArrayOfStringsSerDe());
            Assert.assertTrue((boolean)(n == 0 ? sk.isEmpty() : !sk.isEmpty()));
            Assert.assertTrue((boolean)(n > 128 ? sk.isEstimationMode() : !sk.isEstimationMode()));
            Assert.assertEquals((long)sk.getN(), (long)n);
            if (n <= 0) continue;
            Assert.assertEquals((String)((String)sk.getMinItem()), (String)"1");
            Assert.assertEquals((String)((String)sk.getMaxItem()), (String)Integer.toString(n));
            QuantilesGenericSketchIterator it = sk.iterator();
            long weight = 0L;
            while (it.next()) {
                Assert.assertTrue((numericOrder.compare((String)it.getQuantile(), (String)sk.getMinItem()) >= 0 ? 1 : 0) != 0);
                Assert.assertTrue((numericOrder.compare((String)it.getQuantile(), (String)sk.getMaxItem()) <= 0 ? 1 : 0) != 0);
                weight += it.getWeight();
            }
            Assert.assertEquals((long)weight, (long)n);
        }
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check030_50() {
        int n = 50;
        String ver = "0.3.0";
        double expected = 26.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check030_1000() {
        int n = 1000;
        String ver = "0.3.0";
        double expected = 501.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check060_50() {
        int n = 50;
        String ver = "0.6.0";
        double expected = 26.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check060_1000() {
        int n = 1000;
        String ver = "0.6.0";
        double expected = 501.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check080_50() {
        int n = 50;
        String ver = "0.8.0";
        double expected = 26.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check080_1000() {
        int n = 1000;
        String ver = "0.8.0";
        double expected = 501.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check083_50() {
        int n = 50;
        String ver = "0.8.3";
        double expected = 26.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    @Test(groups={"check_cpp_historical_files"})
    public void check083_1000() {
        int n = 1000;
        String ver = "0.8.3";
        double expected = 501.0;
        QuantilesSketchCrossLanguageTest.getAndCheck(ver, n, expected);
    }

    private static void getAndCheck(String ver, int n, double quantile) {
        DoublesSketch.rand.setSeed(131L);
        int k = 128;
        double nf = 0.5;
        String fileName = String.format("Qk%d_n%d_v%s.sk", k, n, ver);
        QuantilesSketchCrossLanguageTest.println("fullName: " + fileName);
        QuantilesSketchCrossLanguageTest.println("Old Median: " + quantile);
        byte[] byteArr = TestUtil.getResourceBytes(fileName);
        Memory srcMem = Memory.wrap((byte[])byteArr);
        UpdateDoublesSketch qs2 = UpdateDoublesSketch.heapify((Memory)srcMem);
        double q2 = qs2.getQuantile(nf, QuantileSearchCriteria.EXCLUSIVE);
        QuantilesSketchCrossLanguageTest.println("New Median: " + q2);
        Assert.assertEquals((double)q2, (double)quantile, (double)0.0);
        qs2 = CompactDoublesSketch.heapify((Memory)srcMem);
        q2 = qs2.getQuantile(nf, QuantileSearchCriteria.EXCLUSIVE);
        QuantilesSketchCrossLanguageTest.println("New Median: " + q2);
        Assert.assertEquals((double)q2, (double)quantile, (double)0.0);
    }

    @Test
    public void printlnTest() {
        QuantilesSketchCrossLanguageTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            QuantilesSketchCrossLanguageTest.print(LS);
        } else {
            QuantilesSketchCrossLanguageTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

