/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.SearchStatistics;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_SearchStats;
import com.google.cloud.bigquery.IndexUnusedReason;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class SearchStats
implements Serializable {
    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_SearchStats.Builder();
    }

    @Nullable
    public abstract String getIndexUsageMode();

    @Nullable
    public abstract List<IndexUnusedReason> getIndexUnusedReasons();

    SearchStatistics toPb() {
        SearchStatistics searchStatistics = new SearchStatistics();
        if (this.getIndexUsageMode() != null) {
            searchStatistics.setIndexUsageMode(this.getIndexUsageMode());
        }
        if (this.getIndexUnusedReasons() != null) {
            searchStatistics.setIndexUnusedReasons(this.getIndexUnusedReasons().stream().map(IndexUnusedReason::toPb).collect(Collectors.toList()));
        }
        return searchStatistics;
    }

    static SearchStats fromPb(SearchStatistics searchStatistics) {
        Builder builder = SearchStats.newBuilder();
        if (searchStatistics.getIndexUsageMode() != null) {
            builder.setIndexUsageMode(searchStatistics.getIndexUsageMode());
        }
        if (searchStatistics.getIndexUnusedReasons() != null) {
            builder.setIndexUnusedReasons(searchStatistics.getIndexUnusedReasons().stream().map(IndexUnusedReason::fromPb).collect(Collectors.toList()));
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setIndexUsageMode(String var1);

        public abstract Builder setIndexUnusedReasons(List<IndexUnusedReason> var1);

        public abstract SearchStats build();
    }
}

