/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileinput.text;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BOMDetector {
    public static final BOMMark[] MARKS = new BOMMark[]{new BOMMark("UTF-8", 239, 187, 191), new BOMMark("UTF-32BE", 0, 0, 254, 255), new BOMMark("UTF-32LE", 255, 254, 0, 0), new BOMMark("UTF-16BE", 254, 255), new BOMMark("UTF-16LE", 255, 254), new BOMMark("GB18030", 132, 49, 149, 51)};
    private final InputStream in;
    private int bomSize;
    private String charset;

    public BOMDetector(BufferedInputStream in) throws IOException {
        this.in = in;
        in.mark(16);
        this.readBOM();
        in.reset();
        in.skip(this.bomSize);
    }

    void readBOM() throws IOException {
        long bom = this.readLong();
        for (BOMMark m : MARKS) {
            if (!m.matches(bom)) continue;
            this.bomSize = m.getBytes();
            this.charset = m.getCharset();
            return;
        }
    }

    public boolean bomExist() {
        return this.charset != null;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getBomSize() {
        return this.bomSize;
    }

    long readLong() throws IOException {
        long[] b = new long[6];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.in.read();
            if (b[i] >= 0L) continue;
            b[i] = 0L;
        }
        long r = 0L;
        for (int i = 0; i < b.length; ++i) {
            r += b[i] << i * 8;
        }
        return r;
    }

    public static class BOMMark {
        private final String charset;
        private final long mark;
        private final long mask;
        private final int bytes;

        public BOMMark(String charset, int ... bytes) {
            this.charset = charset;
            long m = 0L;
            for (int i = 0; i < bytes.length; ++i) {
                m += (long)bytes[i] << i * 8;
            }
            this.mark = m;
            this.mask = (1L << bytes.length * 8) - 1L;
            this.bytes = bytes.length;
        }

        public boolean matches(long bytes) {
            return (bytes & this.mask) == this.mark;
        }

        public int getBytes() {
            return this.bytes;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

