/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.AllocationTagNamespaceType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Evaluable;
import org.apache.hadoop.yarn.api.records.TargetApplications;
import org.apache.hadoop.yarn.exceptions.InvalidAllocationTagException;

public abstract class AllocationTagNamespace
implements Evaluable<TargetApplications> {
    public static final String NAMESPACE_DELIMITER = "/";
    private AllocationTagNamespaceType nsType;
    private Set<ApplicationId> nsScope;

    public AllocationTagNamespace(AllocationTagNamespaceType allocationTagNamespaceType) {
        this.nsType = allocationTagNamespaceType;
    }

    protected void setScopeIfNotNull(Set<ApplicationId> appIds) {
        if (appIds != null) {
            this.nsScope = appIds;
        }
    }

    public AllocationTagNamespaceType getNamespaceType() {
        return this.nsType;
    }

    public Set<ApplicationId> getNamespaceScope() {
        if (this.nsScope == null) {
            throw new IllegalStateException("Invalid namespace scope, it is not initialized. Evaluate must be called before a namespace can be consumed.");
        }
        return this.nsScope;
    }

    @Override
    public abstract void evaluate(TargetApplications var1) throws InvalidAllocationTagException;

    public boolean isGlobal() {
        return AllocationTagNamespaceType.ALL.equals((Object)this.getNamespaceType());
    }

    public boolean isSingleInterApp() {
        return AllocationTagNamespaceType.APP_ID.equals((Object)this.getNamespaceType());
    }

    public boolean isIntraApp() {
        return AllocationTagNamespaceType.SELF.equals((Object)this.getNamespaceType());
    }

    public boolean isNotSelf() {
        return AllocationTagNamespaceType.NOT_SELF.equals((Object)this.getNamespaceType());
    }

    public boolean isAppLabel() {
        return AllocationTagNamespaceType.APP_LABEL.equals((Object)this.getNamespaceType());
    }

    public String toString() {
        return this.nsType.toString();
    }

    public static AllocationTagNamespace parse(String namespaceStr) throws InvalidAllocationTagException {
        if (Strings.isNullOrEmpty((String)namespaceStr)) {
            return new Self();
        }
        List<String> nsValues = AllocationTagNamespace.normalize(namespaceStr);
        String nsPrefix = nsValues.get(0);
        AllocationTagNamespaceType allocationTagNamespaceType = AllocationTagNamespaceType.fromString(nsPrefix);
        switch (allocationTagNamespaceType) {
            case SELF: {
                return new Self();
            }
            case NOT_SELF: {
                return new NotSelf();
            }
            case ALL: {
                return new All();
            }
            case APP_ID: {
                if (nsValues.size() != 2) {
                    throw new InvalidAllocationTagException("Missing the application ID in the namespace string: " + namespaceStr);
                }
                String appIDStr = nsValues.get(1);
                return AllocationTagNamespace.parseAppID(appIDStr);
            }
            case APP_LABEL: {
                return new AppLabel();
            }
        }
        throw new InvalidAllocationTagException("Invalid namespace string " + namespaceStr);
    }

    private static AllocationTagNamespace parseAppID(String appIDStr) throws InvalidAllocationTagException {
        try {
            ApplicationId applicationId = ApplicationId.fromString(appIDStr);
            return new AppID(applicationId);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAllocationTagException("Invalid application ID for " + AllocationTagNamespaceType.APP_ID.getTypeKeyword() + ": " + appIDStr);
        }
    }

    private static List<String> normalize(String namespaceStr) throws InvalidAllocationTagException {
        String[] nsValues;
        ArrayList<String> result = new ArrayList<String>();
        if (namespaceStr == null) {
            return result;
        }
        for (String str : nsValues = namespaceStr.split(NAMESPACE_DELIMITER)) {
            if (Strings.isNullOrEmpty((String)str)) continue;
            result.add(str);
        }
        if (result.size() == 0 || result.size() > 2) {
            throw new InvalidAllocationTagException("Invalid namespace string: " + namespaceStr + ", the syntax is <namespace_prefix> or <namespace_prefix>/<namespace_value>");
        }
        return result;
    }

    public static class AppID
    extends AllocationTagNamespace {
        private ApplicationId targetAppId;

        public AppID(ApplicationId applicationId) {
            super(AllocationTagNamespaceType.APP_ID);
            this.targetAppId = applicationId;
        }

        @Override
        public void evaluate(TargetApplications target) {
            this.setScopeIfNotNull((Set<ApplicationId>)ImmutableSet.of((Object)this.targetAppId));
        }

        @Override
        public String toString() {
            return AllocationTagNamespaceType.APP_ID.toString() + AllocationTagNamespace.NAMESPACE_DELIMITER + this.targetAppId;
        }
    }

    public static class AppLabel
    extends AllocationTagNamespace {
        public AppLabel() {
            super(AllocationTagNamespaceType.APP_LABEL);
        }

        @Override
        public void evaluate(TargetApplications target) {
        }
    }

    public static class All
    extends AllocationTagNamespace {
        public All() {
            super(AllocationTagNamespaceType.ALL);
        }

        @Override
        public void evaluate(TargetApplications target) {
            Set<ApplicationId> allAppIds = target.getAllApplicationIds();
            this.setScopeIfNotNull(allAppIds);
        }
    }

    public static class NotSelf
    extends AllocationTagNamespace {
        private ApplicationId applicationId;

        public NotSelf() {
            super(AllocationTagNamespaceType.NOT_SELF);
        }

        public void setApplicationId(ApplicationId appId) {
            this.applicationId = appId;
        }

        public ApplicationId getApplicationId() {
            return this.applicationId;
        }

        @Override
        public void evaluate(TargetApplications target) {
            Set<ApplicationId> otherAppIds = target.getOtherApplicationIds();
            this.setScopeIfNotNull(otherAppIds);
        }
    }

    public static class Self
    extends AllocationTagNamespace {
        public Self() {
            super(AllocationTagNamespaceType.SELF);
        }

        @Override
        public void evaluate(TargetApplications target) throws InvalidAllocationTagException {
            if (target == null || target.getCurrentApplicationId() == null) {
                throw new InvalidAllocationTagException("Namespace Self must be evaluated against a single application ID.");
            }
            ApplicationId applicationId = target.getCurrentApplicationId();
            this.setScopeIfNotNull((Set<ApplicationId>)ImmutableSet.of((Object)applicationId));
        }
    }
}

