/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.hybrid.tiered.common;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.disk.DiskTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.memory.MemoryTierFactory;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.remote.RemoteTierFactory;

public class TieredStorageConfiguration {
    private static final String DEFAULT_REMOTE_STORAGE_BASE_PATH = null;
    private static final int DEFAULT_TIERED_STORAGE_BUFFER_SIZE = 32768;
    private static final int DEFAULT_MEMORY_TIER_EXCLUSIVE_BUFFERS = 100;
    private static final int DEFAULT_DISK_TIER_EXCLUSIVE_BUFFERS = 1;
    private static final int DEFAULT_REMOTE_TIER_EXCLUSIVE_BUFFERS = 1;
    private static final int DEFAULT_MEMORY_TIER_SUBPARTITION_MAX_QUEUED_BUFFERS = 3;
    private static final int DEFAULT_NUM_BUFFERS_USE_SORT_ACCUMULATOR_THRESHOLD = 512;
    private static final int DEFAULT_MEMORY_TIER_NUM_BYTES_PER_SEGMENT = 65536;
    private static final int DEFAULT_DISK_TIER_NUM_BYTES_PER_SEGMENT = 524288;
    private static final int DEFAULT_REMOTE_TIER_NUM_BYTES_PER_SEGMENT = 524288;
    private static final float DEFAULT_NUM_BUFFERS_TRIGGER_FLUSH_RATIO = 0.6f;
    private static final int DEFAULT_DISK_TIER_MAX_BUFFERS_READ_AHEAD = 5;
    private static final Duration DEFAULT_DISK_TIER_BUFFER_REQUEST_TIMEOUT = Duration.ofMinutes(5L);
    private static final float DEFAULT_MIN_RESERVE_DISK_SPACE_FRACTION = 0.05f;
    private static final int DEFAULT_REGION_GROUP_SIZE_IN_BYTES = 1024;
    private static final long DEFAULT_MAX_REGION_NUM_RETAINED_IN_MEMORY = 0x100000L;
    private static final int DEFAULT_MAX_CACHED_BYTES_BEFORE_FLUSH = 524288;
    private final String remoteStorageBasePath;
    private final int tieredStorageBufferSize;
    private final int memoryTierExclusiveBuffers;
    private final int diskTierExclusiveBuffers;
    private final int remoteTierExclusiveBuffers;
    private final int accumulatorExclusiveBuffers;
    private final int memoryTierNumBytesPerSegment;
    private final int diskTierNumBytesPerSegment;
    private final int remoteTierNumBytesPerSegment;
    private final float numBuffersTriggerFlushRatio;
    private final Duration diskIOSchedulerRequestTimeout;
    private final float minReserveDiskSpaceFraction;
    private final List<TierFactory> tierFactories;
    private final List<Integer> tierExclusiveBuffers;

    public TieredStorageConfiguration(String remoteStorageBasePath, int tieredStorageBufferSize, int memoryTierExclusiveBuffers, int diskTierExclusiveBuffers, int remoteTierExclusiveBuffers, int accumulatorExclusiveBuffers, int memoryTierNumBytesPerSegment, int diskTierNumBytesPerSegment, int remoteTierNumBytesPerSegment, float numBuffersTriggerFlushRatio, Duration diskIOSchedulerRequestTimeout, float minReserveDiskSpaceFraction, List<TierFactory> tierFactories, List<Integer> tierExclusiveBuffers) {
        this.remoteStorageBasePath = remoteStorageBasePath;
        this.tieredStorageBufferSize = tieredStorageBufferSize;
        this.memoryTierExclusiveBuffers = memoryTierExclusiveBuffers;
        this.diskTierExclusiveBuffers = diskTierExclusiveBuffers;
        this.remoteTierExclusiveBuffers = remoteTierExclusiveBuffers;
        this.accumulatorExclusiveBuffers = accumulatorExclusiveBuffers;
        this.memoryTierNumBytesPerSegment = memoryTierNumBytesPerSegment;
        this.diskTierNumBytesPerSegment = diskTierNumBytesPerSegment;
        this.remoteTierNumBytesPerSegment = remoteTierNumBytesPerSegment;
        this.numBuffersTriggerFlushRatio = numBuffersTriggerFlushRatio;
        this.diskIOSchedulerRequestTimeout = diskIOSchedulerRequestTimeout;
        this.minReserveDiskSpaceFraction = minReserveDiskSpaceFraction;
        this.tierFactories = tierFactories;
        this.tierExclusiveBuffers = tierExclusiveBuffers;
    }

    public static Builder builder(String remoteStorageBasePath) {
        return new Builder().setRemoteStorageBasePath(remoteStorageBasePath);
    }

    public static Builder builder(int tieredStorageBufferSize, String remoteStorageBasePath) {
        return new Builder().setTieredStorageBufferSize(tieredStorageBufferSize).setRemoteStorageBasePath(remoteStorageBasePath);
    }

    public String getRemoteStorageBasePath() {
        return this.remoteStorageBasePath;
    }

    public int getTieredStorageBufferSize() {
        return this.tieredStorageBufferSize;
    }

    public int getMemoryTierExclusiveBuffers() {
        return this.memoryTierExclusiveBuffers;
    }

    public int getDiskTierExclusiveBuffers() {
        return this.diskTierExclusiveBuffers;
    }

    public int getRemoteTierExclusiveBuffers() {
        return this.remoteTierExclusiveBuffers;
    }

    public int getAccumulatorExclusiveBuffers() {
        return this.accumulatorExclusiveBuffers;
    }

    public int getMemoryTierNumBytesPerSegment() {
        return this.memoryTierNumBytesPerSegment;
    }

    public int getDiskTierNumBytesPerSegment() {
        return this.diskTierNumBytesPerSegment;
    }

    public int getRemoteTierNumBytesPerSegment() {
        return this.remoteTierNumBytesPerSegment;
    }

    public float getNumBuffersTriggerFlushRatio() {
        return this.numBuffersTriggerFlushRatio;
    }

    public Duration getDiskIOSchedulerBufferRequestTimeout() {
        return this.diskIOSchedulerRequestTimeout;
    }

    public float getMinReserveDiskSpaceFraction() {
        return this.minReserveDiskSpaceFraction;
    }

    public int getTotalExclusiveBufferNum() {
        return this.accumulatorExclusiveBuffers + this.memoryTierExclusiveBuffers + this.diskTierExclusiveBuffers + (this.remoteStorageBasePath == null ? 0 : this.remoteTierExclusiveBuffers);
    }

    public List<Integer> getEachTierExclusiveBufferNum() {
        return this.tierExclusiveBuffers;
    }

    public List<TierFactory> getTierFactories() {
        return this.tierFactories;
    }

    static /* synthetic */ String access$000() {
        return DEFAULT_REMOTE_STORAGE_BASE_PATH;
    }

    static /* synthetic */ Duration access$100() {
        return DEFAULT_DISK_TIER_BUFFER_REQUEST_TIMEOUT;
    }

    public static class Builder {
        private String remoteStorageBasePath = TieredStorageConfiguration.access$000();
        private int tieredStorageBufferSize = 32768;
        private int memoryTierExclusiveBuffers = 100;
        private int diskTierExclusiveBuffers = 1;
        private int remoteTierExclusiveBuffers = 1;
        private int memoryTierSubpartitionMaxQueuedBuffers = 3;
        private int numBuffersUseSortAccumulatorThreshold = 512;
        private int memoryTierNumBytesPerSegment = 65536;
        private int diskTierNumBytesPerSegment = 524288;
        private int remoteTierNumBytesPerSegment = 524288;
        private float numBuffersTriggerFlushRatio = 0.6f;
        private Duration diskTierBufferRequestTimeout = TieredStorageConfiguration.access$100();
        private float minReserveDiskSpaceFraction = 0.05f;
        private int regionGroupSizeInBytes = 1024;
        private long numRetainedInMemoryRegionsMax = 0x100000L;
        private int maxCachedBytesBeforeFlush = 524288;
        private List<TierFactory> tierFactories;
        private List<Integer> tierExclusiveBuffers;

        public Builder setRemoteStorageBasePath(String remoteStorageBasePath) {
            this.remoteStorageBasePath = remoteStorageBasePath;
            return this;
        }

        public Builder setTieredStorageBufferSize(int tieredStorageBufferSize) {
            this.tieredStorageBufferSize = tieredStorageBufferSize;
            return this;
        }

        public Builder setMemoryTierExclusiveBuffers(int memoryTierExclusiveBuffers) {
            this.memoryTierExclusiveBuffers = memoryTierExclusiveBuffers;
            return this;
        }

        public Builder setDiskTierExclusiveBuffers(int diskTierExclusiveBuffers) {
            this.diskTierExclusiveBuffers = diskTierExclusiveBuffers;
            return this;
        }

        public Builder setRemoteTierExclusiveBuffers(int remoteTierExclusiveBuffers) {
            this.remoteTierExclusiveBuffers = remoteTierExclusiveBuffers;
            return this;
        }

        public Builder setNumBuffersUseSortAccumulatorThreshold(int numBuffersUseSortAccumulatorThreshold) {
            this.numBuffersUseSortAccumulatorThreshold = numBuffersUseSortAccumulatorThreshold;
            return this;
        }

        public Builder setMemoryTierNumBytesPerSegment(int memoryTierNumBytesPerSegment) {
            this.memoryTierNumBytesPerSegment = memoryTierNumBytesPerSegment;
            return this;
        }

        public Builder setDiskTierNumBytesPerSegment(int diskTierNumBytesPerSegment) {
            this.diskTierNumBytesPerSegment = diskTierNumBytesPerSegment;
            return this;
        }

        public Builder setRemoteTierNumBytesPerSegment(int remoteTierNumBytesPerSegment) {
            this.remoteTierNumBytesPerSegment = remoteTierNumBytesPerSegment;
            return this;
        }

        public Builder setMemoryTierSubpartitionMaxQueuedBuffers(int memoryTierSubpartitionMaxQueuedBuffers) {
            this.memoryTierSubpartitionMaxQueuedBuffers = memoryTierSubpartitionMaxQueuedBuffers;
            return this;
        }

        public Builder setNumBuffersTriggerFlushRatio(float numBuffersTriggerFlushRatio) {
            this.numBuffersTriggerFlushRatio = numBuffersTriggerFlushRatio;
            return this;
        }

        public Builder setDiskTierBufferRequestTimeout(Duration diskTierBufferRequestTimeout) {
            this.diskTierBufferRequestTimeout = diskTierBufferRequestTimeout;
            return this;
        }

        public Builder setMinReserveDiskSpaceFraction(float minReserveDiskSpaceFraction) {
            this.minReserveDiskSpaceFraction = minReserveDiskSpaceFraction;
            return this;
        }

        public Builder setRegionGroupSizeInBytes(int regionGroupSizeInBytes) {
            this.regionGroupSizeInBytes = regionGroupSizeInBytes;
            return this;
        }

        public Builder setNumRetainedInMemoryRegionsMax(long numRetainedInMemoryRegionsMax) {
            this.numRetainedInMemoryRegionsMax = numRetainedInMemoryRegionsMax;
            return this;
        }

        public Builder setMaxCachedBytesBeforeFlush(int maxCachedBytesBeforeFlush) {
            this.maxCachedBytesBeforeFlush = maxCachedBytesBeforeFlush;
            return this;
        }

        public TieredStorageConfiguration build() {
            this.setupTierFactoriesAndExclusiveBuffers();
            return new TieredStorageConfiguration(this.remoteStorageBasePath, this.tieredStorageBufferSize, this.memoryTierExclusiveBuffers, this.diskTierExclusiveBuffers, this.remoteTierExclusiveBuffers, this.numBuffersUseSortAccumulatorThreshold, this.memoryTierNumBytesPerSegment, this.diskTierNumBytesPerSegment, this.remoteTierNumBytesPerSegment, this.numBuffersTriggerFlushRatio, this.diskTierBufferRequestTimeout, this.minReserveDiskSpaceFraction, this.tierFactories, this.tierExclusiveBuffers);
        }

        private void setupTierFactoriesAndExclusiveBuffers() {
            this.tierFactories = new ArrayList<TierFactory>();
            this.tierExclusiveBuffers = new ArrayList<Integer>();
            this.tierFactories.add(new MemoryTierFactory(this.memoryTierNumBytesPerSegment, this.tieredStorageBufferSize, this.memoryTierSubpartitionMaxQueuedBuffers));
            this.tierExclusiveBuffers.add(this.memoryTierExclusiveBuffers);
            this.tierFactories.add(new DiskTierFactory(this.diskTierNumBytesPerSegment, this.tieredStorageBufferSize, this.minReserveDiskSpaceFraction, this.regionGroupSizeInBytes, this.maxCachedBytesBeforeFlush, this.numRetainedInMemoryRegionsMax));
            this.tierExclusiveBuffers.add(this.diskTierExclusiveBuffers);
            if (this.remoteStorageBasePath != null) {
                this.tierFactories.add(new RemoteTierFactory(this.remoteTierNumBytesPerSegment, this.tieredStorageBufferSize, this.remoteStorageBasePath));
                this.tierExclusiveBuffers.add(this.remoteTierExclusiveBuffers);
            }
        }
    }
}

