/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.NativeScalarFunction;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class BytesConversionFcts {
    public static final Function VarcharAsBlobFct = new NativeScalarFunction("varcharasblob", (AbstractType)BytesType.instance, new AbstractType[]{UTF8Type.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            return parameters.get(0);
        }
    };
    public static final Function BlobAsVarcharFct = new NativeScalarFunction("blobasvarchar", (AbstractType)UTF8Type.instance, new AbstractType[]{BytesType.instance}){

        @Override
        public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
            return parameters.get(0);
        }
    };

    public static Collection<Function> all() {
        ArrayList<Function> functions = new ArrayList<Function>();
        HashSet types = new HashSet();
        for (CQL3Type.Native type : CQL3Type.Native.values()) {
            AbstractType<?> udfType;
            if (type == CQL3Type.Native.BLOB || !types.add(udfType = type.getType().udfType())) continue;
            functions.add(BytesConversionFcts.makeToBlobFunction(type.getType().udfType()));
            functions.add(BytesConversionFcts.makeFromBlobFunction(type.getType().udfType()));
        }
        functions.add(VarcharAsBlobFct);
        functions.add(BlobAsVarcharFct);
        return functions;
    }

    public static Function makeToBlobFunction(AbstractType<?> fromType) {
        String name = fromType.asCQL3Type() + "asblob";
        return new NativeScalarFunction(name, (AbstractType)BytesType.instance, new AbstractType[]{fromType}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) {
                return parameters.get(0);
            }
        };
    }

    public static Function makeFromBlobFunction(final AbstractType<?> toType) {
        String name = "blobas" + toType.asCQL3Type();
        return new NativeScalarFunction(name, (AbstractType)toType, new AbstractType[]{BytesType.instance}){

            @Override
            public ByteBuffer execute(ProtocolVersion protocolVersion, List<ByteBuffer> parameters) throws InvalidRequestException {
                ByteBuffer val = parameters.get(0);
                try {
                    if (val != null) {
                        toType.validate(val);
                    }
                    return val;
                }
                catch (MarshalException e) {
                    throw new InvalidRequestException(String.format("In call to function %s, value 0x%s is not a valid binary representation for type %s", this.name, ByteBufferUtil.bytesToHex(val), toType.asCQL3Type()));
                }
            }
        };
    }
}

