/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.ReadQuery;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.monitoring.MonitorableImpl;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.schema.TableMetadata;

abstract class AbstractReadQuery
extends MonitorableImpl
implements ReadQuery {
    private final TableMetadata metadata;
    private final int nowInSec;
    private final ColumnFilter columnFilter;
    private final RowFilter rowFilter;
    private final DataLimits limits;

    protected AbstractReadQuery(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits) {
        this.metadata = metadata;
        this.nowInSec = nowInSec;
        this.columnFilter = columnFilter;
        this.rowFilter = rowFilter;
        this.limits = limits;
    }

    @Override
    public TableMetadata metadata() {
        return this.metadata;
    }

    @Override
    public String name() {
        return this.toCQLString();
    }

    @Override
    public PartitionIterator executeInternal(ReadExecutionController controller) {
        return UnfilteredPartitionIterators.filter(this.executeLocally(controller), this.nowInSec());
    }

    @Override
    public DataLimits limits() {
        return this.limits;
    }

    @Override
    public int nowInSec() {
        return this.nowInSec;
    }

    @Override
    public RowFilter rowFilter() {
        return this.rowFilter;
    }

    @Override
    public ColumnFilter columnFilter() {
        return this.columnFilter;
    }

    public String toCQLString() {
        StringBuilder sb = new StringBuilder().append("SELECT ").append(this.columnFilter().toCQLString()).append(" FROM ").append(ColumnIdentifier.maybeQuote(this.metadata().keyspace)).append('.').append(ColumnIdentifier.maybeQuote(this.metadata().name));
        this.appendCQLWhereClause(sb);
        if (this.limits() != DataLimits.NONE) {
            sb.append(' ').append(this.limits());
        }
        sb.append(" ALLOW FILTERING");
        return sb.toString();
    }

    protected abstract void appendCQLWhereClause(StringBuilder var1);
}

