/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.SSTableId;
import org.apache.cassandra.io.sstable.SSTableIdFactory;
import org.apache.cassandra.io.sstable.format.SSTableFormat;
import org.apache.cassandra.io.sstable.format.Version;
import org.apache.cassandra.io.sstable.metadata.IMetadataSerializer;
import org.apache.cassandra.io.sstable.metadata.MetadataSerializer;
import org.apache.cassandra.io.util.File;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.TimeUUID;

public class Descriptor {
    private static final String LEGACY_TMP_REGEX_STR = "^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$";
    private static final Pattern LEGACY_TMP_REGEX = Pattern.compile("^((.*)\\-(.*)\\-)?tmp(link)?\\-((?:l|k).)\\-(\\d)*\\-(.*)$");
    public static String TMP_EXT = ".tmp";
    public static final char FILENAME_SEPARATOR = '-';
    private static final Splitter filenameSplitter = Splitter.on((char)'-');
    public final File directory;
    public final Version version;
    public final String ksname;
    public final String cfname;
    public final SSTableId id;
    public final SSTableFormat.Type formatType;
    private final int hashCode;

    @VisibleForTesting
    public Descriptor(File directory, String ksname, String cfname, SSTableId id) {
        this(SSTableFormat.Type.current().info.getLatestVersion(), directory, ksname, cfname, id, SSTableFormat.Type.current());
    }

    public Descriptor(File directory, String ksname, String cfname, SSTableId id, SSTableFormat.Type formatType) {
        this(formatType.info.getLatestVersion(), directory, ksname, cfname, id, formatType);
    }

    @VisibleForTesting
    public Descriptor(String version, File directory, String ksname, String cfname, SSTableId id, SSTableFormat.Type formatType) {
        this(formatType.info.getVersion(version), directory, ksname, cfname, id, formatType);
    }

    public Descriptor(Version version, File directory, String ksname, String cfname, SSTableId id, SSTableFormat.Type formatType) {
        assert (version != null && directory != null && ksname != null && cfname != null && formatType.info.getLatestVersion().getClass().equals(version.getClass()));
        this.version = version;
        this.directory = directory.toCanonical();
        this.ksname = ksname;
        this.cfname = cfname;
        this.id = id;
        this.formatType = formatType;
        this.hashCode = Objects.hashCode((Object[])new Object[]{version, id, ksname, cfname, formatType});
    }

    public String tmpFilenameFor(Component component) {
        return this.filenameFor(component) + TMP_EXT;
    }

    public String tmpFilenameForStreaming(Component component) {
        return String.format("%s.%s%s", this.filenameFor(component), TimeUUID.Generator.nextTimeUUID(), TMP_EXT);
    }

    public String filenameFor(Component component) {
        return this.baseFilename() + '-' + component.name();
    }

    public File fileFor(Component component) {
        return new File(this.filenameFor(component));
    }

    public String baseFilename() {
        StringBuilder buff = new StringBuilder();
        buff.append(this.directory).append(File.pathSeparator());
        this.appendFileName(buff);
        return buff.toString();
    }

    private void appendFileName(StringBuilder buff) {
        buff.append(this.version).append('-');
        buff.append(this.id.toString());
        buff.append('-').append(this.formatType.name);
    }

    public String relativeFilenameFor(Component component) {
        StringBuilder buff = new StringBuilder();
        if (Directories.isSecondaryIndexFolder(this.directory)) {
            buff.append(this.directory.name()).append(File.pathSeparator());
        }
        this.appendFileName(buff);
        buff.append('-').append(component.name());
        return buff.toString();
    }

    public SSTableFormat getFormat() {
        return this.formatType.info;
    }

    public List<File> getTemporaryFiles() {
        File[] tmpFiles = this.directory.tryList((dir, name) -> name.endsWith(TMP_EXT));
        ArrayList<File> ret = new ArrayList<File>(tmpFiles.length);
        for (File tmpFile : tmpFiles) {
            ret.add(tmpFile);
        }
        return ret;
    }

    public static boolean isValidFile(File file) {
        String filename = file.name();
        return filename.endsWith(".db") && !LEGACY_TMP_REGEX.matcher(filename).matches();
    }

    public static Descriptor fromFilename(String filename) {
        return Descriptor.fromFilename(new File(filename));
    }

    public static Descriptor fromFilename(File file) {
        return (Descriptor)Descriptor.fromFilenameWithComponent((File)file).left;
    }

    public static Pair<Descriptor, Component> fromFilenameWithComponent(File file) {
        File directory;
        SSTableFormat.Type format;
        SSTableId id;
        String name;
        List tokens;
        int size;
        if (!file.isAbsolute()) {
            file = file.toAbsolute();
        }
        if ((size = (tokens = filenameSplitter.splitToList((CharSequence)(name = file.name()))).size()) != 4) {
            if (size == 5 || size == 6) {
                throw new IllegalArgumentException(String.format("%s is of version %s which is now unsupported and cannot be read.", name, tokens.get(size - 3)));
            }
            throw new IllegalArgumentException(String.format("Invalid sstable file %s: the name doesn't look like a supported sstable file name", name));
        }
        String versionString = (String)tokens.get(0);
        if (!Version.validate(versionString)) {
            throw Descriptor.invalidSSTable(name, "invalid version %s", versionString);
        }
        try {
            id = SSTableIdFactory.instance.fromString((String)tokens.get(1));
        }
        catch (RuntimeException e) {
            throw Descriptor.invalidSSTable(name, "the 'id' part (%s) of the name doesn't parse as a valid unique identifier", tokens.get(1));
        }
        String formatString = (String)tokens.get(2);
        try {
            format = SSTableFormat.Type.validate(formatString);
        }
        catch (RuntimeException e) {
            throw Descriptor.invalidSSTable(name, "unknown 'format' part (%s)", formatString);
        }
        Component component = Component.parse((String)tokens.get(3));
        Version version = format.info.getVersion(versionString);
        if (!version.isCompatible()) {
            throw Descriptor.invalidSSTable(name, "incompatible sstable version (%s); you should have run upgradesstables before upgrading", versionString);
        }
        File tableDir = directory = Descriptor.parentOf(name, file);
        String indexName = "";
        if (Directories.isSecondaryIndexFolder(tableDir)) {
            indexName = tableDir.name();
            tableDir = Descriptor.parentOf(name, tableDir);
        }
        if (tableDir.name().equals("backups") && tableDir.parent().name().contains("-")) {
            tableDir = tableDir.parent();
        } else {
            File keyspaceOrSnapshotDir = Descriptor.parentOf(name, tableDir);
            if (keyspaceOrSnapshotDir.name().equals("snapshots") && Descriptor.parentOf(name, keyspaceOrSnapshotDir).name().contains("-")) {
                tableDir = Descriptor.parentOf(name, keyspaceOrSnapshotDir);
            }
        }
        String table = tableDir.name().split("-")[0] + indexName;
        String keyspace = Descriptor.parentOf(name, tableDir).name();
        return Pair.create(new Descriptor(version, directory, keyspace, table, id, format), component);
    }

    private static File parentOf(String name, File file) {
        File parent = file.parent();
        if (parent == null) {
            throw Descriptor.invalidSSTable(name, "cannot extract keyspace and table name; make sure the sstable is in the proper sub-directories", new Object[0]);
        }
        return parent;
    }

    private static IllegalArgumentException invalidSSTable(String name, String msgFormat, Object ... parameters) {
        throw new IllegalArgumentException(String.format("Invalid sstable file " + name + ": " + msgFormat, parameters));
    }

    public IMetadataSerializer getMetadataSerializer() {
        return new MetadataSerializer();
    }

    public boolean isCompatible() {
        return this.version.isCompatible();
    }

    public String toString() {
        return this.baseFilename();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor that = (Descriptor)o;
        return that.directory.equals(this.directory) && that.id.equals(this.id) && that.ksname.equals(this.ksname) && that.cfname.equals(this.cfname) && that.version.equals(this.version) && that.formatType == this.formatType;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

