/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.FieldIdentifier;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.schema.CQLTypeParser;
import org.apache.cassandra.schema.Diff;
import org.apache.cassandra.schema.Difference;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class Types
implements Iterable<UserType> {
    private static final Types NONE = new Types((Map<ByteBuffer, UserType>)ImmutableMap.of());
    private final Map<ByteBuffer, UserType> types;

    private Types(Builder builder) {
        this.types = builder.types.build();
    }

    private Types(Map<ByteBuffer, UserType> types) {
        this.types = types;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RawBuilder rawBuilder(String keyspace) {
        return new RawBuilder(keyspace);
    }

    public static Types none() {
        return NONE;
    }

    public static Types of(UserType ... types) {
        return Types.builder().add(types).build();
    }

    @Override
    public Iterator<UserType> iterator() {
        return this.types.values().iterator();
    }

    public Stream<UserType> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<UserType> sortedStream() {
        LinkedHashSet sorted = new LinkedHashSet();
        this.types.values().forEach(t -> Types.addUserTypes(t, sorted));
        return sorted.stream().map(n -> this.types.get(n));
    }

    public Iterable<UserType> referencingUserType(ByteBuffer name) {
        return Iterables.filter(this.types.values(), t -> t.referencesUserType(name) && !t.name.equals(name));
    }

    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    public Optional<UserType> get(ByteBuffer name) {
        return Optional.ofNullable(this.types.get(name));
    }

    @Nullable
    public UserType getNullable(ByteBuffer name) {
        return this.types.get(name);
    }

    boolean containsType(ByteBuffer name) {
        return this.types.containsKey(name);
    }

    Types filter(Predicate<UserType> predicate) {
        Builder builder = Types.builder();
        this.types.values().stream().filter(predicate).forEach(builder::add);
        return builder.build();
    }

    public Types with(UserType type) {
        if (this.get(type.name).isPresent()) {
            throw new IllegalStateException(String.format("Type %s already exists", type.name));
        }
        return Types.builder().add(this).add(type).build();
    }

    public Types without(ByteBuffer name) {
        UserType type = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Type %s doesn't exists", name)));
        return this.without(type);
    }

    public Types without(UserType type) {
        return this.filter(t -> t != type);
    }

    public Types withUpdatedUserType(UserType udt) {
        return Iterables.any((Iterable)this, t -> t.referencesUserType(udt.name)) ? Types.builder().add(Iterables.transform((Iterable)this, t -> t.withUpdatedUserType(udt))).build() : this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Types)) {
            return false;
        }
        Types other = (Types)o;
        if (this.types.size() != other.types.size()) {
            return false;
        }
        Iterator<Map.Entry<ByteBuffer, UserType>> thisIter = this.types.entrySet().iterator();
        Iterator<Map.Entry<ByteBuffer, UserType>> otherIter = other.types.entrySet().iterator();
        while (thisIter.hasNext()) {
            Map.Entry<ByteBuffer, UserType> thisNext = thisIter.next();
            Map.Entry<ByteBuffer, UserType> otherNext = otherIter.next();
            if (!thisNext.getKey().equals(otherNext.getKey())) {
                return false;
            }
            if (thisNext.getValue().equals(otherNext.getValue())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.types.hashCode();
    }

    public String toString() {
        return this.types.values().toString();
    }

    private static Set<ByteBuffer> sortByDependencies(Collection<UserType> types) {
        LinkedHashSet<ByteBuffer> sorted = new LinkedHashSet<ByteBuffer>();
        types.stream().forEach(t -> Types.addUserTypes(t, sorted));
        return sorted;
    }

    private static void addUserTypes(AbstractType<?> type, Set<ByteBuffer> types) {
        type.subTypes().forEach(t -> Types.addUserTypes(t, types));
        if (type.isUDT()) {
            types.add(((UserType)type).name);
        }
    }

    static TypesDiff diff(Types before, Types after) {
        return TypesDiff.diff(before, after);
    }

    static final class TypesDiff
    extends Diff<Types, UserType> {
        private static final TypesDiff NONE = new TypesDiff(Types.none(), Types.none(), (ImmutableCollection<Diff.Altered<UserType>>)ImmutableList.of());

        private TypesDiff(Types created, Types dropped, ImmutableCollection<Diff.Altered<UserType>> altered) {
            super(created, dropped, altered);
        }

        private static TypesDiff diff(Types before, Types after) {
            if (before == after) {
                return NONE;
            }
            Types created = after.filter(t -> !before.containsType(t.name));
            Types dropped = before.filter(t -> !after.containsType(t.name));
            ImmutableList.Builder altered = ImmutableList.builder();
            before.forEach(typeBefore -> {
                UserType typeAfter = after.getNullable(typeBefore.name);
                if (null != typeAfter) {
                    typeBefore.compare(typeAfter).ifPresent(kind -> altered.add(new Diff.Altered<UserType>((UserType)typeBefore, typeAfter, (Difference)((Object)((Object)kind)))));
                }
            });
            return new TypesDiff(created, dropped, (ImmutableCollection<Diff.Altered<UserType>>)altered.build());
        }
    }

    public static final class RawBuilder {
        final String keyspace;
        final List<RawUDT> definitions;

        private RawBuilder(String keyspace) {
            this.keyspace = keyspace;
            this.definitions = new ArrayList<RawUDT>();
        }

        public Types build() {
            if (this.definitions.isEmpty()) {
                return Types.none();
            }
            HashMap vertices = Maps.newHashMapWithExpectedSize((int)this.definitions.size());
            for (RawUDT rawUDT : this.definitions) {
                vertices.put(rawUDT, 0);
            }
            HashMultimap adjacencyList = HashMultimap.create();
            for (RawUDT rawUDT : this.definitions) {
                for (RawUDT rawUDT2 : this.definitions) {
                    if (rawUDT == rawUDT2 || !rawUDT.referencesUserType(rawUDT2)) continue;
                    adjacencyList.put((Object)rawUDT2, (Object)rawUDT);
                }
            }
            adjacencyList.values().forEach(vertex -> vertices.put(vertex, (Integer)vertices.get(vertex) + 1));
            LinkedList<Object> linkedList = new LinkedList<Object>();
            for (Map.Entry entry : vertices.entrySet()) {
                if ((Integer)entry.getValue() != 0) continue;
                linkedList.add(entry.getKey());
            }
            Types types = new Types(new HashMap());
            while (!linkedList.isEmpty()) {
                RawUDT rawUDT = (RawUDT)linkedList.remove();
                for (RawUDT dependentType : adjacencyList.get((Object)rawUDT)) {
                    if (vertices.replace(dependentType, (Integer)vertices.get(dependentType) - 1) != 1) continue;
                    linkedList.add(dependentType);
                }
                UserType userType = rawUDT.prepare(this.keyspace, types);
                types.types.put(userType.name, userType);
            }
            if (types.types.size() != this.definitions.size()) {
                throw new ConfigurationException(String.format("Cannot resolve UDTs for keyspace %s: some types are missing", this.keyspace));
            }
            return Types.builder().add(types).build();
        }

        public void add(String name, List<String> fieldNames, List<String> fieldTypes) {
            List<CQL3Type.Raw> rawFieldTypes = fieldTypes.stream().map(CQLTypeParser::parseRaw).collect(Collectors.toList());
            this.definitions.add(new RawUDT(name, fieldNames, rawFieldTypes));
        }

        private static final class RawUDT {
            final String name;
            final List<String> fieldNames;
            final List<CQL3Type.Raw> fieldTypes;

            RawUDT(String name, List<String> fieldNames, List<CQL3Type.Raw> fieldTypes) {
                this.name = name;
                this.fieldNames = fieldNames;
                this.fieldTypes = fieldTypes;
            }

            boolean referencesUserType(RawUDT other) {
                return this.fieldTypes.stream().anyMatch(t -> t.referencesUserType(other.name));
            }

            UserType prepare(String keyspace, Types types) {
                List<FieldIdentifier> preparedFieldNames = this.fieldNames.stream().map(FieldIdentifier::forInternalString).collect(Collectors.toList());
                List<AbstractType<?>> preparedFieldTypes = this.fieldTypes.stream().map(t -> t.prepareInternal(keyspace, types).getType()).collect(Collectors.toList());
                return new UserType(keyspace, ByteBufferUtil.bytes(this.name), preparedFieldNames, preparedFieldTypes, true);
            }

            public int hashCode() {
                return this.name.hashCode();
            }

            public boolean equals(Object other) {
                return this.name.equals(((RawUDT)other).name);
            }
        }
    }

    public static final class Builder {
        final ImmutableSortedMap.Builder<ByteBuffer, UserType> types = ImmutableSortedMap.naturalOrder();

        private Builder() {
        }

        public Types build() {
            return new Types(this);
        }

        public Builder add(UserType type) {
            assert (type.isMultiCell());
            this.types.put((Object)type.name, (Object)type);
            return this;
        }

        public Builder add(UserType ... types) {
            for (UserType type : types) {
                this.add(type);
            }
            return this;
        }

        public Builder add(Iterable<UserType> types) {
            types.forEach(this::add);
            return this;
        }
    }
}

