/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Map;
import java.util.TreeMap;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;

public class CommonObjectMetadata
implements StorageObjectMetadata {
    private long contentLength;
    private final Map<String, String> userDefinedMetadata;
    private String contentEncoding;

    CommonObjectMetadata() {
        this.userDefinedMetadata = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    }

    CommonObjectMetadata(long contentLength, String contentEncoding, Map<String, String> userDefinedMetadata) {
        this.contentEncoding = contentEncoding;
        this.contentLength = contentLength;
        this.userDefinedMetadata = SnowflakeUtil.createCaseInsensitiveMap(userDefinedMetadata);
    }

    @Override
    public Map<String, String> getUserMetadata() {
        return this.userDefinedMetadata;
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    @Override
    public void addUserMetadata(String key, String value) {
        this.userDefinedMetadata.put(key, value);
    }

    @Override
    public void setContentEncoding(String encoding) {
        this.contentEncoding = encoding;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }
}

