/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.cloud.storage;

import java.util.Map;
import java.util.Properties;
import net.snowflake.client.core.HttpUtil;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.cloud.storage.CommonObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.S3ObjectMetadata;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeAzureClient;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeGCSClient;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeS3Client;
import net.snowflake.client.jdbc.cloud.storage.SnowflakeStorageClient;
import net.snowflake.client.jdbc.cloud.storage.StageInfo;
import net.snowflake.client.jdbc.cloud.storage.StorageObjectMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.ClientConfiguration;
import net.snowflake.client.jdbc.internal.snowflake.common.core.RemoteStoreFileEncryptionMaterial;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

public class StorageClientFactory {
    private static final SFLogger logger = SFLoggerFactory.getLogger(StorageClientFactory.class);
    private static StorageClientFactory factory;

    private StorageClientFactory() {
    }

    public static StorageClientFactory getFactory() {
        if (factory == null) {
            factory = new StorageClientFactory();
        }
        return factory;
    }

    public SnowflakeStorageClient createClient(StageInfo stage, int parallel, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws SnowflakeSQLException {
        logger.debug("Creating storage client. Client type: {}", stage.getStageType().name());
        switch (stage.getStageType()) {
            case S3: {
                boolean useS3RegionalUrl = stage.getUseS3RegionalUrl() || stage.getUseRegionalUrl() || session != null && session.getUseRegionalS3EndpointsForPresignedURL();
                return this.createS3Client(stage.getCredentials(), parallel, encMat, stage.getProxyProperties(), stage.getRegion(), stage.getEndPoint(), stage.getIsClientSideEncrypted(), session, useS3RegionalUrl);
            }
            case AZURE: {
                return this.createAzureClient(stage, encMat, session);
            }
            case GCS: {
                return this.createGCSClient(stage, encMat, session);
            }
        }
        throw new IllegalArgumentException("Unsupported storage client specified: " + stage.getStageType().name());
    }

    private SnowflakeS3Client createS3Client(Map<?, ?> stageCredentials, int parallel, RemoteStoreFileEncryptionMaterial encMat, Properties proxyProperties, String stageRegion, String stageEndPoint, boolean isClientSideEncrypted, SFBaseSession session, boolean useS3RegionalUrl) throws SnowflakeSQLException {
        SnowflakeS3Client s3Client;
        int S3_TRANSFER_MAX_RETRIES = 3;
        logger.debug("Creating S3 client with encryption: {}", encMat == null ? "no" : "yes");
        ClientConfiguration clientConfig = new ClientConfiguration();
        clientConfig.setMaxConnections(parallel + 1);
        clientConfig.setMaxErrorRetry(3);
        clientConfig.setDisableSocketProxy(HttpUtil.isSocksProxyDisabled());
        clientConfig.setProxyHost("");
        clientConfig.setProxyPort(0);
        clientConfig.setProxyUsername("");
        clientConfig.setProxyPassword("");
        logger.debug("S3 client configuration: maxConnection: {}, connectionTimeout: {}, socketTimeout: {}, maxErrorRetry: {}", clientConfig.getMaxConnections(), clientConfig.getConnectionTimeout(), clientConfig.getSocketTimeout(), clientConfig.getMaxErrorRetry());
        try {
            s3Client = new SnowflakeS3Client(stageCredentials, clientConfig, encMat, proxyProperties, stageRegion, stageEndPoint, isClientSideEncrypted, session, useS3RegionalUrl);
        }
        catch (Exception ex) {
            logger.debug("Exception creating s3 client", ex);
            throw ex;
        }
        logger.debug("S3 Storage client created", false);
        return s3Client;
    }

    public StorageObjectMetadata createStorageMetadataObj(StageInfo.StageType stageType) {
        switch (stageType) {
            case S3: {
                return new S3ObjectMetadata();
            }
            case AZURE: 
            case GCS: {
                return new CommonObjectMetadata();
            }
        }
        throw new IllegalArgumentException("Unsupported stage type specified: " + stageType.name());
    }

    private SnowflakeAzureClient createAzureClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFBaseSession session) throws SnowflakeSQLException {
        SnowflakeAzureClient azureClient;
        logger.debug("Creating Azure client with encryption: {}", encMat == null ? "no" : "yes");
        try {
            azureClient = SnowflakeAzureClient.createSnowflakeAzureClient(stage, encMat, session);
        }
        catch (Exception ex) {
            logger.debug("Exception creating Azure Storage client", ex);
            throw ex;
        }
        logger.debug("Azure Storage client created", false);
        return azureClient;
    }

    private SnowflakeGCSClient createGCSClient(StageInfo stage, RemoteStoreFileEncryptionMaterial encMat, SFSession session) throws SnowflakeSQLException {
        SnowflakeGCSClient gcsClient;
        logger.debug("Creating GCS client with encryption: {}", encMat == null ? "no" : "yes");
        try {
            gcsClient = SnowflakeGCSClient.createSnowflakeGCSClient(stage, encMat, session);
        }
        catch (Exception ex) {
            logger.debug("Exception creating GCS Storage client", ex);
            throw ex;
        }
        logger.debug("GCS Storage client created", false);
        return gcsClient;
    }
}

