/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.snowflake.client.jdbc.internal.com.nimbusds.jose.jwk.JWKSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.jwt.JWTClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Identifier;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Issuer;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.id.Subject;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.util.MapUtils;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.CommonFederationClaimsSet;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.EntityType;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.trust.constraints.TrustChainConstraints;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkEntry;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.trust.marks.TrustMarkIssuerMetadata;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONArray;
import net.snowflake.client.jdbc.internal.net.minidev.json.JSONObject;

public class EntityStatementClaimsSet
extends CommonFederationClaimsSet {
    public static final String JWKS_CLAIM_NAME = "jwks";
    public static final String AUTHORITY_HINTS_CLAIM_NAME = "authority_hints";
    public static final String METADATA_POLICY_CLAIM_NAME = "metadata_policy";
    public static final String TRUST_ANCHOR_ID_CLAIM_NAME = "trust_anchor_id";
    public static final String CONSTRAINTS_CLAIM_NAME = "constraints";
    public static final String TRUST_MARKS_ISSUERS_CLAIM_NAME = "trust_marks_issuers";
    public static final String CRITICAL_CLAIM_NAME = "crit";
    public static final String POLICY_LANGUAGE_CRITICAL_CLAIM_NAME = "policy_language_crit";
    private static final Set<String> STD_CLAIM_NAMES;

    public static Set<String> getStandardClaimNames() {
        return STD_CLAIM_NAMES;
    }

    public EntityStatementClaimsSet(Issuer iss, Subject sub, Date iat, Date exp, JWKSet jwks) {
        this(new EntityID(iss.getValue()), new EntityID(sub.getValue()), iat, exp, jwks);
    }

    public EntityStatementClaimsSet(EntityID iss, EntityID sub, Date iat, Date exp, JWKSet jwks) {
        this.setClaim("iss", iss.getValue());
        this.setClaim("sub", sub.getValue());
        if (iat == null) {
            throw new IllegalArgumentException("The iat (issued-at) claim must not be null");
        }
        this.setDateClaim("iat", iat);
        if (exp == null) {
            throw new IllegalArgumentException("The exp (expiration) claim must not be null");
        }
        this.setDateClaim("exp", exp);
        if (jwks != null) {
            this.setClaim(JWKS_CLAIM_NAME, new JSONObject(jwks.toJSONObject(true)));
        }
    }

    public EntityStatementClaimsSet(JWTClaimsSet jwtClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jwtClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    @Override
    public void validateRequiredClaimsPresence() throws ParseException {
        super.validateRequiredClaimsPresence();
        if (this.isSelfStatement() && this.getJWKSet() == null) {
            throw new ParseException("Missing jwks (JWK set) claim");
        }
        if (this.isSelfStatement() && !this.hasMetadata()) {
            throw new ParseException("Missing required metadata claim for self-statement");
        }
        List<String> crit = this.getCriticalExtensionClaims();
        if (crit != null) {
            for (String claimName : crit) {
                if (this.getClaim(claimName) != null) continue;
                throw new ParseException("Missing critical " + claimName + " claim");
            }
        }
    }

    public boolean isSelfStatement() {
        Issuer issuer = this.getIssuer();
        Subject subject = this.getSubject();
        return issuer != null && subject != null && issuer.getValue().equals(subject.getValue());
    }

    public JWKSet getJWKSet() {
        JSONObject jwkSetJSONObject = this.getJSONObjectClaim(JWKS_CLAIM_NAME);
        if (jwkSetJSONObject == null) {
            return null;
        }
        try {
            return JWKSet.parse(jwkSetJSONObject);
        }
        catch (java.text.ParseException e) {
            return null;
        }
    }

    public List<EntityID> getAuthorityHints() {
        List<String> strings = this.getStringListClaim(AUTHORITY_HINTS_CLAIM_NAME);
        if (strings == null) {
            return null;
        }
        LinkedList<EntityID> trustChain = new LinkedList<EntityID>();
        for (String s2 : strings) {
            trustChain.add(new EntityID(s2));
        }
        return trustChain;
    }

    public void setAuthorityHints(List<EntityID> trustChain) {
        if (trustChain != null) {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, Identifier.toStringList(trustChain));
        } else {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, null);
        }
    }

    public boolean hasMetadata() {
        JSONObject metadataObject = this.getJSONObjectClaim("metadata");
        if (MapUtils.isEmpty(metadataObject)) {
            return false;
        }
        if (metadataObject.get(EntityType.OPENID_RELYING_PARTY.getValue()) != null) {
            return true;
        }
        if (metadataObject.get(EntityType.OPENID_PROVIDER.getValue()) != null) {
            return true;
        }
        if (metadataObject.get(EntityType.OAUTH_AUTHORIZATION_SERVER.getValue()) != null) {
            return true;
        }
        if (metadataObject.get(EntityType.OAUTH_CLIENT.getValue()) != null) {
            return true;
        }
        if (metadataObject.get(EntityType.OAUTH_RESOURCE.getValue()) != null) {
            return true;
        }
        if (metadataObject.get(EntityType.FEDERATION_ENTITY.getValue()) != null) {
            return true;
        }
        return metadataObject.get(EntityType.TRUST_MARK_ISSUER.getValue()) != null;
    }

    public OIDCClientInformation getRPInformation() {
        JSONObject o = this.getMetadata(EntityType.OPENID_RELYING_PARTY);
        if (o == null) {
            return null;
        }
        try {
            return OIDCClientInformation.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setRPInformation(OIDCClientInformation rpInfo) {
        JSONObject o = rpInfo != null ? rpInfo.toJSONObject() : null;
        this.setMetadata(EntityType.OPENID_RELYING_PARTY, o);
    }

    @Deprecated
    public void setTrustMarkIssuerMetadata(TrustMarkIssuerMetadata trustMarkIssuerMetadata) {
        JSONObject o = trustMarkIssuerMetadata != null ? trustMarkIssuerMetadata.toJSONObject() : null;
        this.setMetadata(EntityType.TRUST_MARK_ISSUER, o);
    }

    public JSONObject getMetadataPolicyJSONObject() {
        return this.getJSONObjectClaim(METADATA_POLICY_CLAIM_NAME);
    }

    public void setMetadataPolicyJSONObject(JSONObject metadataPolicy) {
        this.setClaim(METADATA_POLICY_CLAIM_NAME, metadataPolicy);
    }

    public MetadataPolicy getMetadataPolicy(EntityType type) throws PolicyViolationException {
        JSONObject o = this.getMetadataPolicyJSONObject();
        if (o == null) {
            return null;
        }
        try {
            JSONObject policyJSONObject = JSONObjectUtils.getJSONObject(o, type.getValue(), null);
            if (policyJSONObject == null) {
                return null;
            }
            return MetadataPolicy.parse(policyJSONObject);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setMetadataPolicy(EntityType type, MetadataPolicy metadataPolicy) {
        JSONObject o = this.getMetadataPolicyJSONObject();
        if (o == null) {
            if (metadataPolicy == null) {
                return;
            }
            o = new JSONObject();
        }
        if (metadataPolicy != null) {
            o.put(type.getValue(), metadataPolicy.toJSONObject());
        } else {
            o.remove(type.getValue());
        }
        if (o.isEmpty()) {
            o = null;
        }
        this.setMetadataPolicyJSONObject(o);
    }

    public EntityID getTrustAnchorID() {
        String value = this.getStringClaim(TRUST_ANCHOR_ID_CLAIM_NAME);
        try {
            return EntityID.parse(value);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setTrustAnchorID(EntityID trustAnchorID) {
        if (trustAnchorID != null) {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, trustAnchorID.getValue());
        } else {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, null);
        }
    }

    public TrustChainConstraints getConstraints() {
        JSONObject o = this.getJSONObjectClaim(CONSTRAINTS_CLAIM_NAME);
        if (o == null) {
            return null;
        }
        try {
            return TrustChainConstraints.parse(o);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setConstraints(TrustChainConstraints constraints) {
        if (constraints != null) {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, constraints.toJSONObject());
        } else {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, null);
        }
    }

    @Override
    public void setTrustMarks(List<TrustMarkEntry> marks) {
        if (marks != null) {
            JSONArray array = new JSONArray();
            for (TrustMarkEntry en : marks) {
                array.add(en.toJSONObject());
            }
            this.setClaim("trust_marks", array);
        } else {
            this.setClaim("trust_marks", null);
        }
    }

    public Map<Identifier, List<Issuer>> getTrustMarksIssuers() {
        JSONObject o = this.getJSONObjectClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME);
        if (o == null) {
            return null;
        }
        HashMap<Identifier, List<Issuer>> issuers = new HashMap<Identifier, List<Issuer>>();
        for (String id : o.keySet()) {
            try {
                LinkedList<Issuer> issuerList = new LinkedList<Issuer>();
                for (String issuerString : JSONObjectUtils.getStringList(o, id)) {
                    issuerList.add(new Issuer(issuerString));
                }
                issuers.put(new Identifier(id), issuerList);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return issuers;
    }

    public void setTrustMarksIssuers(Map<Identifier, List<Issuer>> issuers) {
        if (issuers != null) {
            JSONObject issuersObject = new JSONObject();
            for (Map.Entry<Identifier, List<Issuer>> en : issuers.entrySet()) {
                issuersObject.put(en.getKey().getValue(), Issuer.toStringList((Collection<? extends Identifier>)en.getValue()));
                this.setClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME, issuersObject);
            }
        } else {
            this.setClaim(TRUST_MARKS_ISSUERS_CLAIM_NAME, null);
        }
    }

    public List<String> getCriticalExtensionClaims() {
        return this.getStringListClaim(CRITICAL_CLAIM_NAME);
    }

    public void setCriticalExtensionClaims(List<String> claimNames) {
        if (claimNames != null && claimNames.isEmpty()) {
            throw new IllegalArgumentException("The critical extension claim names must not be empty");
        }
        this.setClaim(CRITICAL_CLAIM_NAME, claimNames);
    }

    public List<String> getCriticalPolicyExtensions() {
        return this.getStringListClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME);
    }

    public void setCriticalPolicyExtensions(List<String> extNames) {
        if (extNames != null && extNames.isEmpty()) {
            throw new IllegalArgumentException("The critical policy extension names must not be empty");
        }
        this.setClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME, extNames);
    }

    static {
        HashSet<String> claimNames = new HashSet<String>();
        claimNames.add("iss");
        claimNames.add("sub");
        claimNames.add("iat");
        claimNames.add("exp");
        claimNames.add(JWKS_CLAIM_NAME);
        claimNames.add("aud");
        claimNames.add(AUTHORITY_HINTS_CLAIM_NAME);
        claimNames.add("metadata");
        claimNames.add(METADATA_POLICY_CLAIM_NAME);
        claimNames.add(CONSTRAINTS_CLAIM_NAME);
        claimNames.add(CRITICAL_CLAIM_NAME);
        claimNames.add(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME);
        claimNames.add("trust_marks");
        claimNames.add(TRUST_MARKS_ISSUERS_CLAIM_NAME);
        claimNames.add(TRUST_ANCHOR_ID_CLAIM_NAME);
        STD_CLAIM_NAMES = Collections.unmodifiableSet(claimNames);
    }
}

