/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.socks;

import java.util.Collections;
import java.util.List;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.socks.SocksAuthScheme;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequest;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.handler.codec.socks.SocksRequestType;
import net.snowflake.client.jdbc.internal.grpc.netty.shaded.io.netty.util.internal.ObjectUtil;

public final class SocksInitRequest
extends SocksRequest {
    private final List<SocksAuthScheme> authSchemes;

    public SocksInitRequest(List<SocksAuthScheme> authSchemes) {
        super(SocksRequestType.INIT);
        this.authSchemes = ObjectUtil.checkNotNull(authSchemes, "authSchemes");
    }

    public List<SocksAuthScheme> authSchemes() {
        return Collections.unmodifiableList(this.authSchemes);
    }

    @Override
    public void encodeAsByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.protocolVersion().byteValue());
        byteBuf.writeByte(this.authSchemes.size());
        for (SocksAuthScheme authScheme : this.authSchemes) {
            byteBuf.writeByte(authScheme.byteValue());
        }
    }
}

