/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.Internal;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancer;
import net.snowflake.client.jdbc.internal.grpc.LoadBalancerProvider;
import net.snowflake.client.jdbc.internal.grpc.NameResolver;
import net.snowflake.client.jdbc.internal.grpc.Status;
import net.snowflake.client.jdbc.internal.grpc.xds.PriorityLoadBalancer;

@Internal
public final class PriorityLoadBalancerProvider
extends LoadBalancerProvider {
    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public String getPolicyName() {
        return "priority_experimental";
    }

    @Override
    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new PriorityLoadBalancer(helper);
    }

    @Override
    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        return NameResolver.ConfigOrError.fromError(Status.INTERNAL.withDescription(this.getPolicyName() + " cannot be used from service config"));
    }

    static final class PriorityLbConfig {
        final Map<String, PriorityChildConfig> childConfigs;
        final List<String> priorities;

        PriorityLbConfig(Map<String, PriorityChildConfig> childConfigs, List<String> priorities) {
            this.childConfigs = Collections.unmodifiableMap(Preconditions.checkNotNull(childConfigs, "childConfigs"));
            this.priorities = Collections.unmodifiableList(Preconditions.checkNotNull(priorities, "priorities"));
            Preconditions.checkArgument(!priorities.isEmpty(), "priority list is empty");
            Preconditions.checkArgument(childConfigs.keySet().containsAll(priorities), "missing child config for at lease one of the priorities");
            Preconditions.checkArgument(priorities.size() == new HashSet<String>(priorities).size(), "duplicate names in priorities");
            Preconditions.checkArgument(priorities.size() == childConfigs.keySet().size(), "some names in childConfigs are not referenced by priorities");
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("childConfigs", this.childConfigs).add("priorities", this.priorities).toString();
        }

        static final class PriorityChildConfig {
            final Object childConfig;
            final boolean ignoreReresolution;

            PriorityChildConfig(Object childConfig, boolean ignoreReresolution) {
                this.childConfig = Preconditions.checkNotNull(childConfig, "childConfig");
                this.ignoreReresolution = ignoreReresolution;
            }

            public String toString() {
                return MoreObjects.toStringHelper(this).add("childConfig", this.childConfig).add("ignoreReresolution", this.ignoreReresolution).toString();
            }
        }
    }
}

