/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.export.MemoryMode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ThrottlingLogger;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.Aggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.PointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.DropAggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.ExplicitBucketHistogramAggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.LastValueAggregation;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.view.SumAggregation;

public final class DefaultAggregation
implements Aggregation,
AggregatorFactory {
    private static final Aggregation INSTANCE = new DefaultAggregation();
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DefaultAggregation.class.getName()));

    public static Aggregation getInstance() {
        return INSTANCE;
    }

    private DefaultAggregation() {
    }

    private static Aggregation resolve(InstrumentDescriptor instrument, boolean withAdvice) {
        switch (instrument.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case OBSERVABLE_COUNTER: 
            case OBSERVABLE_UP_DOWN_COUNTER: {
                return SumAggregation.getInstance();
            }
            case HISTOGRAM: {
                if (withAdvice && instrument.getAdvice().getExplicitBucketBoundaries() != null) {
                    return ExplicitBucketHistogramAggregation.create(instrument.getAdvice().getExplicitBucketBoundaries());
                }
                return ExplicitBucketHistogramAggregation.getDefault();
            }
            case OBSERVABLE_GAUGE: 
            case GAUGE: {
                return LastValueAggregation.getInstance();
            }
        }
        logger.log(Level.WARNING, "Unable to find default aggregation for instrument: " + instrument);
        return DropAggregation.getInstance();
    }

    @Override
    public <T extends PointData, U extends ExemplarData> Aggregator<T, U> createAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarFilter exemplarFilter, MemoryMode memoryMode) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, true))).createAggregator(instrumentDescriptor, exemplarFilter, memoryMode);
    }

    @Override
    public boolean isCompatibleWithInstrument(InstrumentDescriptor instrumentDescriptor) {
        return ((AggregatorFactory)((Object)DefaultAggregation.resolve(instrumentDescriptor, false))).isCompatibleWithInstrument(instrumentDescriptor);
    }

    public String toString() {
        return "DefaultAggregation";
    }
}

