/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.pgpencryptstream;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.pgpencryptstream.PGPEncryptStreamMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class PGPEncryptStreamDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = PGPEncryptStreamMeta.class;
    private boolean gotPreviousFields = false;
    private TextVar wGPGLocation;
    private Label wlKeyName;
    private TextVar wKeyName;
    private CCombo wStreamFieldName;
    private TextVar wResult;
    private final PGPEncryptStreamMeta input;
    private Button wKeyNameFromField;
    private Label wlKeyNameFieldName;
    private CCombo wKeyNameFieldName;

    public PGPEncryptStreamDialog(Shell parent, IVariables variables, PGPEncryptStreamMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wGPGGroup = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wGPGGroup);
        wGPGGroup.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.GPGGroup.Label", (String[])new String[0]));
        FormLayout gpggroupgrouplayout = new FormLayout();
        gpggroupgrouplayout.marginWidth = 10;
        gpggroupgrouplayout.marginHeight = 10;
        wGPGGroup.setLayout((Layout)gpggroupgrouplayout);
        Label wlGPGLocation = new Label((Composite)wGPGGroup, 131072);
        wlGPGLocation.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.GPGLocationField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGPGLocation);
        FormData fdlGPGLocation = new FormData();
        fdlGPGLocation.left = new FormAttachment(0, 0);
        fdlGPGLocation.right = new FormAttachment(middle, -margin);
        fdlGPGLocation.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        wlGPGLocation.setLayoutData((Object)fdlGPGLocation);
        Button wbbGpgExe = new Button((Composite)wGPGGroup, 0x1000008);
        PropsUi.setLook((Widget)wbbGpgExe);
        wbbGpgExe.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.BrowseFiles.Label", (String[])new String[0]));
        FormData fdbbGpgExe = new FormData();
        fdbbGpgExe.right = new FormAttachment(100, -margin);
        fdbbGpgExe.top = new FormAttachment((Control)this.wTransformName, margin);
        wbbGpgExe.setLayoutData((Object)fdbbGpgExe);
        if (wbbGpgExe != null) {
            wbbGpgExe.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wGPGLocation, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true));
        }
        this.wGPGLocation = new TextVar(this.variables, (Composite)wGPGGroup, 18436);
        this.wGPGLocation.setToolTipText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.GPGLocationField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wGPGLocation);
        this.wGPGLocation.addModifyListener(lsMod);
        FormData fdGPGLocation = new FormData();
        fdGPGLocation.left = new FormAttachment(middle, 0);
        fdGPGLocation.top = new FormAttachment((Control)this.wTransformName, margin * 2);
        fdGPGLocation.right = new FormAttachment((Control)wbbGpgExe, -margin);
        this.wGPGLocation.setLayoutData((Object)fdGPGLocation);
        this.wlKeyName = new Label((Composite)wGPGGroup, 131072);
        this.wlKeyName.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.KeyNameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlKeyName);
        FormData fdlKeyName = new FormData();
        fdlKeyName.left = new FormAttachment(0, 0);
        fdlKeyName.right = new FormAttachment(middle, -margin);
        fdlKeyName.top = new FormAttachment((Control)this.wGPGLocation, margin);
        this.wlKeyName.setLayoutData((Object)fdlKeyName);
        this.wKeyName = new TextVar(this.variables, (Composite)wGPGGroup, 18436);
        this.wKeyName.setToolTipText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.KeyNameField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wKeyName);
        this.wKeyName.addModifyListener(lsMod);
        FormData fdKeyName = new FormData();
        fdKeyName.left = new FormAttachment(middle, 0);
        fdKeyName.top = new FormAttachment((Control)this.wGPGLocation, margin);
        fdKeyName.right = new FormAttachment(100, 0);
        this.wKeyName.setLayoutData((Object)fdKeyName);
        Label wlKeyNameFromField = new Label((Composite)wGPGGroup, 131072);
        wlKeyNameFromField.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.KeyNameFromField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKeyNameFromField);
        FormData fdlKeyNameFromField = new FormData();
        fdlKeyNameFromField.left = new FormAttachment(0, 0);
        fdlKeyNameFromField.top = new FormAttachment((Control)this.wKeyName, margin);
        fdlKeyNameFromField.right = new FormAttachment(middle, -margin);
        wlKeyNameFromField.setLayoutData((Object)fdlKeyNameFromField);
        this.wKeyNameFromField = new Button((Composite)wGPGGroup, 32);
        PropsUi.setLook((Widget)this.wKeyNameFromField);
        this.wKeyNameFromField.setToolTipText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.KeyNameFromField.Tooltip", (String[])new String[0]));
        FormData fdKeyNameFromField = new FormData();
        fdKeyNameFromField.left = new FormAttachment(middle, 0);
        fdKeyNameFromField.top = new FormAttachment((Control)wlKeyNameFromField, 0, 0x1000000);
        this.wKeyNameFromField.setLayoutData((Object)fdKeyNameFromField);
        this.wKeyNameFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PGPEncryptStreamDialog.this.keyNameFromField();
                PGPEncryptStreamDialog.this.input.setChanged();
            }
        });
        this.wlKeyNameFieldName = new Label((Composite)wGPGGroup, 131072);
        this.wlKeyNameFieldName.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.KeyNameFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlKeyNameFieldName);
        FormData fdlKeyNameFieldName = new FormData();
        fdlKeyNameFieldName.left = new FormAttachment(0, 0);
        fdlKeyNameFieldName.right = new FormAttachment(middle, -margin);
        fdlKeyNameFieldName.top = new FormAttachment((Control)this.wKeyNameFromField, margin);
        this.wlKeyNameFieldName.setLayoutData((Object)fdlKeyNameFieldName);
        this.wKeyNameFieldName = new CCombo((Composite)wGPGGroup, 2056);
        PropsUi.setLook((Widget)this.wKeyNameFieldName);
        this.wKeyNameFieldName.addModifyListener(lsMod);
        FormData fdKeyNameFieldName = new FormData();
        fdKeyNameFieldName.left = new FormAttachment(middle, 0);
        fdKeyNameFieldName.top = new FormAttachment((Control)this.wKeyNameFromField, margin);
        fdKeyNameFieldName.right = new FormAttachment(100, -margin);
        this.wKeyNameFieldName.setLayoutData((Object)fdKeyNameFieldName);
        this.wKeyNameFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)PGPEncryptStreamDialog.this.shell.getDisplay(), 1);
                PGPEncryptStreamDialog.this.shell.setCursor(busy);
                PGPEncryptStreamDialog.this.get();
                PGPEncryptStreamDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdGPGGroup = new FormData();
        fdGPGGroup.left = new FormAttachment(0, margin);
        fdGPGGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGPGGroup.right = new FormAttachment(100, -margin);
        wGPGGroup.setLayoutData((Object)fdGPGGroup);
        Label wlStreamFieldName = new Label((Composite)this.shell, 131072);
        wlStreamFieldName.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.StreamFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamFieldName);
        FormData fdlStreamFieldName = new FormData();
        fdlStreamFieldName.left = new FormAttachment(0, 0);
        fdlStreamFieldName.right = new FormAttachment(middle, -margin);
        fdlStreamFieldName.top = new FormAttachment((Control)wGPGGroup, 2 * margin);
        wlStreamFieldName.setLayoutData((Object)fdlStreamFieldName);
        this.wStreamFieldName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wStreamFieldName);
        this.wStreamFieldName.addModifyListener(lsMod);
        FormData fdStreamFieldName = new FormData();
        fdStreamFieldName.left = new FormAttachment(middle, 0);
        fdStreamFieldName.top = new FormAttachment((Control)wGPGGroup, 2 * margin);
        fdStreamFieldName.right = new FormAttachment(100, -margin);
        this.wStreamFieldName.setLayoutData((Object)fdStreamFieldName);
        this.wStreamFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)PGPEncryptStreamDialog.this.shell.getDisplay(), 1);
                PGPEncryptStreamDialog.this.shell.setCursor(busy);
                PGPEncryptStreamDialog.this.get();
                PGPEncryptStreamDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.ResultField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wStreamFieldName, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wStreamFieldName, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wResult);
        this.getData();
        this.keyNameFromField();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.input.getGPGLocation() != null) {
            this.wGPGLocation.setText(this.input.getGPGLocation());
        }
        if (this.input.getStreamField() != null) {
            this.wStreamFieldName.setText(this.input.getStreamField());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        if (this.input.getKeyName() != null) {
            this.wKeyName.setText(this.input.getKeyName());
        }
        this.wKeyNameFromField.setSelection(this.input.isKeynameInField());
        if (this.input.getKeynameFieldName() != null) {
            this.wKeyNameFieldName.setText(this.input.getKeynameFieldName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setStreamField(this.wStreamFieldName.getText());
        this.input.setGPGLocation(this.wGPGLocation.getText());
        this.input.setKeyName(this.wKeyName.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setKeynameInField(this.wKeyNameFromField.getSelection());
        this.input.setKeynameFieldName(this.wKeyNameFieldName.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void keyNameFromField() {
        this.wlKeyName.setEnabled(!this.wKeyNameFromField.getSelection());
        this.wKeyName.setEnabled(!this.wKeyNameFromField.getSelection());
        this.wlKeyNameFieldName.setEnabled(this.wKeyNameFromField.getSelection());
        this.wKeyNameFieldName.setEnabled(this.wKeyNameFromField.getSelection());
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String fieldvalue = this.wStreamFieldName.getText();
                this.wStreamFieldName.removeAll();
                String keyNameFieldNameText = this.wKeyNameFieldName.getText();
                this.wKeyNameFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wStreamFieldName.setItems(r.getFieldNames());
                    this.wKeyNameFieldName.setItems(r.getFieldNames());
                }
                if (fieldvalue != null) {
                    this.wStreamFieldName.setText(fieldvalue);
                }
                if (keyNameFieldNameText != null) {
                    this.wKeyNameFieldName.setText(keyNameFieldNameText);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PGPEncryptStreamDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

