/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.commands;

import io.github.spannm.jackcess.Column;
import io.github.spannm.jackcess.ConstraintViolationException;
import io.github.spannm.jackcess.DataType;
import io.github.spannm.jackcess.Database;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.complex.ComplexValueForeignKey;
import io.github.spannm.jackcess.impl.ColumnImpl;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import net.ucanaccess.commands.AutoNumberAction;
import net.ucanaccess.commands.BlobAction;
import net.ucanaccess.commands.DeleteCommand;
import net.ucanaccess.commands.ICommand;
import net.ucanaccess.commands.IFeedbackAction;
import net.ucanaccess.complex.Attachment;
import net.ucanaccess.complex.ComplexBase;
import net.ucanaccess.complex.SingleValue;
import net.ucanaccess.complex.Version;
import net.ucanaccess.converters.Persist2Jet;
import net.ucanaccess.exception.UcanaccessSQLException;
import net.ucanaccess.jdbc.DBReference;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.triggers.AutoNumberManager;

public class InsertCommand
implements ICommand {
    private final String tableName;
    private Database dbIO;
    private Object[] newRow;
    private final String execId;
    private Table table;

    public InsertCommand(String _tableName, Database _dbIo, Object[] _newRow, String _execId) {
        this.tableName = _tableName;
        this.dbIO = _dbIo;
        this.newRow = _newRow;
        this.execId = _execId;
    }

    public InsertCommand(Table _table, Object[] _newRow, String _execId) {
        this.table = _table;
        this.tableName = _table.getName();
        this.newRow = _newRow;
        this.execId = _execId;
    }

    @Override
    public String getExecId() {
        return this.execId;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public ICommand.CommandType getType() {
        return ICommand.CommandType.INSERT;
    }

    private Object[] mementoRow() {
        Object[] clone = new Object[this.newRow.length];
        int i = 0;
        Object[] objectArray = this.newRow;
        int n = objectArray.length;
        for (int j = 0; j < n; ++j) {
            Object obj;
            clone[i] = obj = objectArray[j];
            ++i;
        }
        return clone;
    }

    private void initComplex() {
        for (int i = 0; i < this.newRow.length; ++i) {
            if (!(this.newRow[i] instanceof ComplexBase)) continue;
            this.newRow[i] = Column.AUTO_NUMBER;
        }
    }

    public void insertRow(Table _table) throws IOException {
        try {
            _table.addRow(this.newRow);
        }
        catch (ConstraintViolationException _ex) {
            List lc = _table.getColumns();
            boolean retry = false;
            for (Column col : lc) {
                if (!col.isAutoNumber()) continue;
                retry = true;
                break;
            }
            if (!retry) {
                throw _ex;
            }
            Database db = _table.getDatabase();
            File fl = db.getFile();
            DBReferenceSingleton dbsin = DBReferenceSingleton.getInstance();
            DBReference ref = dbsin.getReference(fl);
            ref.reloadDbIO();
            this.dbIO = ref.getDbIO();
            _table = this.dbIO.getTable(this.tableName);
            _table.addRow(this.newRow);
        }
    }

    @Override
    public IFeedbackAction persist() throws SQLException {
        try {
            AutoNumberAction ana = null;
            if (this.table == null) {
                this.table = this.dbIO.getTable(this.tableName);
            }
            Object[] memento = this.mementoRow();
            this.initComplex();
            int j = 0;
            List<Column> colList = this.table.getColumns();
            if (this.table.getDatabase().getColumnOrder().equals((Object)Table.ColumnOrder.DISPLAY)) {
                Object[] newRowReorded = new Object[this.newRow.length];
                Column[] cllReorded = new Column[this.newRow.length];
                for (Column col : this.table.getColumns()) {
                    newRowReorded[col.getColumnIndex()] = this.newRow[j];
                    memento[col.getColumnIndex()] = this.newRow[j];
                    cllReorded[col.getColumnIndex()] = col;
                    ++j;
                }
                this.newRow = newRowReorded;
                colList = Arrays.asList(cllReorded);
            }
            this.insertRow(this.table);
            j = 0;
            for (Column col : colList) {
                ColumnImpl colImpl = (ColumnImpl)col;
                if (colImpl.isAutoNumber() && !memento[j].equals(this.newRow[j]) && !colImpl.getAutoNumberGenerator().getType().equals((Object)DataType.COMPLEX_TYPE)) {
                    if (colImpl.getAutoNumberGenerator().getType().equals((Object)DataType.LONG)) {
                        AutoNumberManager.reset((Column)colImpl, (Integer)this.newRow[j]);
                    }
                    ana = new AutoNumberAction(this.table, memento, this.newRow);
                }
                if (colImpl.getType() == DataType.COMPLEX_TYPE) {
                    ComplexBase[] vs;
                    ComplexValueForeignKey rowFk = (ComplexValueForeignKey)colImpl.getRowValue(this.newRow);
                    if (memento[j] instanceof Attachment[]) {
                        Attachment[] atcs = (Attachment[])memento[j];
                        for (ComplexBase complexBase : atcs) {
                            rowFk.addAttachment(((Attachment)complexBase).getUrl(), ((Attachment)complexBase).getName(), ((Attachment)complexBase).getType(), ((Attachment)complexBase).getData(), ((Attachment)complexBase).getTimeStamp(), ((Attachment)complexBase).getFlags());
                        }
                    } else if (memento[j] instanceof SingleValue[]) {
                        vs = (SingleValue[])memento[j];
                        for (ComplexBase complexBase : vs) {
                            rowFk.addMultiValue(((SingleValue)complexBase).getValue());
                        }
                    } else if (memento[j] instanceof Version[]) {
                        vs = (Version[])memento[j];
                        for (ComplexBase complexBase : vs) {
                            rowFk.addVersion(((Version)complexBase).getValue(), ((Version)complexBase).getModifiedDate());
                        }
                    }
                }
                ++j;
            }
            BlobAction ba = new BlobAction(this.table, this.newRow);
            ba.doAction(this);
            return ana;
        }
        catch (IOException _ex) {
            throw new UcanaccessSQLException(_ex);
        }
    }

    @Override
    public IFeedbackAction rollback() throws SQLException {
        if (this.table != null) {
            DeleteCommand dc = new DeleteCommand(this.table, new Persist2Jet().getRowPattern(this.newRow, this.table), this.execId);
            return dc.persist();
        }
        return null;
    }
}

