/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.exception.UcanaccessRuntimeException;
import net.ucanaccess.jdbc.UcanaccessDataSourceFactory;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.type.AccessVersion;

public class UcanaccessDataSource
implements Serializable,
Referenceable,
DataSource {
    private static final long serialVersionUID = -5622403376078548785L;
    private String accessPath;
    private int loginTimeout = 0;
    private transient PrintWriter logWriter = new PrintWriter(System.out);
    private final Map<Metadata.Property, String> userPass = new EnumMap<Metadata.Property, String>(Metadata.Property.class);
    private final Map<Metadata.Property, String> props = new EnumMap<Metadata.Property, String>(Metadata.Property.class);

    public String getAccessPath() {
        return this.accessPath;
    }

    public String getUser() {
        return this.userPass.get((Object)Metadata.Property.user);
    }

    public String getColumnOrder() {
        return this.getPropAsString(Metadata.Property.columnOrder);
    }

    public Boolean getConcatNulls() {
        return this.getPropAsBoolean(Metadata.Property.concatNulls);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getConnection(this.userPass.get((Object)Metadata.Property.user), this.userPass.get((Object)Metadata.Property.password));
    }

    @Override
    public Connection getConnection(String _user, String _pass) throws SQLException {
        Properties copy = this.props.entrySet().stream().collect(Collectors.toMap(e -> ((Metadata.Property)((Object)((Object)e.getKey()))).name(), Map.Entry::getValue, (v1, v2) -> v1, Properties::new));
        Optional.ofNullable(_user).ifPresent(u -> copy.put(Metadata.Property.user.name(), u));
        Optional.ofNullable(_pass).ifPresent(p -> copy.put(Metadata.Property.password.name(), p));
        return new UcanaccessDriver().connect("jdbc:ucanaccess://" + this.accessPath, copy);
    }

    public Boolean getEncrypt() {
        return this.getPropAsBoolean(Metadata.Property.encrypt);
    }

    public Boolean getIgnoreCase() {
        return this.getPropAsBoolean(Metadata.Property.ignoreCase);
    }

    public Boolean getImmediatelyReleaseResources() {
        return this.getPropAsBoolean(Metadata.Property.immediatelyReleaseResources);
    }

    public Integer getInactivityTimeout() {
        return this.getPropAsInteger(Metadata.Property.inactivityTimeout);
    }

    public String getJackcessOpener() {
        return this.getPropAsString(Metadata.Property.jackcessOpener);
    }

    public String getKeepMirror() {
        return this.getPropAsString(Metadata.Property.keepMirror);
    }

    public Integer getLobScale() {
        return this.getPropAsInteger(Metadata.Property.lobScale);
    }

    @Override
    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    @Override
    public PrintWriter getLogWriter() {
        return this.logWriter;
    }

    public Boolean getMemory() {
        return this.getPropAsBoolean(Metadata.Property.memory);
    }

    public String getMirrorFolder() {
        return this.getPropAsString(Metadata.Property.mirrorFolder);
    }

    public String getNewDatabaseVersion() {
        return this.getPropAsString(Metadata.Property.newDatabaseVersion);
    }

    public Boolean getOpenExclusive() {
        return this.getPropAsBoolean(Metadata.Property.openExclusive);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger");
    }

    public Boolean getPreventReloading() {
        return this.getPropAsBoolean(Metadata.Property.preventReloading);
    }

    private Boolean getPropAsBoolean(Metadata.Property _key) {
        return Optional.ofNullable(this.getPropAsString(_key)).map(Boolean::valueOf).orElse(null);
    }

    private Integer getPropAsInteger(Metadata.Property _key) {
        return Optional.ofNullable(this.getPropAsString(_key)).map(Integer::valueOf).orElse(null);
    }

    private String getPropAsString(Metadata.Property _key) {
        return _key == null ? null : this.props.get((Object)_key);
    }

    @Override
    public Reference getReference() {
        String clazz = UcanaccessDataSourceFactory.class.getName();
        Reference ref = new Reference(this.getClass().getName(), clazz, null);
        ref.add(new StringRefAddr("accessPath", this.getAccessPath()));
        ref.add(new StringRefAddr(Metadata.Property.user.name(), this.userPass.get((Object)Metadata.Property.user)));
        ref.add(new StringRefAddr(Metadata.Property.password.name(), this.userPass.get((Object)Metadata.Property.password)));
        Arrays.stream(Metadata.Property.values()).filter(e -> e != Metadata.Property.user).filter(e -> e != Metadata.Property.password).forEach(e -> ref.add(new StringRefAddr(e.name(), this.getPropAsString((Metadata.Property)((Object)e)))));
        return ref;
    }

    public String getReMap() {
        return this.getPropAsString(Metadata.Property.reMap);
    }

    public Boolean getShowSchema() {
        return this.getPropAsBoolean(Metadata.Property.showSchema);
    }

    public Boolean getSkipIndexes() {
        return this.getPropAsBoolean(Metadata.Property.skipIndexes);
    }

    public Boolean getSysSchema() {
        return this.getPropAsBoolean(Metadata.Property.sysSchema);
    }

    @Override
    public boolean isWrapperFor(Class<?> _iface) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAccessPath(String _accessPath) {
        this.accessPath = _accessPath;
    }

    public void setUser(String _user) {
        this.userPass.put(Metadata.Property.user, _user);
    }

    public void setPassword(String _password) {
        this.userPass.put(Metadata.Property.password, _password);
    }

    public void setColumnOrder(String _value) {
        this.setProp(Metadata.Property.columnOrder, _value);
    }

    public void setConcatNulls(Boolean _value) {
        this.setProp(Metadata.Property.concatNulls, _value);
    }

    public void setEncrypt(Boolean _value) {
        this.setProp(Metadata.Property.encrypt, _value);
    }

    public void setIgnoreCase(Boolean _value) {
        this.setProp(Metadata.Property.ignoreCase, _value);
    }

    public void setImmediatelyReleaseResources(Boolean _value) {
        this.setProp(Metadata.Property.immediatelyReleaseResources, _value);
    }

    public void setInactivityTimeout(Integer _value) {
        this.setProp(Metadata.Property.inactivityTimeout, _value);
    }

    public void setJackcessOpener(String _value) {
        this.setProp(Metadata.Property.jackcessOpener, _value);
    }

    public void setKeepMirror(String _value) {
        this.setProp(Metadata.Property.keepMirror, _value);
    }

    public void setLobScale(Integer _value) {
        this.setProp(Metadata.Property.lobScale, _value);
    }

    @Override
    public void setLoginTimeout(int _value) {
        this.loginTimeout = _value;
    }

    @Override
    public void setLogWriter(PrintWriter _logWriter) {
        this.logWriter = _logWriter;
    }

    public void setMemory(Boolean _value) {
        this.setProp(Metadata.Property.memory, _value);
    }

    public void setMirrorFolder(String _value) {
        this.setProp(Metadata.Property.mirrorFolder, _value);
    }

    public void setNewDatabaseVersion(String _version) {
        AccessVersion accVersion = null;
        if (_version != null && !_version.isEmpty() && (accVersion = AccessVersion.parse(_version)) == null) {
            UcanaccessRuntimeException.throwNow("Valid version required: " + _version);
        }
        this.setNewDatabaseVersion(accVersion);
    }

    public void setNewDatabaseVersion(AccessVersion _version) {
        this.setProp(Metadata.Property.newDatabaseVersion, _version == null ? null : _version.name());
    }

    public void setOpenExclusive(Boolean _value) {
        this.setProp(Metadata.Property.openExclusive, _value);
    }

    public void setPreventReloading(Boolean _value) {
        this.setProp(Metadata.Property.preventReloading, _value);
    }

    private void setProp(Metadata.Property _key, Object _value) {
        if (_key == null) {
            return;
        }
        if (_value == null) {
            this.props.remove((Object)_key);
            return;
        }
        if (!_key.isValidValue(_value)) {
            throw new UcanaccessRuntimeException("Invalid value '" + _value + "' for property " + _key);
        }
        this.props.put(_key, _value.toString());
    }

    public void setReMap(String _value) {
        this.setProp(Metadata.Property.reMap, _value);
    }

    public void setShowSchema(Boolean _value) {
        this.setProp(Metadata.Property.showSchema, _value);
    }

    public void setSkipIndexes(Boolean _value) {
        this.setProp(Metadata.Property.skipIndexes, _value);
    }

    public void setSysSchema(Boolean _value) {
        this.setProp(Metadata.Property.sysSchema, _value);
    }

    @Override
    public <T> T unwrap(Class<T> _iface) {
        throw new UnsupportedOperationException("Not supported yet");
    }
}

