/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.monetdb.mcl.io.LineType;

public final class BufferedMCLReader {
    private final BufferedReader inner;
    private String current = null;
    private LineType lineType = LineType.UNKNOWN;

    public BufferedMCLReader(Reader reader) {
        this.inner = new BufferedReader(reader);
    }

    public BufferedMCLReader(InputStream inputStream, Charset charset) {
        this(new InputStreamReader(inputStream, charset));
    }

    public void advance() throws IOException {
        if (this.lineType == LineType.PROMPT) {
            return;
        }
        this.current = this.inner.readLine();
        this.lineType = LineType.classify(this.current);
        if (this.lineType == LineType.ERROR && this.current != null && !this.current.matches("^![0-9A-Z]{5}!.+")) {
            this.current = "!22000!" + this.current.substring(1);
        }
    }

    public void resetLineType() {
        this.lineType = LineType.UNKNOWN;
    }

    public String getLine() {
        return this.current;
    }

    public String getLine(int n) {
        String string = this.getLine();
        if (string != null) {
            string = string.substring(n);
        }
        return string;
    }

    public LineType getLineType() {
        return this.lineType;
    }

    public final String discardRemainder() throws IOException {
        return this.discard(null);
    }

    public final String discardRemainder(String string) throws IOException {
        StringBuilder stringBuilder;
        if (string != null) {
            stringBuilder = this.makeErrorBuffer();
            stringBuilder.append(string);
        } else {
            stringBuilder = null;
        }
        return this.discard(stringBuilder);
    }

    final synchronized String discard(StringBuilder stringBuilder) throws IOException {
        while (this.lineType != LineType.PROMPT) {
            this.advance();
            if (this.getLine() == null) {
                throw new IOException("Connection to server lost!");
            }
            if (this.getLineType() != LineType.ERROR) continue;
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(128);
            }
            stringBuilder.append('\n').append(this.getLine().substring(1));
        }
        if (stringBuilder == null) {
            return null;
        }
        return stringBuilder.toString().trim();
    }

    private final StringBuilder makeErrorBuffer() {
        return new StringBuilder(128);
    }

    public void close() throws IOException {
        this.inner.close();
    }
}

