/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import org.monetdb.util.OptionsException;

public final class CmdLineOpts {
    private HashMap<String, OptionContainer> opts = new HashMap();
    private final HashSet<String> ignoredInFile = new HashSet();
    private ArrayList<OptionContainer> options = new ArrayList();
    public static final int CAR_ZERO = 0;
    public static final int CAR_ONE = 1;
    public static final int CAR_ZERO_ONE = 2;
    public static final int CAR_ZERO_MANY = 3;
    public static final int CAR_ONE_MANY = 4;

    public void addOption(String string, String string2, int n, String string3, String string4) throws OptionsException {
        OptionContainer optionContainer = new OptionContainer(string, string2, n, string3, string4);
        if (string != null) {
            this.opts.put(string, optionContainer);
        }
        if (string2 != null) {
            this.opts.put(string2, optionContainer);
        }
    }

    public void addIgnored(String string) {
        this.ignoredInFile.add(string);
    }

    public void removeOption(String string) {
        OptionContainer optionContainer = this.opts.get(string);
        if (optionContainer != null) {
            this.opts.remove(optionContainer.shorta);
            this.opts.remove(optionContainer.longa);
        }
    }

    public OptionContainer getOption(String string) throws OptionsException {
        OptionContainer optionContainer = this.opts.get(string);
        if (optionContainer == null) {
            throw new OptionsException("No such option: " + string);
        }
        return optionContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFile(File file) throws OptionsException {
        Properties properties = new Properties();
        try {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                properties.load(fileInputStream);
            }
            OptionContainer optionContainer = null;
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                optionContainer = this.opts.get(string);
                if (optionContainer != null) {
                    optionContainer.resetArguments();
                    optionContainer.addArgument(properties.getProperty(string));
                    continue;
                }
                if (this.ignoredInFile.contains(string)) continue;
                System.out.println("Info: Ignoring unknown/unsupported option (in " + file.getAbsolutePath() + "): " + string);
            }
        }
        catch (IOException iOException) {
            throw new OptionsException("File IO Exception: " + iOException);
        }
    }

    public void processArgs(String[] stringArray) throws OptionsException {
        OptionContainer optionContainer = null;
        int n = -1;
        int n2 = 0;
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (optionContainer == null) {
                int n3;
                if (stringArray[i].charAt(0) != '-') {
                    throw new OptionsException("Unexpected value: " + stringArray[i]);
                }
                if (stringArray[i].length() == 1) {
                    throw new OptionsException("Illegal argument: '-'");
                }
                if (stringArray[i].charAt(1) == '-') {
                    String string = stringArray[i].substring(2);
                    n3 = string.indexOf(61);
                    if (n3 == -1) {
                        optionContainer = this.opts.get(string);
                        bl = false;
                    } else {
                        optionContainer = this.opts.get(string.substring(0, n3));
                        stringArray[i] = "-?" + string.substring(n3 + 1);
                        bl = true;
                    }
                } else if (stringArray[i].charAt(1) == 'X') {
                    String string = stringArray[i].substring(1);
                    n3 = string.indexOf(61);
                    if (n3 == -1) {
                        optionContainer = this.opts.get(string);
                        bl = false;
                    } else {
                        optionContainer = this.opts.get(string.substring(0, n3));
                        stringArray[i] = "-?" + string.substring(n3 + 1);
                        bl = true;
                    }
                } else {
                    optionContainer = this.opts.get("" + stringArray[i].charAt(1));
                    boolean bl2 = bl = stringArray[i].length() > 2;
                }
                if (optionContainer != null) {
                    optionContainer.resetArguments();
                    int n4 = optionContainer.getCardinality();
                    if (n4 == 1) {
                        if (bl) {
                            optionContainer.addArgument(stringArray[i].substring(2));
                            optionContainer = null;
                            continue;
                        }
                        n = 1;
                        continue;
                    }
                    if (n4 == 2) {
                        optionContainer.setPresent();
                        n2 = 1;
                        n = 2;
                        if (!bl) continue;
                        optionContainer.addArgument(stringArray[i].substring(2));
                        optionContainer = null;
                        continue;
                    }
                    if (n4 == 3) {
                        optionContainer.setPresent();
                        n2 = 1;
                        n = -1;
                        if (!bl) continue;
                        optionContainer.addArgument(stringArray[i].substring(2));
                        ++n2;
                        continue;
                    }
                    if (n4 != 0) continue;
                    optionContainer.setPresent();
                    optionContainer = null;
                    continue;
                }
                throw new OptionsException("Unknown argument: " + stringArray[i]);
            }
            optionContainer.addArgument(stringArray[i]);
            if (++n2 != n) continue;
            n = 0;
            n2 = 0;
            optionContainer = null;
        }
    }

    public String produceHelpMessage() {
        int n = 0;
        for (OptionContainer object : this.options) {
            String string = object.getShort();
            String string2 = object.getLong();
            int n2 = 0;
            if (string != null) {
                n2 += string.length() + 1 + 1;
            }
            if (string2 != null) {
                n2 += string2.length() + 1 + (string2.charAt(0) == 'X' ? 0 : 1) + 1;
            }
            if (n >= n2) continue;
            n = n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (OptionContainer optionContainer : this.options) {
            stringBuilder.append(this.produceHelpMessage(optionContainer, n));
        }
        return stringBuilder.toString();
    }

    public String produceHelpMessage(OptionContainer optionContainer, int n) {
        int n2;
        String string = optionContainer.getDescription();
        if (string == null) {
            return "";
        }
        String string2 = optionContainer.getShort();
        String string3 = optionContainer.getLong();
        int n3 = 0;
        if (string2 != null) {
            n3 += string2.length() + 1 + 1;
        }
        if (string3 != null) {
            n3 += string3.length() + 1 + (string3.charAt(0) == 'X' ? 0 : 1) + 1;
        }
        int n4 = 80 - n;
        if (n <= 0) {
            n = n3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append('-').append(string2).append(' ');
        }
        if (string3 != null) {
            stringBuilder.append('-');
            if (string3.charAt(0) != 'X') {
                stringBuilder.append('-');
            }
            stringBuilder.append(string3).append(' ');
        }
        for (n2 = n3; n2 < n; ++n2) {
            stringBuilder.append(' ');
        }
        n2 = 0;
        int n5 = 0;
        while (n2 < string.length()) {
            int n6;
            n2 += n4;
            if (n5 != 0) {
                for (n6 = 0; n6 < n; ++n6) {
                    stringBuilder.append(' ');
                }
            }
            if (n2 >= string.length()) {
                stringBuilder.append(string.substring(n5)).append('\n');
                break;
            }
            n6 = n2;
            while (string.charAt(n6) != ' ') {
                if (n6 == 0) {
                    n6 = n2;
                    break;
                }
                --n6;
            }
            n2 = n6;
            stringBuilder.append(string.substring(n5, n2)).append('\n');
            while (string.charAt(n2) == ' ') {
                ++n2;
            }
            n5 = n2;
        }
        return stringBuilder.toString();
    }

    public final class OptionContainer {
        private final int cardinality;
        private final String shorta;
        private final String longa;
        private final ArrayList<String> values = new ArrayList();
        private final String name;
        private final String defaulta;
        private final String descriptiona;
        private boolean present;

        public OptionContainer(String string, String string2, int n, String string3, String string4) throws IllegalArgumentException {
            this.cardinality = n;
            this.shorta = string;
            this.longa = string2;
            this.defaulta = string3;
            this.descriptiona = string4;
            this.present = false;
            if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4) {
                throw new IllegalArgumentException("unknown cardinality");
            }
            if (string != null && string.length() != 1) {
                throw new IllegalArgumentException("short option should consist of exactly one character");
            }
            if (string == null && string2 == null) {
                throw new IllegalArgumentException("either a short or long argument should be given");
            }
            if ((n == 0 || n == 2 || n == 3) && string3 != null) {
                throw new IllegalArgumentException("cannot specify a default for a (possible) zero argument option");
            }
            this.name = string2 != null ? string2 : string;
            CmdLineOpts.this.options.add(this);
        }

        public final void resetArguments() {
            this.values.clear();
        }

        public void addArgument(String string) throws OptionsException {
            if (this.cardinality == 0) {
                throw new OptionsException("option " + this.name + " does not allow arguments");
            }
            if ((this.cardinality == 1 || this.cardinality == 2) && this.values.size() >= 1) {
                throw new OptionsException("option " + this.name + " does at max allow only one argument");
            }
            this.values.add(string);
            this.setPresent();
        }

        public final void setPresent() {
            this.present = true;
        }

        public final boolean isPresent() {
            return this.present;
        }

        public final int getCardinality() {
            return this.cardinality;
        }

        public final int getArgumentCount() {
            return this.values.size();
        }

        public final String getArgument() {
            String string = this.getArgument(1);
            if (string == null) {
                return this.defaulta;
            }
            return string;
        }

        public final String getArgument(int n) {
            String[] stringArray = this.getArguments();
            if (n < 1 || n > stringArray.length) {
                return null;
            }
            return stringArray[n - 1];
        }

        public final String[] getArguments() {
            return this.values.toArray(new String[this.values.size()]);
        }

        public final String getShort() {
            return this.shorta;
        }

        public final String getLong() {
            return this.longa;
        }

        public final String getDescription() {
            return this.descriptiona;
        }
    }
}

