/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.oauth;

import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class DbxOAuthError {
    public static final String INVALID_REQUEST = "invalid_request";
    public static final String INVALID_GRANT = "invalid_grant";
    public static final String UNSUPPORTED_GRANT_TYPE = "unsupported_grant_type";
    public static final String UNKNOWN = "unknown";
    public static final Set<String> ERRORS = new HashSet<String>(Arrays.asList("invalid_request", "invalid_grant", "unsupported_grant_type"));
    private final String error;
    private final String errorDescription;
    public static final JsonReader<DbxOAuthError> Reader = new JsonReader<DbxOAuthError>(){

        @Override
        public final DbxOAuthError read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String error = null;
            String errorDescription = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    if (fieldName.equals("error")) {
                        error = (String)StringReader.readField(parser, fieldName, error);
                        continue;
                    }
                    if (fieldName.equals("error_description")) {
                        errorDescription = (String)StringReader.readField(parser, fieldName, errorDescription);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (error == null) {
                throw new JsonReadException("missing field \"error\"", top);
            }
            return new DbxOAuthError(error, errorDescription);
        }
    };

    public DbxOAuthError(String error, String errorDescription) {
        this.error = ERRORS.contains(error) ? error : UNKNOWN;
        this.errorDescription = errorDescription;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }
}

