/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.ExportFormat;
import com.dropbox.core.v2.paper.RefPaperDoc;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;

class PaperDocExport
extends RefPaperDoc {
    @Nonnull
    protected final ExportFormat exportFormat;

    public PaperDocExport(@Nonnull String docId, @Nonnull ExportFormat exportFormat) {
        super(docId);
        if (exportFormat == null) {
            throw new IllegalArgumentException("Required value for 'exportFormat' is null");
        }
        this.exportFormat = exportFormat;
    }

    @Override
    @Nonnull
    public String getDocId() {
        return this.docId;
    }

    @Nonnull
    public ExportFormat getExportFormat() {
        return this.exportFormat;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.exportFormat});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            PaperDocExport other = (PaperDocExport)obj;
            return !(this.docId != other.docId && !this.docId.equals(other.docId) || this.exportFormat != other.exportFormat && !this.exportFormat.equals((Object)other.exportFormat));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<PaperDocExport> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PaperDocExport value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("doc_id");
            StoneSerializers.string().serialize(value.docId, g);
            g.writeFieldName("export_format");
            ExportFormat.Serializer.INSTANCE.serialize(value.exportFormat, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public PaperDocExport deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            ExportFormat f_exportFormat;
            String f_docId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docId = null;
                f_exportFormat = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_id".equals(field)) {
                        f_docId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("export_format".equals(field)) {
                        f_exportFormat = ExportFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docId == null) {
                    throw new JsonParseException(p, "Required field \"doc_id\" missing.");
                }
                if (f_exportFormat == null) {
                    throw new JsonParseException(p, "Required field \"export_format\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            PaperDocExport value = new PaperDocExport(f_docId, f_exportFormat);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

