/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.seenstate.PlatformType;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.dropbox.core.v2.sharing.UserInfo;
import com.dropbox.core.v2.sharing.UserMembershipInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserFileMembershipInfo
extends UserMembershipInfo {
    @Nullable
    protected final Date timeLastSeen;
    @Nullable
    protected final PlatformType platformType;

    public UserFileMembershipInfo(@Nonnull AccessLevel accessType, @Nonnull UserInfo user, @Nullable List<MemberPermission> permissions, @Nullable String initials, boolean isInherited, @Nullable Date timeLastSeen, @Nullable PlatformType platformType) {
        super(accessType, user, permissions, initials, isInherited);
        this.timeLastSeen = LangUtil.truncateMillis(timeLastSeen);
        this.platformType = platformType;
    }

    public UserFileMembershipInfo(@Nonnull AccessLevel accessType, @Nonnull UserInfo user) {
        this(accessType, user, null, null, false, null, null);
    }

    @Override
    @Nonnull
    public AccessLevel getAccessType() {
        return this.accessType;
    }

    @Override
    @Nonnull
    public UserInfo getUser() {
        return this.user;
    }

    @Override
    @Nullable
    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Nullable
    public String getInitials() {
        return this.initials;
    }

    @Override
    public boolean getIsInherited() {
        return this.isInherited;
    }

    @Nullable
    public Date getTimeLastSeen() {
        return this.timeLastSeen;
    }

    @Nullable
    public PlatformType getPlatformType() {
        return this.platformType;
    }

    public static Builder newBuilder(AccessLevel accessType, UserInfo user) {
        return new Builder(accessType, user);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.timeLastSeen, this.platformType});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserFileMembershipInfo other = (UserFileMembershipInfo)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.user != other.user && !this.user.equals(other.user) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.initials != other.initials && (this.initials == null || !this.initials.equals(other.initials)) || this.isInherited != other.isInherited || this.timeLastSeen != other.timeLastSeen && (this.timeLastSeen == null || !this.timeLastSeen.equals(other.timeLastSeen)) || this.platformType != other.platformType && (this.platformType == null || !this.platformType.equals((Object)other.platformType)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserFileMembershipInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserFileMembershipInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g);
            g.writeFieldName("user");
            UserInfo.Serializer.INSTANCE.serialize(value.user, g);
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).serialize((List<MemberPermission>)value.permissions, g);
            }
            if (value.initials != null) {
                g.writeFieldName("initials");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.initials, g);
            }
            g.writeFieldName("is_inherited");
            StoneSerializers.boolean_().serialize((Boolean)value.isInherited, g);
            if (value.timeLastSeen != null) {
                g.writeFieldName("time_last_seen");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.timeLastSeen, g);
            }
            if (value.platformType != null) {
                g.writeFieldName("platform_type");
                StoneSerializers.nullable(PlatformType.Serializer.INSTANCE).serialize(value.platformType, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserFileMembershipInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            PlatformType f_platformType;
            Date f_timeLastSeen;
            Boolean f_isInherited;
            String f_initials;
            List<MemberPermission> f_permissions;
            UserInfo f_user;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_user = null;
                f_permissions = null;
                f_initials = null;
                f_isInherited = false;
                f_timeLastSeen = null;
                f_platformType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("user".equals(field)) {
                        f_user = (UserInfo)UserInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("initials".equals(field)) {
                        f_initials = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_inherited".equals(field)) {
                        f_isInherited = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("time_last_seen".equals(field)) {
                        f_timeLastSeen = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("platform_type".equals(field)) {
                        f_platformType = StoneSerializers.nullable(PlatformType.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_user == null) {
                    throw new JsonParseException(p, "Required field \"user\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserFileMembershipInfo value = new UserFileMembershipInfo(f_accessType, f_user, f_permissions, f_initials, f_isInherited, f_timeLastSeen, f_platformType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends UserMembershipInfo.Builder {
        protected Date timeLastSeen = null;
        protected PlatformType platformType = null;

        protected Builder(AccessLevel accessType, UserInfo user) {
            super(accessType, user);
        }

        public Builder withTimeLastSeen(Date timeLastSeen) {
            this.timeLastSeen = LangUtil.truncateMillis(timeLastSeen);
            return this;
        }

        public Builder withPlatformType(PlatformType platformType) {
            this.platformType = platformType;
            return this;
        }

        @Override
        public Builder withPermissions(List<MemberPermission> permissions) {
            super.withPermissions((List)permissions);
            return this;
        }

        @Override
        public Builder withInitials(String initials) {
            super.withInitials(initials);
            return this;
        }

        @Override
        public Builder withIsInherited(Boolean isInherited) {
            super.withIsInherited(isInherited);
            return this;
        }

        @Override
        public UserFileMembershipInfo build() {
            return new UserFileMembershipInfo(this.accessType, this.user, this.permissions, this.initials, this.isInherited, this.timeLastSeen, this.platformType);
        }
    }
}

