/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.BaseMessage;

public class Message
extends BaseMessage {
    private static final Collection<String> ACCEPTED_DETAILS = List.of("LOW", "HIGH", "AUTO");
    public static final String CONST_MESSAGE_ROLE = "Message role '";
    public static final String CONST_AT_INDEX = "' at index ";
    private String imageBase64Data;
    private String imageDetailLevel;
    private String imageMimeType;
    private String imageUri;
    private String imageUrl;

    public String getImageBase64Data() {
        return this.imageBase64Data;
    }

    public void setImageBase64Data(String imageBase64Data) {
        this.imageBase64Data = imageBase64Data;
    }

    public String getImageDetailLevel() {
        return this.imageDetailLevel;
    }

    public void setImageDetailLevel(String imageDetailLevel) {
        this.imageDetailLevel = imageDetailLevel;
    }

    public String getImageMimeType() {
        return this.imageMimeType;
    }

    public void setImageMimeType(String imageMimeType) {
        this.imageMimeType = imageMimeType;
    }

    public String getImageUri() {
        return this.imageUri;
    }

    public void setImageUri(String imageUri) {
        this.imageUri = imageUri;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public static boolean isRoleSystem(String role) {
        switch (role) {
            case "context": 
            case "environment": 
            case "setup": 
            case "system": {
                return true;
            }
        }
        return false;
    }

    public static boolean isRoleUser(String role) {
        switch (role) {
            case "customer": 
            case "client": 
            case "consumer": 
            case "participant": 
            case "actor": 
            case "user": {
                return true;
            }
        }
        return false;
    }

    public static boolean isRoleAssistant(String role) {
        switch (role) {
            case "agent": 
            case "bot": 
            case "adviser": 
            case "helper": 
            case "assistant": 
            case "ai": {
                return true;
            }
        }
        return false;
    }

    public static Optional<String> detectSystemRoleName(List<Message> messages) {
        for (Message message : messages) {
            if (!Message.isRoleSystem(message.getRole())) continue;
            return Optional.of(message.getRole());
        }
        return Optional.empty();
    }

    public static Optional<String> detectUserRoleName(List<Message> messages) {
        for (Message message : messages) {
            if (!Message.isRoleUser(message.getRole())) continue;
            return Optional.of(message.getRole());
        }
        return Optional.empty();
    }

    public static Optional<String> detectAssistantRoleName(List<Message> messages) {
        for (Message message : messages) {
            if (!Message.isRoleAssistant(message.getRole())) continue;
            return Optional.of(message.getRole());
        }
        return Optional.empty();
    }

    public static List<ChatMessage> toChatMessages(List<Message> incoming) throws HopValueException {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>(incoming.size());
        for (int i = 0; i < incoming.size(); ++i) {
            Message m = incoming.get(i);
            String role = StringUtils.trimToNull((String)m.getRole());
            Validate.notNull((Object)role, (String)("Message role not set at index " + i), (Object[])new Object[0]);
            Validate.notNull((Object)role, (String)("Message at index " + i + " does not have 'role' set"), (Object[])new Object[0]);
            String content = StringUtils.trimToNull((String)m.getContent());
            if (Message.isRoleSystem(role)) {
                Validate.notNull((Object)content, (String)(CONST_MESSAGE_ROLE + role + CONST_AT_INDEX + i + " does not have 'content' set"), (Object[])new Object[0]);
                messages.add((ChatMessage)SystemMessage.systemMessage((String)content));
                continue;
            }
            if (Message.isRoleAssistant(role)) {
                Validate.notNull((Object)content, (String)(CONST_MESSAGE_ROLE + role + CONST_AT_INDEX + i + " does not have 'content' set"), (Object[])new Object[0]);
                messages.add((ChatMessage)AiMessage.aiMessage((String)content));
                continue;
            }
            if (Message.isRoleUser(role)) {
                UserMessage userMessage;
                ImageContent image;
                boolean v;
                String uri = StringUtils.trimToNull((String)m.getImageUri());
                String url = StringUtils.trimToNull((String)m.getImageUrl());
                String base64 = StringUtils.trimToNull((String)m.getImageBase64Data());
                String mime = StringUtils.trimToNull((String)m.getImageMimeType());
                String detail = StringUtils.upperCase((String)StringUtils.trimToNull((String)m.getImageDetailLevel()));
                ImageContent.DetailLevel detailLevel = null;
                if (StringUtils.isNotBlank((CharSequence)detail)) {
                    v = ACCEPTED_DETAILS.contains(detail);
                    Validate.isTrue((boolean)v, (String)(CONST_MESSAGE_ROLE + role + CONST_AT_INDEX + i + " does not have a valid 'imageDetailLevel' set. Must be either low, high, or auto."), (Object[])new Object[0]);
                    detailLevel = ImageContent.DetailLevel.valueOf((String)detail);
                }
                if (StringUtils.isNotBlank((CharSequence)base64) || StringUtils.isNotBlank((CharSequence)mime)) {
                    v = StringUtils.isNotBlank((CharSequence)base64) && StringUtils.isNotBlank((CharSequence)mime);
                    Validate.isTrue((boolean)v, (String)(CONST_MESSAGE_ROLE + role + CONST_AT_INDEX + i + " does not have both 'imageBase64Data' and 'imageMimeType' set. When either one is set, both are required."), (Object[])new Object[0]);
                    image = detailLevel == null ? ImageContent.from((String)base64, (String)mime) : ImageContent.from((String)base64, (String)mime, (ImageContent.DetailLevel)detailLevel);
                    userMessage = StringUtils.isNotBlank((CharSequence)content) ? UserMessage.userMessage((Content[])new Content[]{TextContent.from((String)content), image}) : UserMessage.userMessage((Content[])new Content[]{image});
                    messages.add((ChatMessage)userMessage);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)uri)) {
                    try {
                        URI imageUri = URI.create(uri);
                        image = detailLevel == null ? ImageContent.from((URI)imageUri) : ImageContent.from((URI)imageUri, (ImageContent.DetailLevel)detailLevel);
                        userMessage = StringUtils.isNotBlank((CharSequence)content) ? UserMessage.userMessage((Content[])new Content[]{TextContent.from((String)content), image}) : UserMessage.userMessage((Content[])new Content[]{image});
                        messages.add((ChatMessage)userMessage);
                        continue;
                    }
                    catch (Exception e) {
                        String err = CONST_MESSAGE_ROLE + role + CONST_AT_INDEX + i + " has a problem with 'imageUri': " + ExceptionUtils.getRootCauseMessage((Throwable)e);
                        throw new IllegalArgumentException(err);
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)url)) {
                    ImageContent image2 = detailLevel == null ? ImageContent.from((String)url) : ImageContent.from((String)url, (ImageContent.DetailLevel)detailLevel);
                    UserMessage userMessage2 = StringUtils.isNotBlank((CharSequence)content) ? UserMessage.userMessage((Content[])new Content[]{TextContent.from((String)content), image2}) : UserMessage.userMessage((Content[])new Content[]{image2});
                    messages.add((ChatMessage)userMessage2);
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)content)) continue;
                messages.add((ChatMessage)UserMessage.userMessage((String)content));
                continue;
            }
            throw new HopValueException("Invalid message role at index " + i);
        }
        return messages;
    }
}

