/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ModelType;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.CompositeParameters;
import org.apache.hop.pipeline.transforms.languagemodelchat.internals.ui.models.AbstractModelComposite;
import org.apache.hop.ui.core.widget.TextVar;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class OllamaComposite
extends AbstractModelComposite {
    private final Label imageEndpointLabel = this.createLabel();
    private final TextVar imageEndpointInput = this.createTextVar();
    private final Label modelNameLabel;
    private final TextVar modelNameInput;
    private final Label temperatureLabel;
    private final TextVar temperatureInput;
    private final Label topKLabel;
    private final TextVar topKInput;
    private final Label topPLabel;
    private final TextVar topPInput;
    private final Label repeatPenaltyLabel;
    private final TextVar repeatPenaltyInput;
    private final Label seedLabel;
    private final TextVar seedInput;
    private final Label numPredictLabel;
    private final TextVar numPredictInput;
    private final Label numCtxLabel;
    private final TextVar numCtxInput;
    private final Label formatLabel;
    private final TextVar formatInput;
    private final Label timeoutLabel;
    private final TextVar timeoutInput;
    private final Label maxRetriesLabel;
    private final TextVar maxRetriesInput;

    public OllamaComposite(CompositeParameters parameters) {
        super(ModelType.OLLAMA, parameters);
        this.prepare("ImageEndpoint", this.imageEndpointLabel, (Control)this.imageEndpointInput);
        this.modelNameLabel = this.createLabel();
        this.modelNameInput = this.createTextVar();
        this.prepare("ModelName", this.modelNameLabel, (Control)this.modelNameInput);
        this.temperatureLabel = this.createLabel();
        this.temperatureInput = this.createTextVar();
        this.prepare("Temperature", this.temperatureLabel, (Control)this.temperatureInput);
        this.topKLabel = this.createLabel();
        this.topKInput = this.createTextVar();
        this.prepare("TopK", this.topKLabel, (Control)this.topKInput);
        this.topPLabel = this.createLabel();
        this.topPInput = this.createTextVar();
        this.prepare("TopP", this.topPLabel, (Control)this.topPInput);
        this.repeatPenaltyLabel = this.createLabel();
        this.repeatPenaltyInput = this.createTextVar();
        this.repeatPenaltyLabel.setVisible(false);
        this.repeatPenaltyInput.setVisible(false);
        this.prepare("RepeatPenalty", this.repeatPenaltyLabel, (Control)this.repeatPenaltyInput);
        this.seedLabel = this.createLabel();
        this.seedInput = this.createTextVar();
        this.prepare("Seed", this.seedLabel, (Control)this.seedInput);
        this.numPredictLabel = this.createLabel();
        this.numPredictInput = this.createTextVar();
        this.prepare("NumPredict", this.numPredictLabel, (Control)this.numPredictInput);
        this.numCtxLabel = this.createLabel();
        this.numCtxInput = this.createTextVar();
        this.prepare("NumCtx", this.numCtxLabel, (Control)this.numCtxInput);
        this.formatLabel = this.createLabel();
        this.formatInput = this.createTextVar();
        this.prepare("Format", this.formatLabel, (Control)this.formatInput);
        this.timeoutLabel = this.createLabel();
        this.timeoutInput = this.createTextVar();
        this.prepare("Timeout", this.timeoutLabel, (Control)this.timeoutInput);
        this.maxRetriesLabel = this.createLabel();
        this.maxRetriesInput = this.createTextVar();
        this.prepare("MaxRetries", this.maxRetriesLabel, (Control)this.maxRetriesInput);
    }

    @Override
    public void loadData() {
        if (!this.isSelectedModelType()) {
            return;
        }
        if (this.meta.getOllamaImageEndpoint() != null) {
            this.imageEndpointInput.setText(this.meta.getOllamaImageEndpoint());
        }
        if (this.meta.getOllamaModelName() != null) {
            this.modelNameInput.setText(this.meta.getOllamaModelName());
        }
        if (this.meta.getOllamaTemperature() != null) {
            this.temperatureInput.setText("" + this.meta.getOllamaTemperature());
        }
        if (this.meta.getOllamaTopK() != null) {
            this.topKInput.setText("" + this.meta.getOllamaTopK());
        }
        if (this.meta.getOllamaTopP() != null) {
            this.topPInput.setText("" + this.meta.getOllamaTopP());
        }
        if (this.meta.getOllamaRepeatPenalty() != null) {
            this.repeatPenaltyInput.setText("" + this.meta.getOllamaRepeatPenalty());
        }
        if (this.meta.getOllamaSeed() != null) {
            this.seedInput.setText("" + this.meta.getOllamaSeed());
        }
        if (this.meta.getOllamaNumPredict() != null) {
            this.numPredictInput.setText("" + this.meta.getOllamaNumPredict());
        }
        if (this.meta.getOllamaNumCtx() != null) {
            this.numCtxInput.setText("" + this.meta.getOllamaNumCtx());
        }
        if (this.meta.getOllamaFormat() != null) {
            this.formatInput.setText(this.meta.getOllamaFormat());
        }
        if (this.meta.getOllamaTimeout() != null) {
            this.timeoutInput.setText("" + this.meta.getOllamaTimeout());
        }
        if (this.meta.getOllamaMaxRetries() != null) {
            this.maxRetriesInput.setText("" + this.meta.getOllamaMaxRetries());
        }
    }

    @Override
    public boolean validateInputs() {
        if (!this.isSelectedModelType()) {
            return true;
        }
        String temperature = StringUtils.trim((String)this.temperatureInput.getText());
        return StringUtils.isBlank((CharSequence)temperature) || NumberUtils.isCreatable((String)temperature);
    }

    @Override
    public void updateTransformMeta() {
        if (!this.validateInputs()) {
            return;
        }
        this.meta.setOllamaImageEndpoint(this.trimStringToNull(this.imageEndpointInput.getText()));
        this.meta.setOllamaModelName(this.trimStringToNull(this.modelNameInput.getText()));
        this.meta.setOllamaTemperature(this.trimDoubleToNull(this.temperatureInput.getText()));
        this.meta.setOllamaTopK(this.trimIntegerToNull(this.topKInput.getText()));
        this.meta.setOllamaTopP(this.trimDoubleToNull(this.topPInput.getText()));
        this.meta.setOllamaRepeatPenalty(this.trimDoubleToNull(this.repeatPenaltyInput.getText()));
        this.meta.setOllamaSeed(this.trimIntegerToNull(this.seedInput.getText()));
        this.meta.setOllamaNumPredict(this.trimIntegerToNull(this.numPredictInput.getText()));
        this.meta.setOllamaNumCtx(this.trimIntegerToNull(this.numCtxInput.getText()));
        this.meta.setOllamaFormat(this.trimStringToNull(this.formatInput.getText()));
        this.meta.setOllamaTimeout(this.trimIntegerToNull(this.timeoutInput.getText()));
        this.meta.setOllamaMaxRetries(this.trimIntegerToNull(this.maxRetriesInput.getText()));
    }

    public Label getNumPredictLabel() {
        return this.numPredictLabel;
    }

    public TextVar getNumPredictInput() {
        return this.numPredictInput;
    }

    public Label getModelNameLabel() {
        return this.modelNameLabel;
    }

    public TextVar getModelNameInput() {
        return this.modelNameInput;
    }

    public Label getTemperatureLabel() {
        return this.temperatureLabel;
    }

    public TextVar getTemperatureInput() {
        return this.temperatureInput;
    }

    public Label getImageEndpointLabel() {
        return this.imageEndpointLabel;
    }

    public TextVar getImageEndpointInput() {
        return this.imageEndpointInput;
    }

    public Label getNumCtxLabel() {
        return this.numCtxLabel;
    }

    public TextVar getNumCtxInput() {
        return this.numCtxInput;
    }

    public Label getTopPLabel() {
        return this.topPLabel;
    }

    public TextVar getTopPInput() {
        return this.topPInput;
    }

    public Label getTopKLabel() {
        return this.topKLabel;
    }

    public TextVar getTopKInput() {
        return this.topKInput;
    }

    public Label getFormatLabel() {
        return this.formatLabel;
    }

    public TextVar getFormatInput() {
        return this.formatInput;
    }

    public Label getSeedLabel() {
        return this.seedLabel;
    }

    public TextVar getSeedInput() {
        return this.seedInput;
    }

    public Label getTimeoutLabel() {
        return this.timeoutLabel;
    }

    public TextVar getTimeoutInput() {
        return this.timeoutInput;
    }

    public Label getMaxRetriesLabel() {
        return this.maxRetriesLabel;
    }

    public TextVar getMaxRetriesInput() {
        return this.maxRetriesInput;
    }

    public Label getRepeatPenaltyLabel() {
        return this.repeatPenaltyLabel;
    }

    public TextVar getRepeatPenaltyInput() {
        return this.repeatPenaltyInput;
    }
}

