/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MapMaker;
import com.google.common.flogger.GoogleLogger;
import com.google.common.flogger.LazyArgs;
import com.google.gson.Gson;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

@VisibleForTesting
public class EventLoggingHttpRequestInitializer
implements HttpRequestInitializer {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private final Gson gson = new Gson();
    private static final ImmutableSet<String> REDACTED_REQUEST_HEADERS = (ImmutableSet)Stream.of("Authorization", "Cookie", "Proxy-Authorization").map(header -> header.toLowerCase(Locale.US)).collect(ImmutableSet.toImmutableSet());
    private static final ImmutableSet<String> REDACTED_RESPONSE_HEADERS = ImmutableSet.of((Object)"Set-Cookie".toLowerCase(Locale.US));
    private final ConcurrentMap<HttpRequest, HttpRequestResponseTimeTracker> requestTracker = new MapMaker().weakKeys().makeMap();
    private final long timeThresholdMs;
    private final ImmutableSet<String> filterProperties;

    public EventLoggingHttpRequestInitializer() {
        this(0L, (ImmutableSet<String>)ImmutableSet.of());
    }

    public EventLoggingHttpRequestInitializer(long timeThresholdMs, ImmutableSet<String> filterProperties) {
        this.timeThresholdMs = timeThresholdMs;
        this.filterProperties = filterProperties;
    }

    public void initialize(HttpRequest request) throws IOException {
        request.setInterceptor(httpRequest -> this.requestTracker.put(httpRequest, new HttpRequestResponseTimeTracker()));
        request.setResponseInterceptor(this::logAndRemoveRequestFromTracking);
    }

    @VisibleForTesting
    void logAndRemoveRequestFromTracking(HttpResponse httpResponse) {
        HttpRequest request = httpResponse.getRequest();
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        HttpRequestResponseTimeTracker tracker = (HttpRequestResponseTimeTracker)this.requestTracker.remove(request);
        if (tracker != null) {
            long responseTime = tracker.getResponseTime();
            if (responseTime < this.timeThresholdMs) {
                return;
            }
            this.addLogProperty("response_time", responseTime, jsonMap);
            this.addLogProperty("request_start_time_utc", tracker.getStartTimeUtc(), jsonMap);
            this.addLogProperty("request_finish_time_utc", tracker.getCurrentTimeUtc(), jsonMap);
        } else {
            this.addLogProperty("response_time", Integer.MAX_VALUE, jsonMap);
            this.addLogProperty("unexpected_error", "Unknown request. This is unexpected.", jsonMap);
        }
        this.addLogProperty("request_method", request.getRequestMethod(), jsonMap);
        this.addLogProperty("request_url", request.getUrl().toString(), jsonMap);
        this.addLogProperty("request_headers", EventLoggingHttpRequestInitializer.filterMap(request.getHeaders(), REDACTED_REQUEST_HEADERS), jsonMap);
        this.addLogProperty("response_headers", EventLoggingHttpRequestInitializer.filterMap(httpResponse.getHeaders(), REDACTED_RESPONSE_HEADERS), jsonMap);
        this.addLogProperty("response_status_code", httpResponse.getStatusCode(), jsonMap);
        this.addLogProperty("response_status_message", httpResponse.getStatusMessage(), jsonMap);
        this.addLogProperty("thread_name", Thread.currentThread().getName(), jsonMap);
        this.addLogProperty("x-goog-api-client", this.getInvocationId(request), jsonMap);
        this.logDetails(jsonMap);
    }

    private Object getInvocationId(HttpRequest request) {
        HttpHeaders headers = request.getHeaders();
        if (headers == null) {
            return "";
        }
        return headers.get((Object)"x-goog-api-client");
    }

    private void addLogProperty(String propertyName, Object value, Map<String, Object> jsonMap) {
        if (!this.filterProperties.contains((Object)propertyName.toLowerCase(Locale.US))) {
            jsonMap.put(propertyName, value);
        }
    }

    private void logDetails(Map<String, Object> jsonMap) {
        ((GoogleLogger.Api)logger.atInfo()).log("%s", (Object)LazyArgs.lazy(() -> this.gson.toJson((Object)jsonMap)));
    }

    private static ImmutableMap<String, Object> filterMap(HttpHeaders httpHeaders, Set<String> filterSet) {
        return (ImmutableMap)httpHeaders.entrySet().stream().filter(e -> !filterSet.contains(((String)e.getKey()).toLowerCase(Locale.US))).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static class HttpRequestResponseTimeTracker {
        private static final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneOffset.UTC);
        private final Stopwatch stopwatch = Stopwatch.createStarted();
        private final Instant startTime = Instant.now();

        private HttpRequestResponseTimeTracker() {
        }

        long getResponseTime() {
            return this.stopwatch.elapsed(TimeUnit.MILLISECONDS);
        }

        String getStartTimeUtc() {
            return dateTimeFormatter.format(this.startTime);
        }

        String getCurrentTimeUtc() {
            return dateTimeFormatter.format(Instant.now());
        }
    }
}

