/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.gcsio;

import com.google.cloud.hadoop.gcsio.StatisticTypeEnum;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.EnumSet;
import java.util.Iterator;

public enum GoogleCloudStorageStatistics {
    EXCEPTION_COUNT("exception_count", "Counts the number of exceptions encountered", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_REQUEST_COUNT("gcs_api_total_request_count", "Counts the total number of gcs requests made", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_SIDE_ERROR_COUNT("gcs_api_client_side_error_count", "Counts the occurrence of client side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_SIDE_ERROR_COUNT("gcs_api_server_side_error_count", "Counts the occurrence of server side error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_RATE_LIMIT_COUNT("gcs_api_client_rate_limit_error_count", "Counts the occurence of 429 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_BAD_REQUEST_COUNT("gcs_api_client_bad_request_count", "Counts the occurence of 400 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_UNAUTHORIZED_RESPONSE_COUNT("gcs_api_client_unauthorized_response_count", "Counts the occurence of 401 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_NOT_FOUND_RESPONSE_COUNT("gcs_api_client_non_found_response_count", "Counts the occurence of 404 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_REQUEST_TIMEOUT_COUNT("gcs_api_client_request_timeout_count", "Counts the occurence of 408 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_GONE_RESPONSE_COUNT("gcs_api_client_gone_response_count", "Counts the occurence of 410 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_PRECONDITION_FAILED_RESPONSE_COUNT("gcs_api_client_precondition_failed_response_count", "Counts the occurence of 412 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_CLIENT_REQUESTED_RANGE_NOT_SATISFIABLE_COUNT("gcs_api_client_requested_range_not_statisfiable_count", "Counts the occurence of 416 status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_INTERNAL_ERROR_COUNT("gcs_api_server_internal_error_count", "Counts the occurrence of server side 500 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_NOT_IMPLEMENTED_ERROR_COUNT("gcs_api_server_not_implemented_error_count", "Counts the occurrence of server side 501 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_BAD_GATEWAY_COUNT("gcs_api_server_bad_gateway_count", "Counts the occurrence of server side 502 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_SERVICE_UNAVAILABLE_COUNT("gcs_api_server_unavailable_count", "Counts the occurrence of server side 503 error status code", StatisticTypeEnum.TYPE_COUNTER),
    GCS_API_SERVER_TIMEOUT_COUNT("gcs_api_server_timeout_count", "Counts the occurrence of server side 504 error status code", StatisticTypeEnum.TYPE_COUNTER);

    public static final ImmutableSet<GoogleCloudStorageStatistics> VALUES;
    private static final ImmutableMap<String, GoogleCloudStorageStatistics> SYMBOL_MAP;
    private final String symbol;
    private final String description;
    private final StatisticTypeEnum type;

    private GoogleCloudStorageStatistics(String symbol, String description, StatisticTypeEnum type) {
        this.symbol = symbol;
        this.description = description;
        this.type = type;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static GoogleCloudStorageStatistics fromSymbol(String symbol) {
        return (GoogleCloudStorageStatistics)((Object)SYMBOL_MAP.get((Object)symbol));
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.symbol;
    }

    public StatisticTypeEnum getType() {
        return this.type;
    }

    static {
        VALUES = ImmutableSet.copyOf(EnumSet.allOf(GoogleCloudStorageStatistics.class));
        SYMBOL_MAP = Maps.uniqueIndex((Iterator)Iterators.forArray((Object[])GoogleCloudStorageStatistics.values()), GoogleCloudStorageStatistics::getSymbol);
    }
}

