/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.mp;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.WeakHashMap;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageException;
import org.snmp4j.MutablePDU;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.asn1.BER;
import org.snmp4j.asn1.BERInputStream;
import org.snmp4j.asn1.BEROutputStream;
import org.snmp4j.asn1.BERSerializable;
import org.snmp4j.event.CounterEvent;
import org.snmp4j.event.SnmpEngineEvent;
import org.snmp4j.event.SnmpEngineListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.CounterSupport;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.MutableStateReference;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.AuthenticationProtocol;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityParameters;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.SecurityStateReference;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.PDUFactory;

public class MPv3
implements MessageProcessingModel {
    public static final int ID = 3;
    public static final int MPv3_REPORTABLE_FLAG = 4;
    public static final int MAX_MESSAGE_ID = Integer.MAX_VALUE;
    public static final int MAXLEN_ENGINE_ID = 32;
    public static final int MINLEN_ENGINE_ID = 5;
    private static final int MAX_HEADER_PAYLOAD_LENGTH = new OctetString("\u0000").getBERLength() + 3 * new Integer32(Integer.MAX_VALUE).getBERLength();
    private static final int MAX_HEADER_LENGTH = MAX_HEADER_PAYLOAD_LENGTH + BER.getBERLengthOfLength(MAX_HEADER_PAYLOAD_LENGTH) + 1;
    private SecurityProtocols securityProtocols;
    private static final LogAdapter logger = LogFactory.getLogger(MPv3.class);
    private SecurityModels securityModels;
    private Cache cache;
    private Hashtable engineIDs;
    private byte[] localEngineID;
    private int currentMsgID = new Random().nextInt(Integer.MAX_VALUE);
    private static int enterpriseID = 4976;
    private CounterSupport counterSupport;
    transient Vector snmpEngineListeners;
    protected PDUFactory incomingPDUFactory = new PDUFactory(){

        public PDU createPDU(Target target) {
            return new ScopedPDU();
        }
    };

    public MPv3() {
        this(MPv3.createLocalEngineID(), null);
    }

    public MPv3(byte[] byArray) {
        this(byArray, null);
        this.setLocalEngineID(byArray);
    }

    public MPv3(byte[] byArray, PDUFactory pDUFactory) {
        if (pDUFactory != null) {
            this.incomingPDUFactory = pDUFactory;
        }
        this.engineIDs = new Hashtable();
        this.cache = new Cache();
        this.securityProtocols = SecurityProtocols.getInstance();
        this.securityModels = SecurityModels.getInstance();
        this.counterSupport = CounterSupport.getInstance();
        this.setLocalEngineID(byArray);
    }

    public static byte[] createLocalEngineID() {
        byte[] byArray = new byte[]{(byte)(0x80 | enterpriseID >> 24 & 0xFF), (byte)(enterpriseID >> 16 & 0xFF), (byte)(enterpriseID >> 8 & 0xFF), (byte)(enterpriseID & 0xFF), 1};
        OctetString octetString = new OctetString();
        try {
            octetString.setValue(InetAddress.getLocalHost().getAddress());
        }
        catch (UnknownHostException unknownHostException) {
            logger.debug("Local host cannot be determined for creation of local engine ID");
            byArray[4] = 4;
            octetString.setValue("SNMP4J".getBytes());
        }
        OctetString octetString2 = new OctetString(byArray);
        octetString2.append(octetString);
        return octetString2.getValue();
    }

    public static byte[] createLocalEngineID(OctetString octetString) {
        byte[] byArray = new byte[]{(byte)(0x80 | enterpriseID >> 24 & 0xFF), (byte)(enterpriseID >> 16 & 0xFF), (byte)(enterpriseID >> 8 & 0xFF), (byte)(enterpriseID & 0xFF), 4};
        OctetString octetString2 = new OctetString(byArray);
        octetString2.append(octetString);
        return octetString2.getValue();
    }

    public void setLocalEngineID(byte[] byArray) {
        if (byArray == null || byArray.length < 5 || byArray.length > 32) {
            throw new IllegalArgumentException("Illegal (local) engine ID");
        }
        this.localEngineID = byArray;
    }

    public byte[] getLocalEngineID() {
        byte[] byArray = new byte[this.localEngineID.length];
        System.arraycopy(this.localEngineID, 0, byArray, 0, this.localEngineID.length);
        return byArray;
    }

    public void initDefaults() {
        this.securityProtocols.addDefaultProtocols();
    }

    public AuthenticationProtocol getAuthProtocol(OID oID) {
        return this.securityProtocols.getAuthenticationProtocol(oID);
    }

    public PrivacyProtocol getPrivProtocol(OID oID) {
        return this.securityProtocols.getPrivacyProtocol(oID);
    }

    public SecurityModel getSecurityModel(int n) {
        return this.securityModels.getSecurityModel(new Integer32(n));
    }

    public int getID() {
        return 3;
    }

    public boolean isProtocolVersionSupported(int n) {
        return n == 3;
    }

    public boolean addEngineID(Address address, OctetString octetString) {
        if (!Arrays.equals(this.localEngineID, octetString.getValue())) {
            this.engineIDs.put(address, octetString);
            if (this.snmpEngineListeners != null) {
                this.fireEngineChanged(new SnmpEngineEvent(this, 1, octetString, address));
            }
            return true;
        }
        return false;
    }

    public OctetString getEngineID(Address address) {
        return (OctetString)this.engineIDs.get(address);
    }

    public OctetString removeEngineID(Address address) {
        OctetString octetString = (OctetString)this.engineIDs.remove(address);
        if (octetString != null && this.snmpEngineListeners != null) {
            this.fireEngineChanged(new SnmpEngineEvent(this, 2, octetString, address));
        }
        return octetString;
    }

    public synchronized int getNextMessageID() {
        if (this.currentMsgID >= Integer.MAX_VALUE) {
            this.currentMsgID = 1;
        }
        return this.currentMsgID++;
    }

    public SecurityProtocols getSecurityProtocols() {
        return this.securityProtocols;
    }

    public void setSecurityProtocols(SecurityProtocols securityProtocols) {
        this.securityProtocols = securityProtocols;
    }

    protected int getDefaultSecurityModel() {
        return 3;
    }

    public void releaseStateReference(PduHandle pduHandle) {
        this.cache.deleteEntry(pduHandle);
    }

    public int prepareOutgoingMessage(Address address, int n, int n2, int n3, byte[] byArray, int n4, PDU pDU, boolean bl, PduHandle pduHandle, Address address2, BEROutputStream bEROutputStream) throws IOException {
        if (!(pDU instanceof ScopedPDU)) {
            throw new IllegalArgumentException("MPv3 only accepts ScopedPDU instances as pdu parameter");
        }
        ScopedPDU scopedPDU = (ScopedPDU)pDU;
        byte[] byArray2 = null;
        OctetString octetString = (OctetString)this.engineIDs.get(address);
        if (octetString != null) {
            byArray2 = octetString.getValue();
            if (scopedPDU.getContextEngineID().length() == 0) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Context engine ID of scoped PDU is empty! Setting it to authoritative engine ID: " + octetString.toHexString());
                }
                scopedPDU.setContextEngineID(new OctetString(byArray2));
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (pDU.isConfirmedPdu()) {
            if (byArray2.length == 0) {
                n4 = 1;
                n3 = this.getDefaultSecurityModel();
                scopedPDU = (ScopedPDU)scopedPDU.clone();
                scopedPDU.clear();
            }
        } else if (scopedPDU.getContextEngineID().length() == 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("Context engine ID of unconfirmed scoped PDU is empty! Setting it to local engine ID");
            }
            scopedPDU.setContextEngineID(new OctetString(this.localEngineID));
        }
        int n5 = pDU.getBERLength();
        BEROutputStream bEROutputStream2 = new BEROutputStream(ByteBuffer.allocate(n5));
        scopedPDU.encodeBER(bEROutputStream2);
        HeaderData headerData = new HeaderData();
        int n6 = 0;
        switch (n4) {
            case 1: {
                n6 = 0;
                break;
            }
            case 2: {
                n6 = 1;
                break;
            }
            case 3: {
                n6 = 3;
            }
        }
        if (scopedPDU.isConfirmedPdu()) {
            n6 |= 4;
        } else {
            byArray2 = this.localEngineID;
        }
        int n7 = this.getNextMessageID();
        headerData.setMsgFlags(n6);
        headerData.setMsgID(n7);
        headerData.setMsgMaxSize(n);
        headerData.setSecurityModel(n3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerData.getBERLength());
        BEROutputStream bEROutputStream3 = new BEROutputStream(byteBuffer);
        headerData.encodeBER(bEROutputStream3);
        BERInputStream bERInputStream = new BERInputStream(bEROutputStream2.rewind());
        SecurityModel securityModel = this.securityModels.getSecurityModel(new Integer32(n3));
        if (securityModel == null) {
            return -1402;
        }
        SecurityParameters securityParameters = securityModel.newSecurityParametersInstance();
        int n8 = securityModel.generateRequestMessage(n2, byteBuffer.array(), n, n3, byArray2, byArray, n4, bERInputStream, securityParameters, bEROutputStream);
        if (n8 == 0 && bl) {
            this.cache.addEntry(new StateReference(n7, n6, n, pduHandle, address, null, byArray2, securityModel, byArray, n4, scopedPDU.getContextEngineID().getValue(), scopedPDU.getContextName().getValue(), null, n8));
        }
        return n8;
    }

    public int prepareResponseMessage(int n, int n2, int n3, byte[] byArray, int n4, PDU pDU, int n5, StateReference stateReference, StatusInformation statusInformation, BEROutputStream bEROutputStream) throws IOException {
        OctetString octetString;
        BEROutputStream bEROutputStream2;
        BERSerializable bERSerializable;
        StateReference stateReference2 = this.cache.popEntry(stateReference.getMsgID());
        if (stateReference2 == null) {
            return -1409;
        }
        int n6 = pDU.getBERLength();
        if (n6 > n5) {
            bERSerializable = new ScopedPDU((ScopedPDU)pDU);
            ((PDU)bERSerializable).clear();
            ((PDU)bERSerializable).setRequestID(pDU.getRequestID());
            ((PDU)bERSerializable).setErrorStatus(1);
            ((PDU)bERSerializable).setErrorIndex(0);
            n6 = ((PDU)bERSerializable).getBERLength();
            bEROutputStream2 = new BEROutputStream(ByteBuffer.allocate(n6));
            ((PDU)bERSerializable).encodeBER(bEROutputStream2);
        } else {
            bEROutputStream2 = new BEROutputStream(ByteBuffer.allocate(n6));
            pDU.encodeBER(bEROutputStream2);
        }
        bERSerializable = new HeaderData();
        int n7 = 0;
        switch (n4) {
            case 1: {
                n7 = 0;
                break;
            }
            case 2: {
                n7 = 1;
                break;
            }
            case 3: {
                n7 = 3;
            }
        }
        ((HeaderData)bERSerializable).setMsgFlags(n7);
        ((HeaderData)bERSerializable).setMsgID(stateReference.getMsgID());
        ((HeaderData)bERSerializable).setMsgMaxSize(n2);
        ((HeaderData)bERSerializable).setSecurityModel(n3);
        ByteBuffer byteBuffer = ByteBuffer.allocate(((HeaderData)bERSerializable).getBERLength());
        BEROutputStream bEROutputStream3 = new BEROutputStream(byteBuffer);
        ((HeaderData)bERSerializable).encodeBER(bEROutputStream3);
        switch (pDU.getType()) {
            case -94: 
            case -92: 
            case -89: 
            case -88: {
                octetString = new OctetString(this.localEngineID);
                break;
            }
            default: {
                octetString = new OctetString(stateReference2.getSecurityEngineID());
            }
        }
        BERInputStream bERInputStream = new BERInputStream(bEROutputStream2.rewind());
        SecurityModel securityModel = this.securityModels.getSecurityModel(new Integer32(n3));
        SecurityParameters securityParameters = securityModel.newSecurityParametersInstance();
        int n8 = securityModel.generateResponseMessage(this.getID(), byteBuffer.array(), n2, n3, octetString.getValue(), byArray, n4, bERInputStream, stateReference2.getSecurityStateReference(), securityParameters, bEROutputStream);
        return n8;
    }

    public int sendReport(MessageDispatcher messageDispatcher, ScopedPDU scopedPDU, int n, int n2, OctetString octetString, int n3, StateReference stateReference, VariableBinding variableBinding) {
        ScopedPDU scopedPDU2 = new ScopedPDU();
        scopedPDU2.setType(-88);
        if (scopedPDU != null) {
            scopedPDU2.setContextEngineID(scopedPDU.getContextEngineID());
            scopedPDU2.setContextName(scopedPDU.getContextName());
            scopedPDU2.setRequestID(scopedPDU.getRequestID());
        }
        scopedPDU2.add(variableBinding);
        StatusInformation statusInformation = new StatusInformation();
        try {
            int n4 = messageDispatcher.returnResponsePdu(this.getID(), n2, octetString.getValue(), n, scopedPDU2, n3, stateReference, statusInformation);
            if (n4 != 0) {
                logger.warn("Error while sending report: " + n4);
                return -1400;
            }
        }
        catch (MessageException messageException) {
            logger.error("Error while sending report: " + messageException.getMessage());
            return -1400;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int prepareDataElements(MessageDispatcher messageDispatcher, Address address, BERInputStream bERInputStream, Integer32 integer32, Integer32 integer322, OctetString octetString, Integer32 integer323, MutablePDU mutablePDU, PduHandle pduHandle, Integer32 integer324, StatusInformation statusInformation, MutableStateReference mutableStateReference) {
        try {
            OctetString octetString2;
            ScopedPDU scopedPDU;
            StateReference stateReference;
            block46: {
                Object object;
                stateReference = new StateReference();
                if (mutableStateReference.getStateReference() != null) {
                    stateReference.setTransportMapping(mutableStateReference.getStateReference().getTransportMapping());
                }
                integer32.setValue(3);
                bERInputStream.mark(16);
                BER.MutableByte mutableByte = new BER.MutableByte();
                int n = BER.decodeHeader(bERInputStream, mutableByte);
                if (mutableByte.getValue() != 48) {
                    return -1408;
                }
                long l = bERInputStream.getPosition();
                bERInputStream.reset();
                bERInputStream.mark(n);
                if (bERInputStream.skip(l) != l) {
                    return -1408;
                }
                Integer32 integer325 = new Integer32();
                integer325.decodeBER(bERInputStream);
                if (integer325.getValue() != 3) {
                    throw new RuntimeException("Internal error unexpected snmp version read");
                }
                HeaderData headerData = new HeaderData();
                headerData.decodeBER(bERInputStream);
                integer322.setValue(headerData.getSecurityModel());
                stateReference.setMsgID(headerData.getMsgID());
                stateReference.setMsgFlags(headerData.getMsgFlags());
                stateReference.setAddress(address);
                mutableStateReference.setStateReference(stateReference);
                integer324.setValue(headerData.msgMaxSize.getValue() - MAX_HEADER_LENGTH);
                scopedPDU = new ScopedPDU();
                mutablePDU.setPdu(scopedPDU);
                SecurityModel securityModel = this.securityModels.getSecurityModel(integer322);
                if (securityModel == null) {
                    logger.error("RFC3412 \u00a77.2.4 - Unsupported security model: " + integer322);
                    CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.snmpUnknownSecurityModels);
                    this.fireIncrementCounter(counterEvent);
                    return -1402;
                }
                switch (headerData.getMsgFlags() & 3) {
                    case 3: {
                        integer323.setValue(3);
                        break;
                    }
                    case 0: {
                        integer323.setValue(1);
                        break;
                    }
                    case 1: {
                        integer323.setValue(2);
                        break;
                    }
                    default: {
                        integer323.setValue(1);
                        logger.debug("RFC3412 \u00a77.2.5 - Invalid message (illegal msgFlags)");
                        CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.snmpInvalidMsgs);
                        this.fireIncrementCounter(counterEvent);
                        return -1405;
                    }
                }
                int n2 = (int)bERInputStream.getPosition();
                SecurityParameters securityParameters = securityModel.newSecurityParametersInstance();
                securityParameters.decodeBER(bERInputStream);
                securityParameters.setSecurityParametersPosition(n2);
                boolean bl = (headerData.getMsgFlags() & 4) > 0;
                octetString2 = new OctetString();
                SecurityStateReference securityStateReference = securityModel.newSecurityStateReference();
                bERInputStream.reset();
                BEROutputStream bEROutputStream = new BEROutputStream();
                int n3 = securityModel.processIncomingMsg(integer325.getValue(), headerData.getMsgMaxSize() - MAX_HEADER_LENGTH, securityParameters, securityModel, integer323.getValue(), bERInputStream, octetString2, octetString, bEROutputStream, integer324, securityStateReference, statusInformation);
                bERInputStream.close();
                if (n3 == 0) {
                    try {
                        object = new BERInputStream(bEROutputStream.rewind());
                        scopedPDU.decodeBER((BERInputStream)object);
                        pduHandle.setTransactionID(scopedPDU.getRequestID().getValue());
                        this.addEngineID(address, octetString2);
                    }
                    catch (IOException iOException) {
                        logger.warn("ASN.1 parse error: " + iOException.getMessage());
                        if (logger.isDebugEnabled()) {
                            iOException.printStackTrace();
                        }
                        CounterEvent counterEvent = new CounterEvent(this, SnmpConstants.snmpInASNParseErrs);
                        this.fireIncrementCounter(counterEvent);
                        return -1408;
                    }
                    if ((scopedPDU.getContextEngineID() == null || scopedPDU.getContextEngineID().length() == 0) && scopedPDU.getType() != -94 && scopedPDU.getType() != -88) {
                        object = new CounterEvent(this, SnmpConstants.snmpUnknownPDUHandlers);
                        this.fireIncrementCounter((CounterEvent)object);
                        VariableBinding variableBinding = new VariableBinding(((CounterEvent)object).getOid(), ((CounterEvent)object).getCurrentValue());
                        statusInformation.setErrorIndication(variableBinding);
                        n3 = -1415;
                    }
                }
                if (n3 != 0) {
                    if (bl && statusInformation.getErrorIndication() != null) {
                        try {
                            if (bEROutputStream.getBuffer() != null) {
                                object = new BERInputStream(bEROutputStream.rewind());
                                scopedPDU.decodeBER((BERInputStream)object);
                            } else {
                                scopedPDU = null;
                            }
                        }
                        catch (IOException iOException) {
                            logger.warn(iOException);
                            scopedPDU = null;
                        }
                        object = new StateReference(headerData.getMsgID(), headerData.getMsgFlags(), integer324.getValue(), pduHandle, address, null, octetString2.getValue(), securityModel, octetString.getValue(), integer323.getValue(), scopedPDU == null ? new byte[]{} : scopedPDU.getContextEngineID().getValue(), scopedPDU == null ? new byte[]{} : scopedPDU.getContextName().getValue(), securityStateReference, n3);
                        this.cache.addEntry((StateReference)object);
                        int n4 = this.sendReport(messageDispatcher, scopedPDU, statusInformation.getSecurityLevel().getValue(), securityModel.getID(), octetString, integer324.getValue(), stateReference, statusInformation.getErrorIndication());
                        if (n4 != 0) {
                            logger.warn("Sending report failed with error code: " + n4);
                        }
                    }
                    return -1414;
                }
                stateReference.setAddress(address);
                stateReference.setSecurityName(octetString.getValue());
                stateReference.setContextEngineID(scopedPDU.getContextEngineID().getValue());
                stateReference.setContextName(scopedPDU.getContextName().getValue());
                stateReference.setMaxSizeResponseScopedPDU(integer324.getValue());
                stateReference.setMsgID(headerData.getMsgID());
                stateReference.setMsgFlags(headerData.getMsgFlags());
                stateReference.setSecurityEngineID(octetString2.getValue());
                stateReference.setSecurityLevel(integer323.getValue());
                stateReference.setSecurityModel(securityModel);
                stateReference.setSecurityStateReference(securityStateReference);
                stateReference.setPduHandle(pduHandle);
                if (scopedPDU.getType() == -94 || scopedPDU.getType() == -88) {
                    object = this.cache.popEntry(headerData.getMsgID());
                    if (object != null) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("RFC3412 \u00a77.2.10 - Received PDU (msgID=" + headerData.getMsgID() + ") is a response or " + "an internal class message. PduHandle.transactionID = " + ((StateReference)object).getPduHandle().getTransactionID());
                        }
                        pduHandle.copyFrom(((StateReference)object).getPduHandle());
                        if (scopedPDU.getType() == -88) {
                            statusInformation.setContextEngineID(scopedPDU.getContextEngineID().getValue());
                            statusInformation.setContextName(scopedPDU.getContextName().getValue());
                            statusInformation.setSecurityLevel(integer323);
                            if (((StateReference)object).getSecurityEngineID().length != 0 && !octetString2.equals(((StateReference)object).getSecurityEngineID()) || securityModel.getID() != ((StateReference)object).getSecurityModel().getID() || !octetString.equals(((StateReference)object).getSecurityName()) && octetString.length() != 0) {
                                if (logger.isDebugEnabled()) {
                                    logger.debug("RFC 3412 \u00a77.2.11 - Received report message does not match sent message");
                                }
                                mutableStateReference.setStateReference(null);
                                return -1410;
                            }
                            if (!this.addEngineID(((StateReference)object).getAddress(), octetString2) && logger.isWarnEnabled()) {
                                logger.warn("Engine ID '" + octetString2 + "' could not be added to engine ID cache for " + "target address '" + ((StateReference)object).getAddress() + "' because engine ID matches local engine ID");
                            }
                            mutableStateReference.setStateReference(null);
                            logger.debug("MPv3 finished");
                            return 0;
                        }
                        if (scopedPDU.getType() == -94) {
                            if (!octetString2.equals(((StateReference)object).getSecurityEngineID()) && ((StateReference)object).getSecurityEngineID().length != 0 || securityModel.getID() != ((StateReference)object).getSecurityModel().getID() || !octetString.equals(((StateReference)object).getSecurityName()) || integer323.getValue() != ((StateReference)object).getSecurityLevel() || !scopedPDU.getContextEngineID().equals(((StateReference)object).getContextEngineID()) && ((StateReference)object).getContextEngineID().length != 0 || !scopedPDU.getContextName().equals(((StateReference)object).getContextName()) && ((StateReference)object).getContextName().length != 0) {
                                logger.debug("RFC 3412 \u00a77.2.12.b - Received response message does not match sent message");
                                mutableStateReference.setStateReference(null);
                                return -1410;
                            }
                            mutableStateReference.setStateReference(null);
                            logger.debug("MPv3 finished");
                            return 0;
                        }
                        break block46;
                    } else {
                        if (logger.isDebugEnabled()) {
                            logger.debug("RFC3412 \u00a77.2.10 - Received PDU (msgID=" + headerData.getMsgID() + ") is a response or " + "internal class message, but cached " + "information for the msgID could not be found");
                        }
                        return -1409;
                    }
                }
                logger.debug("RFC3412 \u00a77.2.10 - Received PDU is NOT a response or internal class message -> unchanged PduHandle = " + pduHandle);
            }
            switch (scopedPDU.getType()) {
                case -96: 
                case -95: 
                case -93: 
                case -91: 
                case -90: {
                    if (octetString2.length() == 0) {
                        logger.debug("Received confirmed message with 0 length security engine ID");
                    } else if (!octetString2.equals(this.localEngineID)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("RFC 3412 \u00a77.2.13.a - Security engine ID " + octetString2.toHexString() + " does not match local engine ID " + new OctetString(this.localEngineID).toHexString());
                        }
                        mutableStateReference.setStateReference(null);
                        return -1406;
                    }
                    int n = this.cache.addEntry(stateReference);
                    if (n == -1404) {
                        mutableStateReference.setStateReference(null);
                    }
                    return 0;
                }
                case -92: 
                case -89: {
                    mutableStateReference.setStateReference(null);
                    return 0;
                }
            }
            return -1400;
        }
        catch (IOException iOException) {
            logger.warn("MPv3 parse error: " + iOException.getMessage());
            if (logger.isDebugEnabled()) {
                iOException.printStackTrace();
            }
            return -1408;
        }
    }

    public void setSecurityModels(SecurityModels securityModels) {
        this.securityModels = securityModels;
    }

    public SecurityModels getSecurityModels() {
        return this.securityModels;
    }

    public static int getEnterpriseID() {
        return enterpriseID;
    }

    public static void setEnterpriseID(int n) {
        enterpriseID = n;
    }

    protected void fireIncrementCounter(CounterEvent counterEvent) {
        this.counterSupport.fireIncrementCounter(counterEvent);
    }

    public CounterSupport getCounterSupport() {
        return this.counterSupport;
    }

    public void setCounterSupport(CounterSupport counterSupport) {
        if (counterSupport == null) {
            throw new NullPointerException();
        }
        this.counterSupport = counterSupport;
    }

    public synchronized void addSnmpEngineListener(SnmpEngineListener snmpEngineListener) {
        if (this.snmpEngineListeners == null) {
            this.snmpEngineListeners = new Vector();
        }
        this.snmpEngineListeners.add(snmpEngineListener);
    }

    public synchronized void removeSnmpEngineListener(SnmpEngineListener snmpEngineListener) {
        if (this.snmpEngineListeners != null) {
            this.snmpEngineListeners.remove(snmpEngineListener);
        }
    }

    public PDU createPDU(Target target) {
        return new ScopedPDU();
    }

    protected void fireEngineChanged(SnmpEngineEvent snmpEngineEvent) {
        if (this.snmpEngineListeners != null) {
            Vector vector = this.snmpEngineListeners;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((SnmpEngineListener)vector.elementAt(i)).engineChanged(snmpEngineEvent);
            }
        }
    }

    protected static class HeaderData
    implements BERSerializable {
        public static final byte FLAG_AUTH = 1;
        public static final byte FLAG_PRIV = 2;
        Integer32 msgID = new Integer32(0);
        Integer32 msgMaxSize = new Integer32(Integer.MAX_VALUE);
        OctetString msgFlags = new OctetString(new byte[1]);
        Integer32 securityModel = new Integer32(0);

        protected HeaderData() {
        }

        public void setMsgID(int n) {
            this.msgID.setValue(n);
        }

        public int getMsgID() {
            return this.msgID.getValue();
        }

        public void setMsgMaxSize(int n) {
            this.msgMaxSize.setValue(n);
        }

        public int getMsgMaxSize() {
            return this.msgMaxSize.getValue();
        }

        public void setMsgFlags(int n) {
            this.msgFlags.getValue()[0] = (byte)n;
        }

        public int getMsgFlags() {
            return this.msgFlags.getValue()[0] & 0xFF;
        }

        public void setSecurityModel(int n) {
            this.securityModel.setValue(n);
        }

        public int getSecurityModel() {
            return this.securityModel.getValue();
        }

        public int getBERPayloadLength() {
            int n = this.msgID.getBERLength();
            n += this.msgMaxSize.getBERLength();
            n += this.msgFlags.getBERLength();
            return n += this.securityModel.getBERLength();
        }

        public int getBERLength() {
            int n = this.getBERPayloadLength();
            n += BER.getBERLengthOfLength(n) + 1;
            return n;
        }

        public void decodeBER(BERInputStream bERInputStream) throws IOException {
            BER.MutableByte mutableByte = new BER.MutableByte();
            int n = BER.decodeHeader(bERInputStream, mutableByte);
            if (mutableByte.getValue() != 48) {
                throw new IOException("Unexpected sequence header type: " + mutableByte.getValue());
            }
            this.msgID.decodeBER(bERInputStream);
            this.msgMaxSize.decodeBER(bERInputStream);
            if (this.msgMaxSize.getValue() < 484) {
                throw new IOException("Invalid msgMaxSize: " + this.msgMaxSize);
            }
            this.msgFlags.decodeBER(bERInputStream);
            if (this.msgFlags.length() != 1) {
                throw new IOException("Message flags length != 1: " + this.msgFlags.length());
            }
            this.securityModel.decodeBER(bERInputStream);
            if (logger.isDebugEnabled()) {
                logger.debug("SNMPv3 header decoded: msgId=" + this.msgID + ", msgMaxSize=" + this.msgMaxSize + ", msgFlags=" + this.msgFlags.toHexString() + ", secModel=" + this.securityModel);
            }
            BER.checkSequenceLength(n, this);
        }

        public void encodeBER(OutputStream outputStream) throws IOException {
            BER.encodeHeader(outputStream, 48, this.getBERPayloadLength());
            this.msgID.encodeBER(outputStream);
            this.msgMaxSize.encodeBER(outputStream);
            this.msgFlags.encodeBER(outputStream);
            this.securityModel.encodeBER(outputStream);
        }
    }

    protected static class Cache {
        private Map entries = new WeakHashMap(25);

        protected Cache() {
        }

        public synchronized int addEntry(StateReference stateReference) {
            StateReference stateReference2;
            if (logger.isDebugEnabled()) {
                logger.debug("Adding cache entry: " + stateReference);
            }
            if ((stateReference2 = (StateReference)this.entries.get(stateReference.getPduHandle())) != null && stateReference2.equals(stateReference)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Doubled message: " + stateReference);
                }
                return -1404;
            }
            PduHandle pduHandle = stateReference.getPduHandle();
            stateReference.setPduHandle(null);
            this.entries.put(pduHandle, stateReference);
            return 0;
        }

        public synchronized boolean deleteEntry(PduHandle pduHandle) {
            StateReference stateReference = (StateReference)this.entries.remove(pduHandle);
            return stateReference != null;
        }

        public synchronized StateReference popEntry(int n) {
            Iterator iterator = this.entries.keySet().iterator();
            while (iterator.hasNext()) {
                PduHandle pduHandle = (PduHandle)iterator.next();
                StateReference stateReference = (StateReference)this.entries.get(pduHandle);
                if (stateReference == null || stateReference.getMsgID() != n) continue;
                iterator.remove();
                stateReference.setPduHandle(pduHandle);
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed cache entry: " + stateReference);
                }
                return stateReference;
            }
            return null;
        }
    }

    protected static class CacheEntry
    extends StateReference {
        int msgID;
        long transactionID;
        byte[] secEngineID;
        SecurityModel secModel;
        byte[] secName;
        int secLevel;
        byte[] contextEngineID;
        byte[] contextName;
        SecurityStateReference secStateReference;
        int errorCode;

        public CacheEntry(int n, long l, byte[] byArray, SecurityModel securityModel, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4, SecurityStateReference securityStateReference, int n3) {
            this.msgID = n;
            this.transactionID = l;
            this.secEngineID = byArray;
            this.secModel = securityModel;
            this.secName = byArray2;
            this.secLevel = n2;
            this.contextEngineID = byArray3;
            this.contextName = byArray4;
            this.secStateReference = securityStateReference;
            this.errorCode = n3;
        }
    }
}

