/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.Arrays;
import java.util.EventObject;
import org.snmp4j.PDU;
import org.snmp4j.smi.VariableBinding;

public abstract class RetrievalEvent
extends EventObject {
    public static final int STATUS_OK = 0;
    public static final int STATUS_TIMEOUT = -1;
    public static final int STATUS_WRONG_ORDER = -2;
    public static final int STATUS_REPORT = -3;
    public static final int STATUS_EXCEPTION = -4;
    protected VariableBinding[] vbs;
    protected int status = 0;
    protected Object userObject;
    protected Exception exception;
    protected PDU reportPDU;

    protected RetrievalEvent(Object object, Object object2) {
        super(object);
        this.userObject = object2;
    }

    public RetrievalEvent(Object object, Object object2, int n) {
        this(object, object2);
        this.status = n;
    }

    public RetrievalEvent(Object object, Object object2, Exception exception) {
        this(object, object2);
        this.exception = exception;
        this.status = -4;
    }

    public RetrievalEvent(Object object, Object object2, PDU pDU) {
        this(object, object2);
        this.reportPDU = pDU;
        this.status = -3;
    }

    public RetrievalEvent(Object object, Object object2, VariableBinding[] variableBindingArray) {
        this(object, object2);
        this.vbs = variableBindingArray;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isError() {
        return this.status != 0;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public Exception getException() {
        return this.exception;
    }

    public PDU getReportPDU() {
        return this.reportPDU;
    }

    public String getErrorMessage() {
        switch (this.status) {
            case -4: {
                return this.exception.getMessage();
            }
            case -3: {
                return "Report: " + this.reportPDU.get(0);
            }
            case -1: {
                return "Request timed out.";
            }
            case -2: {
                return "Agent did not return variable bindings in lexicographic order.";
            }
        }
        return "";
    }

    public String toString() {
        return this.getClass().getName() + "[vbs=" + (this.vbs == null ? "null" : "" + Arrays.asList(this.vbs)) + ",status=" + this.status + ",exception=" + this.exception + ",report=" + this.reportPDU + "]";
    }
}

