/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.salesforceinsert;

import com.sforce.soap.partner.Field;
import com.sforce.soap.partner.FieldType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceConnection;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformDialog;
import org.apache.hop.pipeline.transforms.salesforce.SalesforceTransformMeta;
import org.apache.hop.pipeline.transforms.salesforceinsert.SalesforceInsertMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.LabelTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class SalesforceInsertDialog
extends SalesforceTransformDialog {
    private static final Class<?> PKG = SalesforceInsertMeta.class;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciReturn;
    private TableView wReturn;
    private SalesforceInsertMeta input;
    private LabelTextVar wUserName;
    private LabelTextVar wURL;
    private LabelTextVar wPassword;
    private TextVar wBatchSize;
    private ComboVar wModule;
    private TextVar wSalesforceIDFieldName;
    private Button wUseCompression;
    private TextVar wTimeOut;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();
    private boolean gotModule = false;
    private boolean gotFields = false;
    private Button wRollbackAllChangesOnError;
    private boolean getModulesListError = false;

    public SalesforceInsertDialog(Shell parent, IVariables variables, SalesforceInsertMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        ModifyListener lsTableMod = arg0 -> {
            this.input.setChanged();
            this.setModuleFieldCombo();
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SalesforceInsertDialog.this.input.setChanged();
                SalesforceInsertDialog.this.setModuleFieldCombo();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setFont(GuiResource.getInstance().getFontDefault());
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.General.Tab", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wConnectionGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wConnectionGroup);
        wConnectionGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ConnectionGroup.Label", (String[])new String[0]));
        FormLayout connectionGroupLayout = new FormLayout();
        connectionGroupLayout.marginWidth = 10;
        connectionGroupLayout.marginHeight = 10;
        wConnectionGroup.setLayout((Layout)connectionGroupLayout);
        this.wURL = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.URL.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.URL.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wURL);
        this.wURL.addModifyListener(lsMod);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(0, 0);
        fdURL.top = new FormAttachment((Control)this.wTransformName, margin);
        fdURL.right = new FormAttachment(100, 0);
        this.wURL.setLayoutData((Object)fdURL);
        this.wUserName = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.User.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wUserName);
        this.wUserName.addModifyListener(lsMod);
        FormData fdUserName = new FormData();
        fdUserName.left = new FormAttachment(0, 0);
        fdUserName.top = new FormAttachment((Control)this.wURL, margin);
        fdUserName.right = new FormAttachment(100, 0);
        this.wUserName.setLayoutData((Object)fdUserName);
        this.wPassword = new LabelTextVar(this.variables, (Composite)wConnectionGroup, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.Password.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.Password.Tooltip", (String[])new String[0]), true);
        PropsUi.setLook((Widget)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(0, 0);
        fdPassword.top = new FormAttachment((Control)this.wUserName, margin);
        fdPassword.right = new FormAttachment(100, 0);
        this.wPassword.setLayoutData((Object)fdPassword);
        Button wTest = new Button((Composite)wConnectionGroup, 8);
        wTest.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.TestConnection.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wTest);
        FormData fdTest = new FormData();
        wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.TestConnection.Tooltip", (String[])new String[0]));
        fdTest.top = new FormAttachment((Control)this.wPassword, margin);
        fdTest.right = new FormAttachment(100, 0);
        wTest.setLayoutData((Object)fdTest);
        FormData fdConnectionGroup = new FormData();
        fdConnectionGroup.left = new FormAttachment(0, margin);
        fdConnectionGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdConnectionGroup.right = new FormAttachment(100, -margin);
        wConnectionGroup.setLayoutData((Object)fdConnectionGroup);
        Group wSettingsGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.SettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        Label wlTimeOut = new Label((Composite)wSettingsGroup, 131072);
        wlTimeOut.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.TimeOut.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTimeOut);
        FormData fdlTimeOut = new FormData();
        fdlTimeOut.left = new FormAttachment(0, 0);
        fdlTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlTimeOut.right = new FormAttachment(middle, -margin);
        wlTimeOut.setLayoutData((Object)fdlTimeOut);
        this.wTimeOut = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wTimeOut);
        this.wTimeOut.addModifyListener(lsMod);
        FormData fdTimeOut = new FormData();
        fdTimeOut.left = new FormAttachment(middle, 0);
        fdTimeOut.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdTimeOut.right = new FormAttachment(100, 0);
        this.wTimeOut.setLayoutData((Object)fdTimeOut);
        Label wlUseCompression = new Label((Composite)wSettingsGroup, 131072);
        wlUseCompression.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.UseCompression.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseCompression);
        FormData fdlUseCompression = new FormData();
        fdlUseCompression.left = new FormAttachment(0, 0);
        fdlUseCompression.top = new FormAttachment((Control)this.wTimeOut, margin);
        fdlUseCompression.right = new FormAttachment(middle, -margin);
        wlUseCompression.setLayoutData((Object)fdlUseCompression);
        this.wUseCompression = new Button((Composite)wSettingsGroup, 32);
        PropsUi.setLook((Widget)this.wUseCompression);
        this.wUseCompression.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.UseCompression.Tooltip", (String[])new String[0]));
        FormData fdUseCompression = new FormData();
        fdUseCompression.left = new FormAttachment(middle, 0);
        fdUseCompression.top = new FormAttachment((Control)wlUseCompression, 0, 0x1000000);
        this.wUseCompression.setLayoutData((Object)fdUseCompression);
        this.wUseCompression.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Label wlRollbackAllChangesOnError = new Label((Composite)wSettingsGroup, 131072);
        wlRollbackAllChangesOnError.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.RollbackAllChangesOnError.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRollbackAllChangesOnError);
        FormData fdlRollbackAllChangesOnError = new FormData();
        fdlRollbackAllChangesOnError.left = new FormAttachment(0, 0);
        fdlRollbackAllChangesOnError.top = new FormAttachment((Control)this.wUseCompression, margin);
        fdlRollbackAllChangesOnError.right = new FormAttachment(middle, -margin);
        wlRollbackAllChangesOnError.setLayoutData((Object)fdlRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError = new Button((Composite)wSettingsGroup, 32);
        this.wRollbackAllChangesOnError.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        PropsUi.setLook((Widget)this.wRollbackAllChangesOnError);
        this.wRollbackAllChangesOnError.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.RollbackAllChangesOnError.Tooltip", (String[])new String[0]));
        FormData fdRollbackAllChangesOnError = new FormData();
        fdRollbackAllChangesOnError.left = new FormAttachment(middle, 0);
        fdRollbackAllChangesOnError.top = new FormAttachment((Control)wlRollbackAllChangesOnError, 0, 0x1000000);
        this.wRollbackAllChangesOnError.setLayoutData((Object)fdRollbackAllChangesOnError);
        Label wlBatchSize = new Label((Composite)wSettingsGroup, 131072);
        wlBatchSize.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)wSettingsGroup, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wRollbackAllChangesOnError, margin);
        fdBatchSize.right = new FormAttachment(100, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        Label wlModule = new Label((Composite)wSettingsGroup, 131072);
        wlModule.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.Module.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlModule);
        FormData fdlModule = new FormData();
        fdlModule.left = new FormAttachment(0, 0);
        fdlModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdlModule.right = new FormAttachment(middle, -margin);
        wlModule.setLayoutData((Object)fdlModule);
        this.wModule = new ComboVar(this.variables, (Composite)wSettingsGroup, 2060);
        this.wModule.setEditable(true);
        PropsUi.setLook((Widget)this.wModule);
        this.wModule.addModifyListener(lsTableMod);
        this.wModule.addSelectionListener((SelectionListener)lsSelection);
        FormData fdModule = new FormData();
        fdModule.left = new FormAttachment(middle, 0);
        fdModule.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdModule.right = new FormAttachment(100, -margin);
        this.wModule.setLayoutData((Object)fdModule);
        this.wModule.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SalesforceInsertDialog.this.getModulesListError = false;
            }

            public void focusGained(FocusEvent e) {
                if (Utils.isEmpty((CharSequence)SalesforceInsertDialog.this.wURL.getText()) || Utils.isEmpty((CharSequence)SalesforceInsertDialog.this.wUserName.getText()) || Utils.isEmpty((CharSequence)SalesforceInsertDialog.this.wPassword.getText()) || SalesforceInsertDialog.this.getModulesListError) {
                    return;
                }
                Cursor busy = new Cursor((Device)SalesforceInsertDialog.this.shell.getDisplay(), 1);
                SalesforceInsertDialog.this.shell.setCursor(busy);
                SalesforceInsertDialog.this.getModulesList();
                SalesforceInsertDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)wConnectionGroup, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        Group wOutFieldsGroup = new Group(wGeneralComp, 32);
        PropsUi.setLook((Widget)wOutFieldsGroup);
        wOutFieldsGroup.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.OutFieldsGroup.Label", (String[])new String[0]));
        FormLayout outFieldsGroupLayout = new FormLayout();
        outFieldsGroupLayout.marginWidth = 10;
        outFieldsGroupLayout.marginHeight = 10;
        wOutFieldsGroup.setLayout((Layout)outFieldsGroupLayout);
        Label wlSalesforceIDFieldName = new Label((Composite)wOutFieldsGroup, 131072);
        wlSalesforceIDFieldName.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.SalesforceIDFieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSalesforceIDFieldName);
        FormData fdlSalesforceIDFieldName = new FormData();
        fdlSalesforceIDFieldName.left = new FormAttachment(0, 0);
        fdlSalesforceIDFieldName.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdlSalesforceIDFieldName.right = new FormAttachment(middle, -margin);
        wlSalesforceIDFieldName.setLayoutData((Object)fdlSalesforceIDFieldName);
        this.wSalesforceIDFieldName = new TextVar(this.variables, (Composite)wOutFieldsGroup, 18436);
        PropsUi.setLook((Widget)this.wSalesforceIDFieldName);
        this.wSalesforceIDFieldName.setToolTipText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.SalesforceIDFieldName.Tooltip", (String[])new String[0]));
        this.wSalesforceIDFieldName.addModifyListener(lsMod);
        FormData fdSalesforceIDFieldName = new FormData();
        fdSalesforceIDFieldName.left = new FormAttachment(middle, 0);
        fdSalesforceIDFieldName.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdSalesforceIDFieldName.right = new FormAttachment(100, 0);
        this.wSalesforceIDFieldName.setLayoutData((Object)fdSalesforceIDFieldName);
        FormData fdOutFieldsGroup = new FormData();
        fdOutFieldsGroup.left = new FormAttachment(0, margin);
        fdOutFieldsGroup.top = new FormAttachment((Control)wSettingsGroup, margin);
        fdOutFieldsGroup.right = new FormAttachment(100, -margin);
        wOutFieldsGroup.setLayoutData((Object)fdOutFieldsGroup);
        Label wlReturn = new Label(wGeneralComp, 0);
        wlReturn.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.UpdateFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        FormData fdlReturn = new FormData();
        fdlReturn.left = new FormAttachment(0, 0);
        fdlReturn.top = new FormAttachment((Control)wOutFieldsGroup, margin);
        wlReturn.setLayoutData((Object)fdlReturn);
        int upInsCols = 3;
        int upInsRows = this.input.getUpdateLookup() != null ? this.input.getUpdateLookup().length : 1;
        this.ciReturn = new ColumnInfo[upInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ColumnInfo.UseExternalId", (String[])new String[0]), 2, new String[]{"Y", "N"});
        this.ciReturn[2].setToolTip(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ColumnInfo.UseExternalId.Tooltip", (String[])new String[0]));
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, wGeneralComp, 68354, this.ciReturn, upInsRows, lsMod, this.props);
        Button wDoMapping = new Button(wGeneralComp, 8);
        wDoMapping.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)wlReturn, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        wDoMapping.setLayoutData((Object)fdDoMapping);
        wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdReturn = new FormData();
        fdReturn.left = new FormAttachment(0, 0);
        fdReturn.top = new FormAttachment((Control)wlReturn, margin);
        fdReturn.right = new FormAttachment((Control)wDoMapping, -margin);
        fdReturn.bottom = new FormAttachment(100, -2 * margin);
        this.wReturn.setLayoutData((Object)fdReturn);
        Button wGetLU = new Button(wGeneralComp, 8);
        wGetLU.setText(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.GetAndUpdateFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wDoMapping, margin);
        fdGetLU.left = new FormAttachment((Control)this.wReturn, margin);
        fdGetLU.right = new FormAttachment(100, 0);
        wGetLU.setLayoutData((Object)fdGetLU);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                    HopGui.getInstance().getDisplay().asyncExec(() -> {
                        if (!this.wReturn.isDisposed()) {
                            for (int i = 0; i < this.wReturn.table.getItemCount(); ++i) {
                                TableItem it = this.wReturn.table.getItem(i);
                                if (Utils.isEmpty((CharSequence)it.getText(2)) || this.inputFields.containsKey(it.getText(2))) continue;
                                it.setBackground(GuiResource.getInstance().getColorRed());
                            }
                        }
                    });
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment((Control)this.wTransformName, margin);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOk.addListener(13, e -> this.ok());
        wGetLU.addListener(13, e -> this.getUpdate());
        wTest.addListener(13, e -> this.test());
        this.wCancel.addListener(13, e -> this.cancel());
        wTabFolder.setSelection(0);
        this.getData(this.input);
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getUpdate() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> {
                    tableItem.setText(3, "Y");
                    return true;
                };
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData(SalesforceInsertMeta in) {
        this.wURL.setText(Const.NVL((String)in.getTargetUrl(), (String)""));
        this.wUserName.setText(Const.NVL((String)in.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)in.getPassword(), (String)""));
        this.wBatchSize.setText(in.getBatchSize());
        this.wModule.setText(Const.NVL((String)in.getModule(), (String)"Account"));
        this.wBatchSize.setText(in.getBatchSize());
        this.wSalesforceIDFieldName.setText(Const.NVL((String)in.getSalesforceIDFieldName(), (String)""));
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        }
        if (this.input.getUpdateLookup() != null) {
            for (int i = 0; i < this.input.getUpdateLookup().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getUpdateLookup()[i] != null) {
                    item.setText(1, this.input.getUpdateLookup()[i]);
                }
                if (this.input.getUpdateStream()[i] != null) {
                    item.setText(2, this.input.getUpdateStream()[i]);
                }
                if (this.input.getUseExternalId()[i] == null || this.input.getUseExternalId()[i].booleanValue()) {
                    item.setText(3, "Y");
                    continue;
                }
                item.setText(3, "N");
            }
        }
        this.wReturn.removeEmptyRows();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
        this.wTimeOut.setText(Const.NVL((String)in.getTimeout(), (String)"60000"));
        this.wUseCompression.setSelection(in.isCompression());
        this.wRollbackAllChangesOnError.setSelection(in.isRollbackAllChangesOnError());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        try {
            this.getInfo(this.input);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ErrorValidateData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ErrorValidateData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    @Override
    protected void getInfo(SalesforceTransformMeta in) throws HopException {
        SalesforceInsertMeta meta = (SalesforceInsertMeta)in;
        this.transformName = this.wTransformName.getText();
        meta.setTargetUrl(Const.NVL((String)this.wURL.getText(), (String)"https://login.salesforce.com/services/Soap/u/50.0"));
        meta.setUsername(this.wUserName.getText());
        meta.setPassword(this.wPassword.getText());
        meta.setModule(Const.NVL((String)this.wModule.getText(), (String)"Account"));
        meta.setSalesforceIDFieldName(this.wSalesforceIDFieldName.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        int nrFields = this.wReturn.nrNonEmpty();
        meta.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            meta.getUpdateLookup()[i] = item.getText(1);
            meta.getUpdateStream()[i] = item.getText(2);
            meta.getUseExternalId()[i] = "Y".equals(item.getText(3));
        }
        meta.setCompression(this.wUseCompression.getSelection());
        meta.setTimeout(Const.NVL((String)this.wTimeOut.getText(), (String)"0"));
        meta.setRollbackAllChangesOnError(this.wRollbackAllChangesOnError.getSelection());
    }

    private boolean checkInput() {
        if (Utils.isEmpty((CharSequence)this.wModule.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ModuleMissing.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return this.checkUser();
    }

    private boolean checkUser() {
        if (Utils.isEmpty((CharSequence)this.wUserName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.UsernameMissing.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return true;
    }

    private SalesforceConnection getConnection() throws HopException {
        String url = this.variables.resolve(this.wURL.getText());
        SalesforceConnection connection = new SalesforceConnection((ILogChannel)this.log, url, this.variables.resolve(this.wUserName.getText()), Utils.resolvePassword((IVariables)this.variables, (String)this.wPassword.getText()));
        int realTimeOut = Const.toInt((String)this.variables.resolve(this.wTimeOut.getText()), (int)0);
        connection.setTimeOut(realTimeOut);
        connection.connect();
        return connection;
    }

    private String[] getFieldNames() throws HopException {
        SalesforceConnection connection = null;
        String selectedModule = this.variables.resolve(this.wModule.getText());
        try {
            connection = this.getConnection();
            String[] stringArray = connection.getFields(selectedModule);
            return stringArray;
        }
        catch (Exception e) {
            throw new HopException("Error getting fields from module [" + selectedModule + "]!", (Throwable)e);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta sourceFields;
        if (!this.checkInput()) {
            return;
        }
        RowMeta targetFields = new RowMeta();
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        try {
            SalesforceConnection connection = this.getConnection();
            Field[] fields = connection.getObjectFields(this.variables.resolve(this.wModule.getText()));
            String[] fieldNames = connection.getFields(fields);
            FieldType dateType = FieldType.date;
            for (int i = 0; i < fields.length; ++i) {
                if (dateType.equals((Object)fields[i].getType())) {
                    targetFields.addValueMeta(ValueMetaFactory.createValueMeta((String)fieldNames[i], (int)3));
                    continue;
                }
                targetFields.addValueMeta((IValueMeta)new ValueMetaNone(fieldNames[i]));
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), e);
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            boolean goOn;
            Object message = "";
            if (missingSourceFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)292);
            boolean bl = goOn = (answer & 0x20) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void setModuleFieldCombo() {
        if (this.gotFields) {
            return;
        }
        this.gotFields = true;
        Display display = this.shell.getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                block7: {
                    for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                        ColumnInfo colInfo = this.tableFieldColumns.get(i);
                        colInfo.setComboValues(new String[0]);
                    }
                    if (this.wModule.isDisposed()) {
                        return;
                    }
                    String selectedModule = this.variables.resolve(this.wModule.getText());
                    if (!Utils.isEmpty((CharSequence)selectedModule)) {
                        try {
                            String[] fieldsName = this.getFieldNames();
                            if (fieldsName == null) break block7;
                            for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = this.tableFieldColumns.get(i);
                                colInfo.setComboValues(fieldsName);
                            }
                        }
                        catch (Exception e) {
                            for (int i = 0; i < this.tableFieldColumns.size(); ++i) {
                                ColumnInfo colInfo = this.tableFieldColumns.get(i);
                                colInfo.setComboValues(new String[0]);
                            }
                        }
                    }
                }
            });
        }
    }

    private void getModulesList() {
        if (!this.gotModule) {
            SalesforceConnection connection = null;
            try {
                String selectedField = this.wModule.getText();
                this.wModule.removeAll();
                connection = this.getConnection();
                this.wModule.setItems(connection.getAllAvailableObjects(false));
                if (!Utils.isEmpty((CharSequence)selectedField)) {
                    this.wModule.setText(selectedField);
                }
                this.gotModule = true;
                this.getModulesListError = false;
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ErrorRetrieveModules.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SalesforceInsertDialog.ErrorRetrieveData.ErrorRetrieveModules", (String[])new String[0]), e);
                this.getModulesListError = true;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

