/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.wrapper;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.MongoUtilLogger;
import org.apache.hop.mongo.Util;
import org.apache.hop.mongo.wrapper.KerberosInvocationHandler;
import org.apache.hop.mongo.wrapper.KerberosMongoClientWrapper;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.NoAuthMongoClientWrapper;
import org.apache.hop.mongo.wrapper.UsernamePasswordMongoClientWrapper;

public class MongoClientWrapperFactory {
    public static MongoClientWrapper createMongoClientWrapper(MongoProperties props, MongoUtilLogger log) throws MongoDbException {
        if (props.useKerberos()) {
            return MongoClientWrapperFactory.initKerberosProxy(new KerberosMongoClientWrapper(props, log));
        }
        if (!(Util.isEmpty(props.get(MongoProp.USERNAME)) && Util.isEmpty(props.get(MongoProp.PASSWORD)) && Util.isEmpty(props.get(MongoProp.AUTH_DATABASE)))) {
            return new UsernamePasswordMongoClientWrapper(props, log);
        }
        return new NoAuthMongoClientWrapper(props, log);
    }

    private static MongoClientWrapper initKerberosProxy(KerberosMongoClientWrapper wrapper) {
        return (MongoClientWrapper)Proxy.newProxyInstance(wrapper.getClass().getClassLoader(), new Class[]{MongoClientWrapper.class}, (InvocationHandler)new KerberosInvocationHandler(wrapper.getAuthContext(), wrapper));
    }
}

