/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.numberrange;

import java.util.LinkedList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.numberrange.NumberRange;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeData;
import org.apache.hop.pipeline.transforms.numberrange.NumberRangeRule;

@Transform(id="NumberRange", image="numberrange.svg", name="i18n::NumberRange.Name", description="i18n::NumberRange.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::NumberRange.Keyword"}, documentationUrl="/pipeline/transforms/numberrange.html")
public class NumberRangeMeta
extends BaseTransformMeta<NumberRange, NumberRangeData> {
    private static final Class<?> PKG = NumberRangeMeta.class;
    @HopMetadataProperty(key="inputField", injectionKey="INPUT_FIELD", injectionKeyDescription="NumberRangeMeta.Injection.INPUT_FIELD")
    private String inputField;
    @HopMetadataProperty(key="outputField", injectionKey="OUTPUT_FIELD", injectionKeyDescription="NumberRangeMeta.Injection.OUTPUT_FIELD")
    private String outputField;
    @HopMetadataProperty(key="fallBackValue", injectionKey="FALL_BACK_VALUE", injectionKeyDescription="NumberRangeMeta.Injection.FALL_BACK_VALUE")
    private String fallBackValue;
    @HopMetadataProperty(groupKey="rules", key="rule", injectionGroupKey="RULES", injectionGroupDescription="NumberRangeMeta.Injection.RULES")
    private List<NumberRangeRule> rules = new LinkedList<NumberRangeRule>();

    public void emptyRules() {
        this.rules = new LinkedList<NumberRangeRule>();
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        ValueMetaString mcValue = new ValueMetaString(this.outputField);
        mcValue.setOrigin(name);
        mcValue.setLength(255);
        row.addValueMeta((IValueMeta)mcValue);
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void setDefault() {
        this.emptyRules();
        this.setFallBackValue("unknown");
        this.addRule("", "5", "Less than 5");
        this.addRule("5", "10", "5-10");
        this.addRule("10", "", "More than 10");
        this.inputField = "";
        this.outputField = "range";
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transforminfo, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"NumberRangeMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NumberRangeMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"NumberRangeMeta.CheckResult.TransformReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NumberRangeMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transforminfo);
            remarks.add((ICheckResult)cr);
        }
        for (NumberRangeRule rule : this.rules) {
            try {
                if (!Utils.isEmpty((CharSequence)rule.getLowerBound())) {
                    Double.valueOf(rule.getLowerBound());
                }
                if (Utils.isEmpty((CharSequence)rule.getUpperBound())) continue;
                Double.valueOf(rule.getUpperBound());
            }
            catch (NumberFormatException e) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"NumberRangeMeta.CheckResult.NotNumericRule", (String[])new String[]{rule.getLowerBound(), rule.getUpperBound(), rule.getValue()}), (ICheckResultSource)transforminfo);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public String getInputField() {
        return this.inputField;
    }

    public String getOutputField() {
        return this.outputField;
    }

    public void setOutputField(String outputField) {
        this.outputField = outputField;
    }

    public List<NumberRangeRule> getRules() {
        return this.rules;
    }

    public String getFallBackValue() {
        return this.fallBackValue;
    }

    public void setInputField(String inputField) {
        this.inputField = inputField;
    }

    public void setFallBackValue(String fallBackValue) {
        this.fallBackValue = fallBackValue;
    }

    public NumberRangeRule addRule(String lowerBound, String upperBound, String value) {
        NumberRangeRule rule = new NumberRangeRule(lowerBound, upperBound, value);
        this.rules.add(rule);
        return rule;
    }

    public void setRules(List<NumberRangeRule> rules) {
        this.rules = rules;
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

