/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution.path.base;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.neo4j.execution.NeoExecutionInfoLocation;
import org.apache.hop.neo4j.perspective.HopNeo4jPerspective;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.apache.hop.ui.hopgui.shared.BaseExecutionViewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.neo4j.driver.Session;

public abstract class NeoExecutionViewerTabBase {
    public static final Class<?> PKG = HopNeo4jPerspective.class;
    protected final BaseExecutionViewer viewer;
    protected final PropsUi props;
    protected final ClassLoader classLoader;
    protected final int iconSize;

    public NeoExecutionViewerTabBase(BaseExecutionViewer viewer) {
        this.viewer = viewer;
        this.props = PropsUi.getInstance();
        this.classLoader = this.getClass().getClassLoader();
        this.iconSize = 16;
    }

    protected static ExecutionInfoLocation getExecutionInfoLocation(BaseExecutionViewer viewer) {
        String locationName = viewer.getLocationName();
        ExecutionPerspective perspective = viewer.getPerspective();
        return (ExecutionInfoLocation)perspective.getLocationMap().get(locationName);
    }

    protected String getActiveLogChannelId() {
        return this.viewer.getActiveId();
    }

    protected Session getSession() {
        ExecutionInfoLocation location = NeoExecutionViewerTabBase.getExecutionInfoLocation(this.viewer);
        return ((NeoExecutionInfoLocation)location.getExecutionInfoLocation()).getSession();
    }

    protected String getPathToRootCypher() {
        if (StringUtils.isEmpty((String)this.viewer.getExecution().getParentId())) {
            return "MATCH(e:Execution {id: $executionId }) " + Const.CR + "RETURN e " + Const.CR;
        }
        return "MATCH(top:Execution), (child:Execution {id: $executionId }), p=shortestPath((top)-[:EXECUTES*]-(child)) " + Const.CR + "WHERE top.parentId IS NULL " + Const.CR + "RETURN p " + Const.CR + "ORDER BY size(RELATIONSHIPS(p)) DESC " + Const.CR + "LIMIT 10 " + Const.CR;
    }

    protected String getPathToFailedCypher() {
        return "MATCH(top:Execution {id: $executionId }), (child:Execution), p=shortestPath((top)-[:EXECUTES*]-(child)) " + Const.CR + "WHERE child.failed " + Const.CR + "AND   size((child)-[:EXECUTES]->())=0 " + Const.CR + "RETURN p " + Const.CR + "ORDER BY size(RELATIONSHIPS(p)) " + Const.CR + "LIMIT 10 " + Const.CR;
    }

    public void openItem(Tree tree) {
        if (tree.getSelectionCount() <= 0) {
            return;
        }
        TreeItem treeItem = tree.getSelection()[0];
        String childId = null;
        String id = treeItem.getText(1);
        String name = treeItem.getText(2);
        String type = treeItem.getText(3);
        ExecutionInfoLocation location = NeoExecutionViewerTabBase.getExecutionInfoLocation(this.viewer);
        IExecutionInfoLocation iLocation = location.getExecutionInfoLocation();
        try {
            if (ExecutionType.Transform.name().equals(type)) {
                Execution transformExecution = iLocation.getExecution(id);
                childId = id;
                id = transformExecution.getParentId();
            } else if (ExecutionType.Action.name().equals(type)) {
                Execution actionExecution = iLocation.getExecution(id);
                childId = id;
                id = actionExecution.getParentId();
            }
            Execution execution = iLocation.getExecution(id);
            ExecutionState executionState = iLocation.getExecutionState(id);
            this.viewer.getPerspective().createExecutionViewer(location.getName(), execution, executionState);
        }
        catch (Exception e) {
            new ErrorDialog(this.viewer.getShell(), "Error", "Error opening lineage item", e);
        }
    }

    public BaseExecutionViewer getViewer() {
        return this.viewer;
    }

    public PropsUi getProps() {
        return this.props;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public int getIconSize() {
        return this.iconSize;
    }
}

