/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hop.neo4j.transforms.gencsv.IdType;

public class CsvFile {
    private String filename;
    private String shortFilename;
    private String fileType;
    private transient List<IdType> propsList = new ArrayList<IdType>();
    private transient Map<String, Integer> propsIndexes = new HashMap<String, Integer>();
    private transient FileOutputStream outputStream;
    private transient String idFieldName;

    public CsvFile() {
    }

    public CsvFile(String filename, String shortFilename, String fileType) {
        this();
        this.filename = filename;
        this.shortFilename = shortFilename;
        this.fileType = fileType;
    }

    public void openFile() throws FileNotFoundException {
        this.outputStream = new FileOutputStream(this.filename);
    }

    public void closeFile() throws IOException {
        if (this.outputStream != null) {
            this.outputStream.flush();
            this.outputStream.close();
        }
    }

    public FileOutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(FileOutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CsvFile csvFile = (CsvFile)o;
        return this.filename.equals(csvFile.filename);
    }

    public int hashCode() {
        return Objects.hash(this.filename);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getShortFilename() {
        return this.shortFilename;
    }

    public void setShortFilename(String shortFilename) {
        this.shortFilename = shortFilename;
    }

    public List<IdType> getPropsList() {
        return this.propsList;
    }

    public void setPropsList(List<IdType> propsList) {
        this.propsList = propsList;
    }

    public Map<String, Integer> getPropsIndexes() {
        return this.propsIndexes;
    }

    public void setPropsIndexes(Map<String, Integer> propsIndexes) {
        this.propsIndexes = propsIndexes;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }
}

