/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.gencsv;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogLevel;

public class StreamConsumer
extends Thread {
    private ILogChannel log;
    private InputStream inputStream;
    private final LogLevel logLevel;

    public StreamConsumer(ILogChannel log, InputStream inputStream, LogLevel logLevel) {
        this.log = log;
        this.inputStream = inputStream;
        this.logLevel = logLevel;
    }

    @Override
    public void run() {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this.inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                switch (this.logLevel) {
                    case MINIMAL: {
                        this.log.logMinimal(line);
                        break;
                    }
                    case BASIC: {
                        this.log.logBasic(line);
                        break;
                    }
                    case DETAILED: {
                        this.log.logDetailed(line);
                        break;
                    }
                    case DEBUG: {
                        this.log.logDebug(line);
                        break;
                    }
                    case ROWLEVEL: {
                        this.log.logRowlevel(line);
                        break;
                    }
                    case ERROR: {
                        if (line.contains("neo4j-import is deprecated") || line.contains("please use neo4j-admin import")) break;
                        this.log.logError(line);
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.logError("Error consuming thread:", (Throwable)e);
        }
    }
}

