/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.resource;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.resource.IResourceNaming;

public class SimpleResourceNaming
implements IResourceNaming {
    private final Map<String, String> namedResources = new HashMap<String, String>();
    private String fileSystemPrefix;
    private boolean useOriginalPathInTargetName;
    private Map<String, String> directoryMap;
    private int parameterNr;

    public SimpleResourceNaming() {
        this.directoryMap = new HashMap<String, String>();
        this.parameterNr = 0;
    }

    public SimpleResourceNaming(String fileSystemPrefix) {
        this.fileSystemPrefix = fileSystemPrefix;
    }

    @Override
    public String nameResource(FileObject fileObject, IVariables variables, boolean includeFileName) throws FileSystemException {
        if (includeFileName) {
            return this.handleDataFile(fileObject.getName().getBaseName(), fileObject.getParent().getURL().toString(), "");
        }
        return this.handleDataFile("", fileObject.getURL().toString(), "");
    }

    @Override
    public String nameResource(String prefix, String originalFilePath, String extension, IResourceNaming.FileNamingType namingType) {
        switch (namingType) {
            case DATA_FILE: {
                return this.handleDataFile(prefix, originalFilePath, extension);
            }
            case SHELL_SCRIPT: {
                return this.handleScript(prefix, originalFilePath, extension);
            }
            case PIPELINE: 
            case WORKFLOW: {
                return this.handlePipelineOrJob(prefix, originalFilePath, extension);
            }
        }
        throw new AssertionError((Object)("Unknown file naming type: " + String.valueOf((Object)namingType)));
    }

    private String handlePipelineOrJob(String prefix, String originalFilePath, String extension) {
        assert (prefix != null);
        assert (extension != null);
        String lookup = (originalFilePath != null ? originalFilePath : "") + "/" + prefix + "." + extension;
        Object rtn = this.namedResources.get(lookup);
        if (rtn == null) {
            String fixedPath = null;
            if (this.useOriginalPathInTargetName) {
                fixedPath = this.fixPath(originalFilePath);
            }
            rtn = (this.fileSystemPrefix != null ? this.fileSystemPrefix : "") + (String)(fixedPath != null ? fixedPath + (fixedPath.endsWith("/") ? "" : "/") : "") + this.fixFileName(prefix, extension);
            Object ext = extension.charAt(0) == '.' ? extension : "." + extension;
            String uniqueId = this.getFileNameUniqueIdentifier((String)rtn, extension);
            rtn = (String)rtn + (String)(uniqueId != null ? "_" + uniqueId : "");
            rtn = (String)rtn + (String)ext;
            this.namedResources.put(lookup, (String)rtn);
        }
        return rtn;
    }

    private String handleScript(String prefix, String originalFilePath, String extension) {
        return null;
    }

    private String handleDataFile(String prefix, String originalFilePath, String extension) {
        String parameter = this.directoryMap.get(originalFilePath);
        if (parameter == null) {
            parameter = this.createNewParameterName(originalFilePath);
            this.directoryMap.put(originalFilePath, parameter);
        }
        return "${" + parameter + "}/" + prefix;
    }

    private String createNewParameterName(String originalFilePath) {
        ++this.parameterNr;
        return "DATA_PATH_" + this.parameterNr;
    }

    protected String getFileNameUniqueIdentifier(String filename, String extension) {
        return null;
    }

    protected String fixPath(String originalPathName) {
        String rtn = originalPathName.substring(this.getPrefixLength(originalPathName));
        return rtn.replace('\\', '/');
    }

    private int getPrefixLength(String fileName) {
        if (fileName.charAt(1) == ':') {
            return 3;
        }
        if (fileName.charAt(0) == '\\' && fileName.charAt(1) == '\\') {
            int start = 0;
            int slashesFound = 0;
            for (int i = 2; i < fileName.length(); ++i) {
                if (fileName.charAt(i) == '\\') {
                    ++slashesFound;
                }
                if (slashesFound != 2) continue;
                start = i + 1;
                break;
            }
            return start;
        }
        if (fileName.charAt(0) == '/') {
            return 1;
        }
        return 0;
    }

    protected String fixFileName(String name, String extension) {
        int length = name.length();
        if (name.endsWith("." + extension)) {
            length -= 1 + extension.length();
        } else if (name.endsWith(extension)) {
            length -= extension.length();
        }
        StringBuilder buff = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch == ' ') {
                buff.append(ch);
                continue;
            }
            if (ch <= '/' || ch >= ':' && ch <= '?' || ch >= '[' && ch <= '`' || ch >= '{' && ch <= '~') {
                buff.append('_');
                continue;
            }
            buff.append(ch);
        }
        return buff.toString();
    }

    public String getFileSystemPrefix() {
        return this.fileSystemPrefix;
    }

    public void setFileSystemPrefix(String value) {
        this.fileSystemPrefix = value;
    }

    public boolean getUseOriginalPathInTargetName() {
        return this.useOriginalPathInTargetName;
    }

    public void setUseOriginalPathInTargetName(boolean value) {
        this.useOriginalPathInTargetName = value;
    }

    @Override
    public Map<String, String> getDirectoryMap() {
        return this.directoryMap;
    }

    public void setDirectoryMap(Map<String, String> directoryMap) {
        this.directoryMap = directoryMap;
    }
}

