/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;

@HopServerServlet(id="addWorkflow", name="Add a workflow to the server")
public class AddWorkflowServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/hop/addWorkflow";

    public AddWorkflowServlet() {
    }

    public AddWorkflowServlet(WorkflowMap workflowMap) {
        super(workflowMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of workflow requested");
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XmlHandler.getXmlHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add workflow</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        try {
            int c;
            StringBuilder xml = new StringBuilder();
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            WorkflowConfiguration workflowConfiguration = WorkflowConfiguration.fromXml(xml.toString(), this.variables);
            MultiMetadataProvider metadataProvider = new MultiMetadataProvider(this.variables, new IHopMetadataProvider[]{this.getServerConfig().getMetadataProvider(), workflowConfiguration.getMetadataProvider()});
            WorkflowMeta workflowMeta = workflowConfiguration.getWorkflowMeta();
            WorkflowExecutionConfiguration workflowExecutionConfiguration = workflowConfiguration.getWorkflowExecutionConfiguration();
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            servletLoggingObject.setLogLevel(workflowExecutionConfiguration.getLogLevel());
            String runConfigurationName = workflowExecutionConfiguration.getRunConfiguration();
            IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, this.variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, workflowMeta, (ILoggingObject)servletLoggingObject);
            workflow.initializeFrom(null);
            workflow.getWorkflowMeta().setInternalHopVariables(workflow);
            workflow.setVariables(workflowConfiguration.getWorkflowExecutionConfiguration().getVariablesMap());
            workflow.copyParametersFromDefinitions(workflowMeta);
            workflow.clearParameterValues();
            String[] parameterNames = workflow.listParameters();
            for (int idx = 0; idx < parameterNames.length; ++idx) {
                String thisValue = workflowExecutionConfiguration.getParametersMap().get(parameterNames[idx]);
                if (Utils.isEmpty((CharSequence)thisValue)) continue;
                workflow.setParameterValue(parameterNames[idx], thisValue);
            }
            workflow.activateParameters(workflow);
            String startActionName = workflowExecutionConfiguration.getStartActionName();
            if (startActionName != null && !startActionName.isEmpty()) {
                ActionMeta startActionMeta = workflowMeta.findAction(startActionName);
                workflow.setStartActionMeta(startActionMeta);
            }
            this.getWorkflowMap().addWorkflow(workflow.getWorkflowName(), serverObjectId, workflow, workflowConfiguration);
            String message = "Workflow '" + workflow.getWorkflowName() + "' was added to the list with id " + serverObjectId;
            if (useXML) {
                out.println(new WebResult("OK", message, serverObjectId));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"" + this.convertContextPath("/hop/workflowStatus") + "?name=" + workflow.getWorkflowName() + "&id=" + serverObjectId + "\">Go to the workflow status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    protected String[] getAllArgumentStrings(Map<String, String> arguments) {
        if (arguments == null || arguments.size() == 0) {
            return null;
        }
        Object[] argNames = arguments.keySet().toArray(new String[arguments.size()]);
        Arrays.sort(argNames);
        String[] values = new String[argNames.length];
        for (int i = 0; i < argNames.length; ++i) {
            values[i] = arguments.get(argNames[i]);
        }
        return values;
    }

    public String toString() {
        return "Add Workflow";
    }

    @Override
    public String getService() {
        return "/hop/addWorkflow (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

