/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.jaxrs;

import java.util.UUID;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.www.HopServerObjectEntry;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.jaxrs.HopServerResource;
import org.apache.hop.www.jaxrs.PipelineStatus;

@Path(value="/carte/pipeline")
public class PipelineResource {
    @GET
    @Path(value="/log/{id : .+}")
    @Produces(value={"text/plain"})
    public String getPipelineLog(@PathParam(value="id") String id) {
        return this.getPipelineLog(id, 0);
    }

    @GET
    @Path(value="/log/{id : .+}/{logStart : .+}")
    @Produces(value={"text/plain"})
    public String getPipelineLog(@PathParam(value="id") String id, @PathParam(value="logStart") int startLineNr) {
        int lastLineNr = HopLogStore.getLastBufferLineNr();
        IPipelineEngine<PipelineMeta> pipeline = HopServerResource.getPipeline(id);
        return HopLogStore.getAppender().getBuffer(pipeline.getLogChannel().getLogChannelId(), false, startLineNr, lastLineNr).toString();
    }

    @GET
    @Path(value="/status/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus getPipelineStatus(@PathParam(value="id") String id) {
        PipelineStatus status = new PipelineStatus();
        IPipelineEngine<PipelineMeta> pipeline = HopServerResource.getPipeline(id);
        HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
        status.setId(entry.getId());
        status.setName(entry.getName());
        status.setStatus(pipeline.getStatusDescription());
        for (IEngineComponent component : pipeline.getComponents()) {
            if (!component.isRunning() && component.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_EMPTY) continue;
            TransformStatus transformStatus = new TransformStatus(component);
            status.addTransformStatus(transformStatus);
        }
        return status;
    }

    @GET
    @Path(value="/start/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus startPipeline(@PathParam(value="id") String id) {
        IPipelineEngine<PipelineMeta> pipeline = HopServerResource.getPipeline(id);
        try {
            HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)true);
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            servletLoggingObject.setLogLevel(pipeline.getLogLevel());
            pipeline.setParent((ILoggingObject)servletLoggingObject);
            pipeline.execute();
        }
        catch (HopException e) {
            e.printStackTrace();
        }
        return this.getPipelineStatus(id);
    }

    @GET
    @Path(value="/prepare/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus preparePipeline(@PathParam(value="id") String id) {
        IPipelineEngine<PipelineMeta> pipeline = HopServerResource.getPipeline(id);
        try {
            HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
            PipelineConfiguration pipelineConfiguration = HopServerSingleton.getInstance().getPipelineMap().getConfiguration(entry);
            PipelineExecutionConfiguration executionConfiguration = pipelineConfiguration.getPipelineExecutionConfiguration();
            pipeline.setVariables(executionConfiguration.getVariablesMap());
            pipeline.setPreviousResult(executionConfiguration.getPreviousResult());
            pipeline.prepareExecution();
        }
        catch (HopException e) {
            e.printStackTrace();
        }
        return this.getPipelineStatus(id);
    }

    @GET
    @Path(value="/pause/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus pausePipeline(@PathParam(value="id") String id) {
        HopServerResource.getPipeline(id).pauseExecution();
        return this.getPipelineStatus(id);
    }

    @GET
    @Path(value="/resume/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus resumePipeline(@PathParam(value="id") String id) {
        HopServerResource.getPipeline(id).resumeExecution();
        return this.getPipelineStatus(id);
    }

    @GET
    @Path(value="/stop/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus stopPipeline(@PathParam(value="id") String id) {
        HopServerResource.getPipeline(id).stopAll();
        return this.getPipelineStatus(id);
    }

    @GET
    @Path(value="/remove/{id : .+}")
    public Response removePipeline(@PathParam(value="id") String id) {
        IPipelineEngine<PipelineMeta> pipeline = HopServerResource.getPipeline(id);
        HopServerObjectEntry entry = HopServerResource.getHopServerObjectEntry(id);
        HopLogStore.discardLines((String)pipeline.getLogChannelId(), (boolean)true);
        HopServerSingleton.getInstance().getPipelineMap().removePipeline(entry);
        return Response.ok().build();
    }

    @GET
    @Path(value="/cleanup/{id : .+}")
    @Produces(value={"application/json"})
    public PipelineStatus cleanupPipeline(@PathParam(value="id") String id) {
        HopServerResource.getPipeline(id).cleanup();
        return this.getPipelineStatus(id);
    }

    @PUT
    @Path(value="/add")
    @Produces(value={"application/json"})
    public PipelineStatus addPipeline(String xml) {
        try {
            PipelineConfiguration pipelineConfiguration = PipelineConfiguration.fromXml(xml);
            MultiMetadataProvider metadataProvider = new MultiMetadataProvider(HopServerSingleton.getHopServer().getVariables(), new IHopMetadataProvider[]{HopServerSingleton.getHopServer().getConfig().getMetadataProvider(), pipelineConfiguration.getMetadataProvider()});
            PipelineMeta pipelineMeta = pipelineConfiguration.getPipelineMeta();
            ILogChannel log = HopServerSingleton.getInstance().getLog();
            if (log.isDetailed()) {
                log.logDetailed("Logging level set to " + log.getLogLevel().getDescription());
            }
            PipelineExecutionConfiguration executionConfiguration = pipelineConfiguration.getPipelineExecutionConfiguration();
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(this.getClass().getName(), LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
            String runConfigurationName = executionConfiguration.getRunConfiguration();
            IVariables variables = Variables.getADefaultVariableSpace();
            IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(variables, variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, pipelineMeta);
            pipeline.setParent((ILoggingObject)servletLoggingObject);
            HopServerSingleton.getInstance().getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
            pipeline.setContainerId(serverObjectId);
            return this.getPipelineStatus(serverObjectId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

