/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.apache.hc.client5.http.impl;

import com.clickhouse.client.internal.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import com.clickhouse.client.internal.apache.hc.client5.http.config.RequestConfig;
import com.clickhouse.client.internal.apache.hc.client5.http.protocol.HttpClientContext;
import com.clickhouse.client.internal.apache.hc.core5.annotation.Contract;
import com.clickhouse.client.internal.apache.hc.core5.annotation.ThreadingBehavior;
import com.clickhouse.client.internal.apache.hc.core5.http.HeaderElement;
import com.clickhouse.client.internal.apache.hc.core5.http.HttpResponse;
import com.clickhouse.client.internal.apache.hc.core5.http.message.MessageSupport;
import com.clickhouse.client.internal.apache.hc.core5.http.protocol.HttpContext;
import com.clickhouse.client.internal.apache.hc.core5.util.Args;
import com.clickhouse.client.internal.apache.hc.core5.util.TimeValue;
import java.util.Iterator;

@Contract(threading=ThreadingBehavior.STATELESS)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public TimeValue getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        Iterator<HeaderElement> it = MessageSupport.iterate(response, "keep-alive");
        while (it.hasNext()) {
            HeaderElement he = it.next();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return TimeValue.ofSeconds(Long.parseLong(value));
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        return requestConfig.getConnectionKeepAlive();
    }
}

