/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execprocess;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcess;
import org.apache.hop.pipeline.transforms.execprocess.ExecProcessData;

@Transform(id="ExecProcess", image="execprocess.svg", name="i18n::ExecProcess.Name", description="i18n::ExecProcess.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::ExecProcessMeta.keyword"}, documentationUrl="/pipeline/transforms/execprocess.html")
public class ExecProcessMeta
extends BaseTransformMeta<ExecProcess, ExecProcessData> {
    private static final Class<?> PKG = ExecProcessMeta.class;
    @HopMetadataProperty(key="processfield")
    private String processField;
    @HopMetadataProperty(key="resultfieldname")
    private String resultFieldName;
    @HopMetadataProperty(key="errorfieldname")
    private String errorFieldName;
    @HopMetadataProperty(key="exitvaluefieldname")
    private String exitValueFieldName;
    @HopMetadataProperty(key="failwhennotsuccess")
    private boolean failWhenNotSuccess;
    @HopMetadataProperty(key="outputlinedelimiter")
    public String outputLineDelimiter = "";
    @HopMetadataProperty(key="argumentsInFields")
    private boolean argumentsInFields;
    @HopMetadataProperty(groupKey="argumentFields", key="argumentField")
    private List<EPField> argumentFields = new ArrayList<EPField>();

    public ExecProcessMeta() {
    }

    public ExecProcessMeta(ExecProcessMeta m) {
        this();
        this.processField = m.processField;
        this.resultFieldName = m.resultFieldName;
        this.errorFieldName = m.errorFieldName;
        this.exitValueFieldName = m.exitValueFieldName;
        this.failWhenNotSuccess = m.failWhenNotSuccess;
        this.outputLineDelimiter = m.outputLineDelimiter;
        this.argumentsInFields = m.argumentsInFields;
        m.argumentFields.forEach(f -> this.argumentFields.add(new EPField((EPField)f)));
    }

    public ExecProcessMeta clone() {
        return new ExecProcessMeta(this);
    }

    public void setDefault() {
        this.resultFieldName = "Result output";
        this.errorFieldName = "Error output";
        this.exitValueFieldName = "Exit value";
        this.failWhenNotSuccess = false;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        String realExitValueFieldName;
        String realErrorFieldName;
        String realOutputFieldName = variables.resolve(this.resultFieldName);
        if (!Utils.isEmpty((CharSequence)realOutputFieldName)) {
            ValueMetaString v = new ValueMetaString(realOutputFieldName);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realErrorFieldName = variables.resolve(this.errorFieldName)))) {
            ValueMetaString v = new ValueMetaString(realErrorFieldName);
            v.setLength(100, -1);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realExitValueFieldName = variables.resolve(this.exitValueFieldName)))) {
            ValueMetaInteger v = new ValueMetaInteger(realExitValueFieldName);
            v.setLength(10, 0);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (Utils.isEmpty((CharSequence)this.resultFieldName)) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ResultFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (Utils.isEmpty((CharSequence)this.processField)) {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldMissing", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ProcessFieldOK", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
        if (input.length > 0) {
            remarks.add((ICheckResult)new CheckResult(1, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta));
        } else {
            remarks.add((ICheckResult)new CheckResult(4, BaseMessages.getString(PKG, (String)"ExecProcessMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta));
        }
    }

    public boolean supportsErrorHandling() {
        return this.failWhenNotSuccess;
    }

    public void setOutputLineDelimiter(String value) {
        this.outputLineDelimiter = value;
    }

    public String getOutputLineDelimiter() {
        return this.outputLineDelimiter;
    }

    public boolean isArgumentsInFields() {
        return this.argumentsInFields;
    }

    public void setArgumentsInFields(boolean argumentsInFields) {
        this.argumentsInFields = argumentsInFields;
    }

    public List<EPField> getArgumentFields() {
        return this.argumentFields;
    }

    public void setArgumentFields(List<EPField> argumentFields) {
        this.argumentFields = argumentFields;
    }

    public String getProcessField() {
        return this.processField;
    }

    public void setProcessField(String processField) {
        this.processField = processField;
    }

    public String getResultFieldName() {
        return this.resultFieldName;
    }

    public void setResultFieldName(String errorFieldName) {
        this.resultFieldName = errorFieldName;
    }

    public String getErrorFieldName() {
        return this.errorFieldName;
    }

    public void setErrorFieldName(String errorFieldName) {
        this.errorFieldName = errorFieldName;
    }

    public String getExitValueFieldName() {
        return this.exitValueFieldName;
    }

    public void setExitValueFieldName(String exitValueFieldName) {
        this.exitValueFieldName = exitValueFieldName;
    }

    public boolean isFailWhenNotSuccess() {
        return this.failWhenNotSuccess;
    }

    public void setFailWhenNotSuccess(boolean failWhenNotSuccess) {
        this.failWhenNotSuccess = failWhenNotSuccess;
    }

    public static final class EPField {
        @HopMetadataProperty(key="argumentFieldName")
        private String name;

        public EPField() {
        }

        public EPField(EPField f) {
            this.name = f.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

