/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KvCoder<@UnknownKeyFor K, @UnknownKeyFor V>
extends StructuredCoder<KV<K, V>> {
    private final @UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder;
    private final @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KvCoder<K, V> of(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        return new KvCoder<K, V>(keyCoder, valueCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<K> getKeyCoder() {
        return this.keyCoder;
    }

    public @UnknownKeyFor @NonNull @Initialized Coder<V> getValueCoder() {
        return this.valueCoder;
    }

    private KvCoder(@UnknownKeyFor @NonNull @Initialized Coder<K> keyCoder, @UnknownKeyFor @NonNull @Initialized Coder<V> valueCoder) {
        this.keyCoder = keyCoder;
        this.valueCoder = valueCoder;
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized KV<K, V> kv, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        this.encode(kv, outStream, Coder.Context.NESTED);
    }

    @Override
    public void encode(@UnknownKeyFor @NonNull @Initialized KV<K, V> kv, @UnknownKeyFor @NonNull @Initialized OutputStream outStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        this.keyCoder.encode(kv.getKey(), outStream);
        this.valueCoder.encode(kv.getValue(), outStream, context);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized KV<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        return this.decode(inStream, Coder.Context.NESTED);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized KV<K, V> decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream, @UnknownKeyFor @NonNull @Initialized Coder.Context context) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized CoderException {
        K key = this.keyCoder.decode(inStream);
        V value = this.valueCoder.decode(inStream, context);
        return KV.of(key, value);
    }

    @Override
    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getCoderArguments() {
        return Arrays.asList(this.keyCoder, this.valueCoder);
    }

    @Override
    public void verifyDeterministic() throws @UnknownKeyFor @NonNull @Initialized Coder.NonDeterministicException {
        KvCoder.verifyDeterministic(this, "Key coder must be deterministic", this.getKeyCoder());
        KvCoder.verifyDeterministic(this, "Value coder must be deterministic", this.getValueCoder());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean consistentWithEquals() {
        return this.keyCoder.consistentWithEquals() && this.valueCoder.consistentWithEquals();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Object structuralValue(@UnknownKeyFor @NonNull @Initialized KV<K, V> kv) {
        if (this.consistentWithEquals()) {
            return kv;
        }
        return KV.of(this.getKeyCoder().structuralValue(kv.getKey()), this.getValueCoder().structuralValue(kv.getValue()));
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean isRegisterByteSizeObserverCheap(@UnknownKeyFor @NonNull @Initialized KV<K, V> kv) {
        return this.keyCoder.isRegisterByteSizeObserverCheap(kv.getKey()) && this.valueCoder.isRegisterByteSizeObserverCheap(kv.getValue());
    }

    @Override
    public void registerByteSizeObserver(@UnknownKeyFor @NonNull @Initialized KV<K, V> kv, @UnknownKeyFor @NonNull @Initialized ElementByteSizeObserver observer) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (kv == null) {
            throw new CoderException("cannot encode a null KV");
        }
        this.keyCoder.registerByteSizeObserver(kv.getKey(), observer);
        this.valueCoder.registerByteSizeObserver(kv.getValue(), observer);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @NonNull @Initialized KV<K, V>> getEncodedTypeDescriptor() {
        return new TypeDescriptor<KV<K, V>>(){}.where(new TypeParameter<K>(){}, this.keyCoder.getEncodedTypeDescriptor()).where(new TypeParameter<V>(){}, this.valueCoder.getEncodedTypeDescriptor());
    }
}

