/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.testing;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.metrics.MetricNameFilter;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.metrics.MetricsFilter;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.testing.Annotations;
import org.apache.beam.sdk.testing.CrashingRunner;
import org.apache.beam.sdk.testing.NeedsRunner;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.testing.ValidatesRunner;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestPipeline
extends Pipeline
implements TestRule {
    private final @UnknownKeyFor @NonNull @Initialized PipelineOptions options;
    public static final @UnknownKeyFor @NonNull @Initialized String PROPERTY_BEAM_TEST_PIPELINE_OPTIONS = "beamTestPipelineOptions";
    static final @UnknownKeyFor @NonNull @Initialized String PROPERTY_USE_DEFAULT_DUMMY_RUNNER = "beamUseDummyRunner";
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper MAPPER = new ObjectMapper().registerModules((Iterable)ObjectMapper.findModules((ClassLoader)ReflectHelpers.findClassLoader()));
    private @UnknownKeyFor @NonNull @Initialized Optional<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineRunEnforcement> enforcement = Optional.absent();
    private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> providerRuntimeValues = Maps.newHashMap();

    public static @UnknownKeyFor @NonNull @Initialized TestPipeline create() {
        return TestPipeline.fromOptions(TestPipeline.testingPipelineOptions());
    }

    public static @UnknownKeyFor @NonNull @Initialized TestPipeline fromOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        return new TestPipeline(options);
    }

    private TestPipeline(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        super(options);
        this.options = options;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PipelineOptions getOptions() {
        return this.options;
    }

    public @UnknownKeyFor @NonNull @Initialized Statement apply(final @UnknownKeyFor @NonNull @Initialized Statement statement, final @UnknownKeyFor @NonNull @Initialized Description description) {
        return new Statement(){

            private void setDeducedEnforcementLevel() {
                if (!TestPipeline.this.enforcement.isPresent()) {
                    boolean annotatedWithNeedsRunner = FluentIterable.from((Iterable)description.getAnnotations()).filter(Annotations.Predicates.isAnnotationOfType(Category.class)).anyMatch(Annotations.Predicates.isCategoryOf(NeedsRunner.class, true));
                    boolean crashingRunner = CrashingRunner.class.isAssignableFrom(TestPipeline.this.options.getRunner());
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!annotatedWithNeedsRunner || !crashingRunner ? 1 : 0) != 0, (String)"The test was annotated with a [@%s] / [@%s] while the runner was set to [%s]. Please re-check your configuration.", (Object)NeedsRunner.class.getSimpleName(), (Object)ValidatesRunner.class.getSimpleName(), (Object)CrashingRunner.class.getSimpleName());
                    TestPipeline.this.enableAbandonedNodeEnforcement(annotatedWithNeedsRunner || !crashingRunner);
                }
            }

            public void evaluate() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                TestPipeline.this.options.as(ApplicationNameOptions.class).setAppName(TestPipeline.this.getAppName(description));
                this.setDeducedEnforcementLevel();
                statement.evaluate();
                ((PipelineRunEnforcement)TestPipeline.this.enforcement.get()).afterUserCodeFinished();
            }
        };
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PipelineResult run() {
        return this.run(this.getOptions());
    }

    public @UnknownKeyFor @NonNull @Initialized PipelineResult runWithAdditionalOptionArgs(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> additionalArgs) {
        try {
            String useDefaultDummy;
            String beamTestPipelineOptions = System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS, "");
            ArrayList<String> args = new ArrayList<String>();
            if (!beamTestPipelineOptions.isEmpty()) {
                args.addAll((Collection)MAPPER.readValue(beamTestPipelineOptions, List.class));
            }
            args.addAll(additionalArgs);
            String[] newArgs = (String[])Iterables.toArray(args, String.class);
            TestPipelineOptions newOptions = PipelineOptionsFactory.fromArgs(newArgs).as(TestPipelineOptions.class);
            if (beamTestPipelineOptions.isEmpty() && !Strings.isNullOrEmpty((String)(useDefaultDummy = System.getProperty(PROPERTY_USE_DEFAULT_DUMMY_RUNNER))) && Boolean.valueOf(useDefaultDummy).booleanValue()) {
                newOptions.setRunner(CrashingRunner.class);
            }
            newOptions.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            FileSystems.registerFileSystemsOnce(this.options);
            return this.run(newOptions);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate test options from system property beamTestPipelineOptions:" + System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS), e);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PipelineResult run(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        PipelineResult pipelineResult;
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.enforcement.isPresent(), (Object)"Is your TestPipeline declaration missing a @Rule annotation? Usage: @Rule public final transient TestPipeline pipeline = TestPipeline.create();");
        try {
            ((PipelineRunEnforcement)this.enforcement.get()).beforePipelineExecution();
            PipelineOptions updatedOptions = (PipelineOptions)MAPPER.convertValue((Object)MAPPER.valueToTree((Object)options), PipelineOptions.class);
            updatedOptions.as(TestValueProviderOptions.class).setProviderRuntimeValues(ValueProvider.StaticValueProvider.of(this.providerRuntimeValues));
            pipelineResult = super.run(updatedOptions);
            TestPipeline.verifyPAssertsSucceeded(this, pipelineResult);
        }
        catch (RuntimeException exc) {
            Throwable cause = exc.getCause();
            if (cause instanceof AssertionError) {
                throw (AssertionError)((Object)cause);
            }
            throw exc;
        }
        ((PipelineRunEnforcement)this.enforcement.get()).afterPipelineExecution();
        return pipelineResult;
    }

    public <T> @UnknownKeyFor @NonNull @Initialized ValueProvider<T> newProvider(T runtimeValue) {
        String uuid = UUID.randomUUID().toString();
        if (runtimeValue != null) {
            this.providerRuntimeValues.put(uuid, runtimeValue);
        }
        return ValueProvider.NestedValueProvider.of(this.options.as(TestValueProviderOptions.class).getProviderRuntimeValues(), new GetFromRuntimeValues(uuid));
    }

    public @UnknownKeyFor @NonNull @Initialized TestPipeline enableAbandonedNodeEnforcement(@UnknownKeyFor @NonNull @Initialized boolean enable) {
        this.enforcement = enable ? Optional.of((Object)new PipelineAbandonedNodeEnforcement(this)) : Optional.of((Object)new PipelineRunEnforcement(this));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized TestPipeline enableAutoRunIfMissing(@UnknownKeyFor @NonNull @Initialized boolean enable) {
        ((PipelineRunEnforcement)this.enforcement.get()).enableAutoRunIfMissing(enable);
        return this;
    }

    @Override
    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "TestPipeline#" + this.options.as(ApplicationNameOptions.class).getAppName();
    }

    public static @UnknownKeyFor @NonNull @Initialized PipelineOptions testingPipelineOptions() {
        try {
            String useDefaultDummy;
            PipelineOptions options;
            String beamTestPipelineOptions = System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS, "");
            PipelineOptions pipelineOptions = options = beamTestPipelineOptions.isEmpty() ? PipelineOptionsFactory.create() : PipelineOptionsFactory.fromArgs((String[])MAPPER.readValue(beamTestPipelineOptions, String[].class)).as(TestPipelineOptions.class);
            if (beamTestPipelineOptions.isEmpty() && !Strings.isNullOrEmpty((String)(useDefaultDummy = System.getProperty(PROPERTY_USE_DEFAULT_DUMMY_RUNNER))) && Boolean.valueOf(useDefaultDummy).booleanValue()) {
                options.setRunner(CrashingRunner.class);
            }
            options.setStableUniqueNames(PipelineOptions.CheckEnabled.ERROR);
            FileSystems.registerFileSystemsOnce(options);
            return options;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to instantiate test options from system property beamTestPipelineOptions:" + System.getProperty(PROPERTY_BEAM_TEST_PIPELINE_OPTIONS), e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized String getAppName(@UnknownKeyFor @NonNull @Initialized Description description) {
        String methodName = description.getMethodName();
        Class testClass = description.getTestClass();
        @Nullable Class<?> enclosingClass = testClass.getEnclosingClass();
        if (enclosingClass != null) {
            return String.format("%s$%s-%s", enclosingClass.getSimpleName(), testClass.getSimpleName(), methodName);
        }
        return String.format("%s-%s", testClass.getSimpleName(), methodName);
    }

    public static void verifyPAssertsSucceeded(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline, @UnknownKeyFor @NonNull @Initialized PipelineResult pipelineResult) {
        if (MetricsEnvironment.isMetricsSupported()) {
            long expectedNumberOfAssertions = PAssert.countAsserts(pipeline);
            long successfulAssertions = 0L;
            Iterable<MetricResult<Long>> successCounterResults = pipelineResult.metrics().queryMetrics(MetricsFilter.builder().addNameFilter(MetricNameFilter.named(PAssert.class, "PAssertSuccess")).build()).getCounters();
            for (MetricResult<Long> counter : successCounterResults) {
                if (counter.getAttempted() <= 0L) continue;
                ++successfulAssertions;
            }
            MatcherAssert.assertThat((String)String.format("Expected %d successful assertions, but found %d.", expectedNumberOfAssertions, successfulAssertions), (Object)successfulAssertions, (Matcher)Matchers.is((Object)expectedNumberOfAssertions));
        }
    }

    private static class IsEmptyVisitor
    extends Pipeline.PipelineVisitor.Defaults {
        private @UnknownKeyFor @NonNull @Initialized boolean empty = true;

        private IsEmptyVisitor() {
        }

        public @UnknownKeyFor @NonNull @Initialized boolean isEmpty() {
            return this.empty;
        }

        @Override
        public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
            this.empty = false;
        }
    }

    private static class GetFromRuntimeValues<@UnknownKeyFor T>
    implements SerializableFunction<Map<String, Object>, T> {
        private final @UnknownKeyFor @NonNull @Initialized String key;

        private GetFromRuntimeValues(@UnknownKeyFor @NonNull @Initialized String key) {
            this.key = key;
        }

        @Override
        public T apply(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> input) {
            return (T)input.get(this.key);
        }
    }

    @Internal
    public static interface TestValueProviderOptions
    extends PipelineOptions {
        public @UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> getProviderRuntimeValues();

        public void setProviderRuntimeValues(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> var1);
    }

    public static class PipelineRunMissingException
    extends RuntimeException {
        PipelineRunMissingException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }
    }

    public static class AbandonedNodeException
    extends RuntimeException {
        AbandonedNodeException(@UnknownKeyFor @NonNull @Initialized String msg) {
            super(msg);
        }
    }

    private static class PipelineAbandonedNodeEnforcement
    extends PipelineRunEnforcement {
        private @MonotonicNonNull @UnknownKeyFor @Initialized List< @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> runVisitedNodes = null;
        private final @UnknownKeyFor @NonNull @Initialized Predicate< @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> isPAssertNode = node -> node.getTransform() instanceof PAssert.GroupThenAssert || node.getTransform() instanceof PAssert.GroupThenAssertForSingleton || node.getTransform() instanceof PAssert.OneSideInputAssert;

        private PipelineAbandonedNodeEnforcement(@UnknownKeyFor @NonNull @Initialized TestPipeline pipeline) {
            super(pipeline);
        }

        private @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> recordPipelineNodes(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            NodeRecorder nodeRecorder = new NodeRecorder();
            pipeline.traverseTopologically(nodeRecorder);
            return nodeRecorder.visited;
        }

        private @UnknownKeyFor @NonNull @Initialized boolean isEmptyPipeline(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            IsEmptyVisitor isEmptyVisitor = new IsEmptyVisitor();
            pipeline.traverseTopologically(isEmptyVisitor);
            return isEmptyVisitor.isEmpty();
        }

        private void verifyPipelineExecution() {
            List<TransformHierarchy.Node> pipelineNodes;
            if (this.isEmptyPipeline(this.pipeline)) {
                return;
            }
            if (!this.runAttempted && !this.enableAutoRunIfMissing) {
                throw new PipelineRunMissingException("The pipeline has not been run.");
            }
            if (!this.pipelineRunSucceeded()) {
                return;
            }
            List<TransformHierarchy.Node> runVisitedNodes = Preconditions.checkStateNotNull(this.runVisitedNodes, "Internal error: non-empty pipeline has been visited but still no runVisitedNodes");
            if (runVisitedNodes.equals(pipelineNodes = this.recordPipelineNodes(this.pipeline))) {
                return;
            }
            boolean hasDanglingPAssert = pipelineNodes.stream().filter(Predicates.not((Predicate)Predicates.in(runVisitedNodes))).anyMatch(this.isPAssertNode);
            if (hasDanglingPAssert) {
                throw new AbandonedNodeException("The pipeline contains abandoned PAssert(s).");
            }
            throw new AbandonedNodeException("The pipeline contains abandoned PTransform(s).");
        }

        private @UnknownKeyFor @NonNull @Initialized boolean pipelineRunSucceeded() {
            return this.runVisitedNodes != null;
        }

        @Override
        protected void afterPipelineExecution() {
            this.runVisitedNodes = this.recordPipelineNodes(this.pipeline);
            super.afterPipelineExecution();
        }

        @Override
        protected void afterUserCodeFinished() {
            super.afterUserCodeFinished();
            this.verifyPipelineExecution();
        }

        private static class NodeRecorder
        extends Pipeline.PipelineVisitor.Defaults {
            private final @UnknownKeyFor @NonNull @Initialized List< @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node> visited = new ArrayList<TransformHierarchy.Node>();

            private NodeRecorder() {
            }

            @Override
            public void leaveCompositeTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.visited.add(node);
            }

            @Override
            public void visitPrimitiveTransform( @UnknownKeyFor @NonNull @Initialized TransformHierarchy. @UnknownKeyFor @NonNull @Initialized Node node) {
                this.visited.add(node);
            }
        }
    }

    private static class PipelineRunEnforcement {
        protected @UnknownKeyFor @NonNull @Initialized boolean enableAutoRunIfMissing;
        protected final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;
        protected @UnknownKeyFor @NonNull @Initialized boolean runAttempted;

        private PipelineRunEnforcement(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
            this.pipeline = pipeline;
        }

        protected void enableAutoRunIfMissing(@UnknownKeyFor @NonNull @Initialized boolean enable) {
            this.enableAutoRunIfMissing = enable;
        }

        protected void beforePipelineExecution() {
            this.runAttempted = true;
        }

        protected void afterPipelineExecution() {
        }

        protected void afterUserCodeFinished() {
            if (!this.runAttempted && this.enableAutoRunIfMissing) {
                this.pipeline.run().waitUntilFinish();
            }
        }
    }
}

