/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.crypto.digest;

import com.trilead.ssh2.crypto.digest.MAC;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public final class HMAC
implements MAC {
    private static final String ETM_SUFFIX = "-etm@openssh.com";
    static final String HMAC_MD5 = "hmac-md5";
    static final String HMAC_MD5_96 = "hmac-md5-96";
    static final String HMAC_SHA1 = "hmac-sha1";
    static final String HMAC_SHA1_ETM = "hmac-sha1-etm@openssh.com";
    static final String HMAC_SHA1_96 = "hmac-sha1-96";
    static final String HMAC_SHA2_256_ETM = "hmac-sha2-256-etm@openssh.com";
    static final String HMAC_SHA2_512_ETM = "hmac-sha2-512-etm@openssh.com";
    static final String HMAC_SHA2_256 = "hmac-sha2-256";
    static final String HMAC_SHA2_512 = "hmac-sha2-512";
    private final Mac mac;
    private final int outSize;
    private final boolean encryptThenMac;
    private final byte[] buffer;

    public HMAC(String type, byte[] key) {
        block13: {
            try {
                if (HMAC_SHA1.equals(type) || HMAC_SHA1_96.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA1");
                    this.encryptThenMac = false;
                    break block13;
                }
                if (HMAC_SHA1_ETM.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA1");
                    this.encryptThenMac = true;
                    break block13;
                }
                if (HMAC_MD5.equals(type) || HMAC_MD5_96.equals(type)) {
                    this.mac = Mac.getInstance("HmacMD5");
                    this.encryptThenMac = false;
                    break block13;
                }
                if (HMAC_SHA2_256.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA256");
                    this.encryptThenMac = false;
                    break block13;
                }
                if (HMAC_SHA2_256_ETM.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA256");
                    this.encryptThenMac = true;
                    break block13;
                }
                if (HMAC_SHA2_512.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA512");
                    this.encryptThenMac = false;
                    break block13;
                }
                if (HMAC_SHA2_512_ETM.equals(type)) {
                    this.mac = Mac.getInstance("HmacSHA512");
                    this.encryptThenMac = true;
                    break block13;
                }
                throw new IllegalArgumentException("Unknown algorithm " + type);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Unknown algorithm " + type, e);
            }
        }
        int macSize = this.mac.getMacLength();
        if (type.endsWith("-96")) {
            this.outSize = 12;
            this.buffer = new byte[macSize];
        } else {
            this.outSize = macSize;
            this.buffer = null;
        }
        try {
            this.mac.init(new SecretKeySpec(key, type));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public final void initMac(int seq) {
        this.mac.reset();
        this.mac.update((byte)(seq >> 24));
        this.mac.update((byte)(seq >> 16));
        this.mac.update((byte)(seq >> 8));
        this.mac.update((byte)seq);
    }

    @Override
    public final void update(byte[] packetdata, int off, int len) {
        this.mac.update(packetdata, off, len);
    }

    @Override
    public final void getMac(byte[] out, int off) {
        try {
            if (this.buffer != null) {
                this.mac.doFinal(this.buffer, 0);
                System.arraycopy(this.buffer, 0, out, off, out.length - off);
            } else {
                this.mac.doFinal(out, off);
            }
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final int size() {
        return this.outSize;
    }

    @Override
    public boolean isEncryptThenMac() {
        return this.encryptThenMac;
    }
}

