/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.codec.DecodeMonitor;
import org.apache.james.mime4j.codec.DecoderUtil;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.AddressListField;
import org.apache.james.mime4j.dom.field.MailboxListField;
import org.apache.james.mime4j.dom.field.ParsedField;
import org.apache.james.mime4j.dom.field.UnstructuredField;
import org.apache.james.mime4j.field.LenientFieldParser;
import org.apache.james.mime4j.message.MaximalBodyDescriptor;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Message;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.csv.TextAndCSVParser;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.mailcommons.MailDateParser;
import org.apache.tika.parser.mailcommons.MailUtil;
import org.apache.tika.parser.txt.TXTParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.xml.sax.SAXException;

class MailContentHandler
implements ContentHandler {
    private static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    private final XHTMLContentHandler handler;
    private final Metadata metadata;
    private final ParseContext parseContext;
    private final boolean extractAllAlternatives;
    private final EmbeddedDocumentExtractor extractor;
    private final Detector detector;
    private boolean strictParsing = false;
    private Stack<Part> alternativePartBuffer = new Stack();
    private Stack<BodyDescriptor> parts = new Stack();

    MailContentHandler(XHTMLContentHandler xhtml, Detector detector, Metadata metadata, ParseContext context, boolean strictParsing, boolean extractAllAlternatives) {
        this.handler = xhtml;
        this.metadata = metadata;
        this.parseContext = context;
        this.strictParsing = strictParsing;
        this.extractAllAlternatives = extractAllAlternatives;
        this.extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        this.detector = detector;
    }

    public void body(BodyDescriptor body, InputStream is) throws MimeException, IOException {
        Metadata submd = new Metadata();
        submd.set("Content-Type", body.getMimeType());
        submd.set("Content-Encoding", body.getCharset());
        if (this.parts.size() > 0) {
            submd.set("Multipart-Subtype", this.parts.peek().getSubType());
            submd.set("Multipart-Boundary", this.parts.peek().getBoundary());
        }
        if (body instanceof MaximalBodyDescriptor) {
            this.handleMaximalBodyDescriptor((MaximalBodyDescriptor)body, submd);
        }
        if (!this.extractAllAlternatives && this.alternativePartBuffer.size() > 0) {
            UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            this.alternativePartBuffer.peek().children.add(new BodyContents(submd, bos.toByteArray()));
        } else if (!this.extractAllAlternatives && this.parts.size() < 2) {
            UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            byte[] bytes = bos.toByteArray();
            if (this.detectInlineTextOrHtml(submd, bytes)) {
                this.handleInlineBodyPart(new BodyContents(submd, bytes));
            } else {
                try (TikaInputStream tis = TikaInputStream.get((byte[])bytes);){
                    this.handleEmbedded(tis, submd);
                }
            }
        } else {
            try (TikaInputStream tis = TikaInputStream.get((InputStream)is);){
                this.handleEmbedded(tis, submd);
            }
        }
    }

    private void handleMaximalBodyDescriptor(MaximalBodyDescriptor body, Metadata submd) {
        String contentDispositionType = body.getContentDispositionType();
        if (contentDispositionType != null && !contentDispositionType.isEmpty()) {
            String contentDispositionFileName;
            String contentTypeName;
            StringBuilder contentDisposition = new StringBuilder(contentDispositionType);
            if ("attachment".equalsIgnoreCase(contentDispositionType)) {
                submd.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
            } else if ("inline".equalsIgnoreCase(contentDispositionType)) {
                submd.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.INLINE.toString());
            }
            Map contentDispositionParameters = body.getContentDispositionParameters();
            for (Map.Entry param : contentDispositionParameters.entrySet()) {
                contentDisposition.append("; ").append((String)param.getKey()).append("=\"").append((String)param.getValue()).append('\"');
                if ("creation-date".equalsIgnoreCase((String)param.getKey())) {
                    this.tryToAddDate((String)param.getValue(), TikaCoreProperties.CREATED, submd);
                    continue;
                }
                if (!"modification-date".equalsIgnoreCase((String)param.getKey())) continue;
                this.tryToAddDate((String)param.getValue(), TikaCoreProperties.MODIFIED, submd);
            }
            if (body.getContentTypeParameters() != null && !StringUtils.isBlank((String)(contentTypeName = (String)body.getContentTypeParameters().get("name")))) {
                submd.set("resourceName", contentTypeName);
            }
            if (!StringUtils.isBlank((String)(contentDispositionFileName = body.getContentDispositionFilename()))) {
                submd.set("resourceName", contentDispositionFileName);
            }
            submd.set("Content-Disposition", contentDisposition.toString());
        }
    }

    private void tryToAddDate(String value, Property property, Metadata metadata) {
        Date d = MailDateParser.parseDateLenient((String)value);
        if (d != null) {
            metadata.set(property, d);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean detectInlineTextOrHtml(Metadata submd, byte[] bytes) {
        String attachmentType = submd.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE);
        if (TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString().equals(attachmentType)) {
            return false;
        }
        String mediaTypeString = submd.get("Content-Type");
        if (mediaTypeString != null) {
            if (!mediaTypeString.startsWith("text")) return false;
            return true;
        }
        try (TikaInputStream tis = TikaInputStream.get((byte[])bytes);){
            MediaType mediaType = this.detector.detect((InputStream)tis, submd);
            if (mediaType == null) return false;
            submd.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, mediaType.toString());
            if (!mediaType.toString().startsWith("text")) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private void handleEmbedded(TikaInputStream tis, Metadata metadata) throws MimeException, IOException {
        if (metadata.get(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE) == null) {
            metadata.set(TikaCoreProperties.EMBEDDED_RESOURCE_TYPE, TikaCoreProperties.EmbeddedResourceType.ATTACHMENT.toString());
        }
        try {
            if (this.extractor.shouldParseEmbedded(metadata)) {
                this.extractor.parseEmbedded((InputStream)tis, (org.xml.sax.ContentHandler)this.handler, metadata, false);
            }
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endBodyPart() throws MimeException {
        if (this.alternativePartBuffer.size() > 0) {
            return;
        }
        try {
            this.handler.endElement("p");
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void endHeader() throws MimeException {
    }

    public void startMessage() throws MimeException {
    }

    public void endMessage() throws MimeException {
    }

    public void endMultipart() throws MimeException {
        if (this.alternativePartBuffer.size() == 1) {
            Part alternativeRoot = this.alternativePartBuffer.pop();
            try {
                this.handleBestParts(alternativeRoot);
            }
            catch (IOException e) {
                throw new MimeException((Throwable)e);
            }
        } else if (this.alternativePartBuffer.size() > 1) {
            this.alternativePartBuffer.pop();
        }
        if (this.parts.size() > 0) {
            this.parts.pop();
        }
    }

    public void epilogue(InputStream is) throws MimeException, IOException {
    }

    public void field(Field field) throws MimeException {
        block20: {
            if (this.parts.size() > 0) {
                return;
            }
            try {
                String fieldname = field.getName();
                ParsedField parsedField = LenientFieldParser.getParser().parse(field, DecodeMonitor.SILENT);
                if (fieldname.equalsIgnoreCase("From")) {
                    MailboxListField fromField = (MailboxListField)parsedField;
                    MailboxList mailboxList = fromField.getMailboxList();
                    if (fromField.isValidField() && mailboxList != null) {
                        for (Address address : mailboxList) {
                            String from = this.getDisplayString(address);
                            MailUtil.setPersonAndEmail((String)from, (Property)Message.MESSAGE_FROM_NAME, (Property)Message.MESSAGE_FROM_EMAIL, (Metadata)this.metadata);
                            this.metadata.add("Message-From", from);
                            this.metadata.add(TikaCoreProperties.CREATOR, from);
                        }
                    } else {
                        String from = this.stripOutFieldPrefix(field, "From:");
                        MailUtil.setPersonAndEmail((String)from, (Property)Message.MESSAGE_FROM_NAME, (Property)Message.MESSAGE_FROM_EMAIL, (Metadata)this.metadata);
                        if (from.startsWith("<")) {
                            from = from.substring(1);
                        }
                        if (from.endsWith(">")) {
                            from = from.substring(0, from.length() - 1);
                        }
                        this.metadata.add("Message-From", from);
                        this.metadata.add(TikaCoreProperties.CREATOR, from);
                    }
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("Subject")) {
                    this.metadata.set(TikaCoreProperties.TITLE, ((UnstructuredField)parsedField).getValue());
                    this.metadata.set(TikaCoreProperties.SUBJECT, ((UnstructuredField)parsedField).getValue());
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("To")) {
                    this.processAddressList(parsedField, "To:", "Message-To");
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("CC")) {
                    this.processAddressList(parsedField, "Cc:", "Message-Cc");
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("BCC")) {
                    this.processAddressList(parsedField, "Bcc:", "Message-Bcc");
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("Content-Type")) {
                    MediaType contentType = MediaType.parse((String)parsedField.getBody());
                    if (contentType.getType().equalsIgnoreCase("multipart")) {
                        this.metadata.set("Multipart-Subtype", contentType.getSubtype());
                        this.metadata.set("Multipart-Boundary", (String)contentType.getParameters().get("boundary"));
                    } else {
                        this.metadata.add("Message:Raw-Header:" + parsedField.getName(), field.getBody());
                    }
                    break block20;
                }
                if (fieldname.equalsIgnoreCase("Date")) {
                    String dateBody = parsedField.getBody();
                    Date date = null;
                    try {
                        date = MailDateParser.parseDateLenient((String)dateBody);
                        this.metadata.set(TikaCoreProperties.CREATED, date);
                        break block20;
                    }
                    catch (SecurityException e) {
                        throw e;
                    }
                    catch (Exception exception) {
                        break block20;
                    }
                }
                this.metadata.add("Message:Raw-Header:" + parsedField.getName(), field.getBody());
            }
            catch (RuntimeException me) {
                if (!this.strictParsing) break block20;
                throw me;
            }
        }
    }

    private void processAddressList(ParsedField field, String addressListType, String metadataField) throws MimeException {
        AddressListField toField = (AddressListField)field;
        if (toField.isValidField()) {
            AddressList addressList = toField.getAddressList();
            for (Address address : addressList) {
                this.metadata.add(metadataField, this.getDisplayString(address));
            }
        } else {
            String to = this.stripOutFieldPrefix((Field)field, addressListType);
            for (String eachTo : to.split(",")) {
                this.metadata.add(metadataField, eachTo.trim());
            }
        }
    }

    private String getDisplayString(Address address) {
        if (address instanceof Mailbox) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (name != null && name.length() > 0) {
                name = DecoderUtil.decodeEncodedWords((String)name, (DecodeMonitor)DecodeMonitor.SILENT);
                return name + " <" + mailbox.getAddress() + ">";
            }
            return mailbox.getAddress();
        }
        return address.toString();
    }

    public void preamble(InputStream is) throws MimeException, IOException {
    }

    public void raw(InputStream is) throws MimeException, IOException {
    }

    public void startBodyPart() throws MimeException {
        if (this.alternativePartBuffer.size() > 0) {
            return;
        }
        try {
            this.handler.startElement("div", "class", "email-entry");
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new MimeException((Throwable)e);
        }
    }

    public void startHeader() throws MimeException {
    }

    public void startMultipart(BodyDescriptor descr) throws MimeException {
        this.parts.push(descr);
        if (!this.extractAllAlternatives) {
            if (this.alternativePartBuffer.size() == 0 && MULTIPART_ALTERNATIVE.equalsIgnoreCase(descr.getMimeType())) {
                Part part = new Part(descr);
                this.alternativePartBuffer.push(part);
            } else if (this.alternativePartBuffer.size() > 0) {
                Part parent = this.alternativePartBuffer.peek();
                Part part = new Part(descr);
                this.alternativePartBuffer.push(part);
                if (parent != null) {
                    parent.children.add(part);
                }
            }
        }
    }

    private String stripOutFieldPrefix(Field field, String fieldname) {
        String temp = field.getRaw().toString();
        int loc = fieldname.length();
        while (temp.charAt(loc) == ' ') {
            ++loc;
        }
        return temp.substring(loc);
    }

    private void handleBestParts(Part part) throws MimeException, IOException {
        if (part == null) {
            return;
        }
        if (part instanceof BodyContents) {
            this.handleInlineBodyPart((BodyContents)part);
            return;
        }
        if (MULTIPART_ALTERNATIVE.equalsIgnoreCase(part.bodyDescriptor.getMimeType())) {
            int bestPartScore = -1;
            Part bestPart = null;
            for (Part alternative : part.children) {
                int score = this.score(alternative);
                if (score <= bestPartScore) continue;
                bestPart = alternative;
                bestPartScore = score;
            }
            this.handleBestParts(bestPart);
        } else {
            for (Part child : part.children) {
                this.handleBestParts(child);
            }
        }
    }

    private void handleInlineBodyPart(BodyContents part) throws MimeException, IOException {
        String contentType = part.metadata.get("Content-Type");
        Parser parser = null;
        boolean inlineText = false;
        if (MediaType.TEXT_HTML.toString().equalsIgnoreCase(contentType)) {
            parser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(HtmlParser.class, (ParseContext)this.parseContext);
        } else if (MediaType.TEXT_PLAIN.toString().equalsIgnoreCase(contentType) && (parser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(TXTParser.class, (ParseContext)this.parseContext)) == null) {
            parser = EmbeddedDocumentUtil.tryToFindExistingLeafParser(TextAndCSVParser.class, (ParseContext)this.parseContext);
            inlineText = true;
        }
        if (parser == null) {
            try (TikaInputStream tis = TikaInputStream.get((byte[])part.bytes);){
                this.handleEmbedded(tis, part.metadata);
            }
        }
        try {
            Metadata inlineMetadata = new Metadata();
            if (inlineText) {
                inlineMetadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, MediaType.TEXT_PLAIN.toString());
            }
            parser.parse((InputStream)new UnsynchronizedByteArrayInputStream(part.bytes), (org.xml.sax.ContentHandler)new EmbeddedContentHandler((org.xml.sax.ContentHandler)new BodyContentHandler((org.xml.sax.ContentHandler)this.handler)), inlineMetadata, this.parseContext);
        }
        catch (TikaException | SAXException e) {
            throw new MimeException(e);
        }
    }

    private int score(Part part) {
        if (part == null) {
            return 0;
        }
        if (part instanceof BodyContents) {
            String contentType = ((BodyContents)part).metadata.get("Content-Type");
            if (contentType == null) {
                return 0;
            }
            if (contentType.equalsIgnoreCase(MediaType.TEXT_PLAIN.toString())) {
                return 1;
            }
            if (contentType.equalsIgnoreCase("application/rtf")) {
                return 2;
            }
            if (contentType.equalsIgnoreCase(MediaType.TEXT_HTML.toString())) {
                return 3;
            }
        }
        return 4;
    }

    private static class BodyContents
    extends Part {
        private final Metadata metadata;
        private final byte[] bytes;

        private BodyContents(Metadata metadata, byte[] bytes) {
            super(null);
            this.metadata = metadata;
            this.bytes = bytes;
        }
    }

    private static class Part {
        private final BodyDescriptor bodyDescriptor;
        private final List<Part> children = new ArrayList<Part>();

        public Part(BodyDescriptor bodyDescriptor) {
            this.bodyDescriptor = bodyDescriptor;
        }

        public String toString() {
            return "Part{bodyDescriptor=" + this.bodyDescriptor + ", children=" + this.children + '}';
        }
    }
}

