/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.ssh;

import com.trilead.ssh2.Session;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.ssh.SessionResult;
import org.apache.hop.pipeline.transforms.ssh.SshData;
import org.apache.hop.pipeline.transforms.ssh.SshMeta;

public class Ssh
extends BaseTransform<SshMeta, SshData> {
    private static final Class<?> PKG = SshMeta.class;

    public Ssh(TransformMeta transformMeta, SshMeta meta, SshData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processRow() throws HopException {
        IRowMeta imeta;
        Object[] row;
        if (((SshMeta)this.meta).isDynamicCommandField()) {
            row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((SshData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((SshData)this.data).nrInputFields = ((SshData)this.data).outputRowMeta.size();
                ((SshMeta)this.meta).getFields(((SshData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((SshData)this.data).nrOutputFields = ((SshData)this.data).outputRowMeta.size();
                if (((SshMeta)this.meta).isDynamicCommandField()) {
                    if (Utils.isEmpty((CharSequence)((SshMeta)this.meta).getCommandFieldName())) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Error.CommandFieldMissing", (String[])new String[0]));
                    }
                    ((SshData)this.data).indexOfCommand = ((SshData)this.data).outputRowMeta.indexOfValue(((SshMeta)this.meta).getCommandFieldName());
                    if (((SshData)this.data).indexOfCommand < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Exception.CouldNotFindField", (String[])new String[]{((SshMeta)this.meta).getCommandFieldName()}));
                    }
                }
            }
        } else if (!((SshData)this.data).wroteOneRow) {
            row = new Object[]{};
            this.incrementLinesRead();
            ((SshData)this.data).wroteOneRow = true;
            if (this.first) {
                this.first = false;
                ((SshData)this.data).outputRowMeta = new RowMeta();
                ((SshData)this.data).nrInputFields = 0;
                ((SshMeta)this.meta).getFields(((SshData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((SshData)this.data).nrOutputFields = ((SshData)this.data).outputRowMeta.size();
                ((SshData)this.data).commands = this.resolve(((SshMeta)this.meta).getCommand());
            }
        } else {
            this.setOutputDone();
            return false;
        }
        if ((imeta = this.getInputRowMeta()) == null) {
            imeta = new RowMeta();
            this.setInputRowMeta(imeta);
        }
        Object[] rowData = new Object[((SshData)this.data).nrOutputFields];
        for (int i = 0; i < ((SshData)this.data).nrInputFields; ++i) {
            rowData[i] = row[i];
        }
        int index = ((SshData)this.data).nrInputFields;
        Session session = null;
        try {
            if (((SshMeta)this.meta).isDynamicCommandField()) {
                ((SshData)this.data).commands = ((SshData)this.data).outputRowMeta.getString(row, ((SshData)this.data).indexOfCommand);
                if (Utils.isEmpty((CharSequence)((SshData)this.data).commands)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"SSH.Error.MessageEmpty", (String[])new String[0]));
                }
            }
            session = ((SshData)this.data).conn.openSession();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionOpened", (String[])new String[0]));
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.Log.RunningCommand", (String[])new String[]{((SshData)this.data).commands}));
            }
            session.execCommand(((SshData)this.data).commands);
            SessionResult sessionresult = new SessionResult(session);
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.ExecutedSshCommand", (String[])new String[]{((SshData)this.data).commands, sessionresult.getStdOut(), sessionresult.getStdErr()}));
            }
            rowData[index++] = sessionresult.getStd();
            if (!Utils.isEmpty((CharSequence)((SshData)this.data).stdTypeField)) {
                rowData[index++] = sessionresult.isStdTypeErr();
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"SSH.Log.OutputLine", (String[])new String[]{((SshData)this.data).outputRowMeta.getString(rowData)}));
            }
            this.putRow(((SshData)this.data).outputRowMeta, rowData);
            if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"SSH.LineNumber", (String[])new String[]{"" + this.getLinesRead()}));
            }
        }
        catch (Exception e) {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            if (!this.getTransformMeta().isDoingErrorHandling()) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                boolean bl = false;
                return bl;
            }
            sendToErrorRow = true;
            errorMessage = e.toString();
            if (sendToErrorRow) {
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "SSH001");
            }
        }
        finally {
            if (session != null) {
                session.close();
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.SessionClosed", (String[])new String[0]));
                }
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((SshMeta)this.meta).getServerName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.MissingServerName", (String[])new String[0]));
            }
            if (Utils.isEmpty((CharSequence)((SshMeta)this.meta).getUserName())) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.UserNamedMissing", (String[])new String[0]));
                return false;
            }
            ((SshData)this.data).stdOutField = this.resolve(((SshMeta)this.meta).getStdOutFieldName());
            if (Utils.isEmpty((CharSequence)((SshData)this.data).stdOutField)) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.StdOutFieldNameMissing", (String[])new String[0]));
                return false;
            }
            ((SshData)this.data).stdTypeField = this.resolve(((SshMeta)this.meta).getStdErrFieldName());
            try {
                ((SshData)this.data).conn = SshData.openConnection((IVariables)this, (SshMeta)this.meta);
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"SSH.Log.ConnectionOpened", (String[])new String[0]));
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"SSH.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
                return false;
            }
            return true;
        }
        return false;
    }
}

