/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.cmd;

import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import javax.management.MBeanServerConnection;
import org.gridkit.jvmtool.JmxConnectionInfo;
import org.gridkit.jvmtool.MBeanGCMonitor;
import org.gridkit.jvmtool.cli.CommandLauncher;

public class GcRepCmd
implements CommandLauncher.CmdRef {
    public String getCommandName() {
        return "gc";
    }

    public Runnable newCommand(CommandLauncher host) {
        return new GcRep(host);
    }

    @Parameters(commandDescription="[Print GC] Print GC log like information for remote process")
    public static class GcRep
    implements Runnable {
        @ParametersDelegate
        private CommandLauncher host;
        @ParametersDelegate
        private JmxConnectionInfo conn;

        public GcRep(CommandLauncher host) {
            this.host = host;
            this.conn = new JmxConnectionInfo(host);
        }

        @Override
        public void run() {
            try {
                MBeanServerConnection mserver = this.conn.getMServer();
                System.out.println("MBean server connected");
                MBeanGCMonitor rmon = new MBeanGCMonitor(mserver);
                MBeanGCMonitor pmon = new MBeanGCMonitor(mserver);
                final MBeanGCMonitor fmon = new MBeanGCMonitor(mserver);
                Thread freport = new Thread(){

                    @Override
                    public void run() {
                        System.out.println("\nTotal");
                        System.out.println(fmon.calculateStats());
                    }
                };
                Runtime.getRuntime().addShutdownHook(freport);
                long interval = 60000L;
                long deadline = System.currentTimeMillis() + interval;
                System.out.println("Collecting GC stats ...");
                while (true) {
                    if (System.currentTimeMillis() < deadline) {
                        String report = rmon.reportCollection();
                        if (report.length() > 0) {
                            System.out.println(report);
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                    deadline += interval;
                    System.out.println();
                    System.out.println(pmon.calculateStats());
                    System.out.println();
                    pmon = new MBeanGCMonitor(mserver);
                    if (System.in.available() > 0) break;
                }
                return;
            }
            catch (Exception e) {
                this.host.fail(new String[]{e.toString()});
                return;
            }
        }
    }
}

