/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.eventhubs.write;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.eventhubs.write.AzureWriterMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class AzureWriterDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = AzureWriterMeta.class;
    private Text wTransformName;
    private TextVar wNamespace;
    private TextVar wEventHub;
    private TextVar wSasKeyName;
    private TextVar wSasKey;
    private TextVar wBatchSize;
    private ComboVar wMessageField;
    private AzureWriterMeta input;

    public AzureWriterDialog(Shell parent, IVariables variables, AzureWriterMeta inputMetadata, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)inputMetadata, pipelineMeta);
        this.input = inputMetadata;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText("Azure Event Hubs Writer");
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlNamespace = new Label((Composite)this.shell, 131072);
        wlNamespace.setText("Event Hubs namespace");
        PropsUi.setLook((Widget)wlNamespace);
        FormData fdlNamespace = new FormData();
        fdlNamespace.left = new FormAttachment(0, 0);
        fdlNamespace.right = new FormAttachment(middle, -margin);
        fdlNamespace.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlNamespace.setLayoutData((Object)fdlNamespace);
        this.wNamespace = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wNamespace);
        this.wNamespace.addModifyListener(lsMod);
        FormData fdNamespace = new FormData();
        fdNamespace.left = new FormAttachment(middle, 0);
        fdNamespace.right = new FormAttachment(100, 0);
        fdNamespace.top = new FormAttachment((Control)wlNamespace, 0, 0x1000000);
        this.wNamespace.setLayoutData((Object)fdNamespace);
        lastControl = this.wNamespace;
        Label wlEventHub = new Label((Composite)this.shell, 131072);
        wlEventHub.setText("Event Hubs instance name");
        PropsUi.setLook((Widget)wlEventHub);
        FormData fdlEventHub = new FormData();
        fdlEventHub.left = new FormAttachment(0, 0);
        fdlEventHub.right = new FormAttachment(middle, -margin);
        fdlEventHub.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlEventHub.setLayoutData((Object)fdlEventHub);
        this.wEventHub = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wEventHub);
        this.wEventHub.addModifyListener(lsMod);
        FormData fdEventHub = new FormData();
        fdEventHub.left = new FormAttachment(middle, 0);
        fdEventHub.right = new FormAttachment(100, 0);
        fdEventHub.top = new FormAttachment((Control)wlEventHub, 0, 0x1000000);
        this.wEventHub.setLayoutData((Object)fdEventHub);
        lastControl = this.wEventHub;
        Label wlSasKeyName = new Label((Composite)this.shell, 131072);
        wlSasKeyName.setText("SAS Policy key name");
        PropsUi.setLook((Widget)wlSasKeyName);
        FormData fdlSasKeyName = new FormData();
        fdlSasKeyName.left = new FormAttachment(0, 0);
        fdlSasKeyName.right = new FormAttachment(middle, -margin);
        fdlSasKeyName.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSasKeyName.setLayoutData((Object)fdlSasKeyName);
        this.wSasKeyName = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSasKeyName);
        this.wSasKeyName.addModifyListener(lsMod);
        FormData fdSasKeyName = new FormData();
        fdSasKeyName.left = new FormAttachment(middle, 0);
        fdSasKeyName.right = new FormAttachment(100, 0);
        fdSasKeyName.top = new FormAttachment((Control)wlSasKeyName, 0, 0x1000000);
        this.wSasKeyName.setLayoutData((Object)fdSasKeyName);
        lastControl = this.wSasKeyName;
        Label wlSasKey = new Label((Composite)this.shell, 131072);
        wlSasKey.setText("SAS Key connection string");
        PropsUi.setLook((Widget)wlSasKey);
        FormData fdlSasKey = new FormData();
        fdlSasKey.left = new FormAttachment(0, 0);
        fdlSasKey.right = new FormAttachment(middle, -margin);
        fdlSasKey.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlSasKey.setLayoutData((Object)fdlSasKey);
        this.wSasKey = new TextVar(this.variables, (Composite)this.shell, 0x404804);
        PropsUi.setLook((Widget)this.wSasKey);
        this.wSasKey.addModifyListener(lsMod);
        FormData fdSasKey = new FormData();
        fdSasKey.left = new FormAttachment(middle, 0);
        fdSasKey.right = new FormAttachment(100, 0);
        fdSasKey.top = new FormAttachment((Control)wlSasKey, 0, 0x1000000);
        this.wSasKey.setLayoutData((Object)fdSasKey);
        lastControl = this.wSasKey;
        Label wlBatchSize = new Label((Composite)this.shell, 131072);
        wlBatchSize.setText("Batch size");
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        fdlBatchSize.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        Label wlMessageField = new Label((Composite)this.shell, 131072);
        wlMessageField.setText("Message field");
        PropsUi.setLook((Widget)wlMessageField);
        FormData fdlMessageField = new FormData();
        fdlMessageField.left = new FormAttachment(0, 0);
        fdlMessageField.right = new FormAttachment(middle, -margin);
        fdlMessageField.top = new FormAttachment((Control)lastControl, 2 * margin);
        wlMessageField.setLayoutData((Object)fdlMessageField);
        this.wMessageField = new ComboVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wMessageField);
        this.wMessageField.addModifyListener(lsMod);
        FormData fdMessageField = new FormData();
        fdMessageField.left = new FormAttachment(middle, 0);
        fdMessageField.right = new FormAttachment(100, 0);
        fdMessageField.top = new FormAttachment((Control)wlMessageField, 0, 0x1000000);
        this.wMessageField.setLayoutData((Object)fdMessageField);
        lastControl = this.wMessageField;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.ok());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    public void getData() {
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wNamespace.setText(Const.NVL((String)this.input.getNamespace(), (String)""));
        this.wEventHub.setText(Const.NVL((String)this.input.getEventHubName(), (String)""));
        this.wSasKeyName.setText(Const.NVL((String)this.input.getSasKeyName(), (String)""));
        this.wSasKey.setText(Const.NVL((String)this.input.getSasKey(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wMessageField.setText(Const.NVL((String)this.input.getMessageField(), (String)""));
        try {
            this.wMessageField.setItems(this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames());
        }
        catch (HopTransformException hopTransformException) {
            // empty catch block
        }
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setNamespace(this.wNamespace.getText());
        this.input.setEventHubName(this.wEventHub.getText());
        this.input.setBatchSize(this.wBatchSize.getText());
        this.input.setSasKeyName(this.wSasKeyName.getText());
        this.input.setSasKey(this.wSasKey.getText());
        this.input.setMessageField(this.wMessageField.getText());
        this.dispose();
    }
}

