/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.graph;

import org.psjava.ds.Collection;
import org.psjava.ds.graph.Graph;
import org.psjava.ds.graph.GraphToString;
import org.psjava.ds.graph.MutableGraph;
import org.psjava.ds.graph.UndirectedEdge;
import org.psjava.util.AssertStatus;

public class MutableUndirectedGraph<V, E extends UndirectedEdge<V>>
implements Graph<V, E> {
    private MutableGraph<V, E> g = MutableGraph.create();

    public static <V, E extends UndirectedEdge<V>> MutableUndirectedGraph<V, E> create() {
        return new MutableUndirectedGraph<V, E>();
    }

    public void insertVertex(V v) {
        this.g.insertVertex(v);
    }

    public void addEdge(E e) {
        this.assertVertexExist(e.v1());
        this.assertVertexExist(e.v2());
        this.g.addEdge(e.v1(), e);
        this.g.addEdge(e.v2(), e);
    }

    private void assertVertexExist(V v) {
        AssertStatus.assertTrue(this.g.getVertices().contains(v), "vertex is not in graph");
    }

    @Override
    public Collection<V> getVertices() {
        return this.g.getVertices();
    }

    @Override
    public Iterable<E> getEdges(V v) {
        return this.g.getEdges(v);
    }

    public String toString() {
        return GraphToString.toString(this);
    }
}

